package com.yizhi.system.application.controller.manage;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.constant.SystemConstant;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.domain.AuthzUserGroup;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.util.CollectionUtil;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.enums.FileType;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.exp.AbstractExporter;
import com.yizhi.core.application.file.imp.AbstractImporter;
import com.yizhi.core.application.file.imp.ImportCallBack;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.task.TaskHandler;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.model.FileUploadModel;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.model.OrgImpModel;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.system.application.vo.OrganizationTreeListVo;
import com.yizhi.system.application.vo.OrganizationUserGroupVo;
import com.yizhi.system.application.vo.domain.Organization;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.util.application.tree.TreeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.weaver.ast.Or;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author yinyuyan
 * @since 2018-01-04
 */
@Api(tags = "组织部门管理接口")
@RestController
@RequestMapping("/manage/org")
public class OrganizationController {

    private static final Logger LOG = LoggerFactory.getLogger(OrganizationController.class);

    @Autowired
    IOrganizationService organizationService;
    @Autowired
    DomainConverter converter;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    LogEventPublisher publisher;
    @Autowired
    TaskExecutor taskExecutor;
    @Autowired
    AccountController accountController;
    @Autowired
    IAuthzAccountRoleService authzAccountRoleService;
    @Autowired
    private ISiteService siteService;
    @Autowired
    private IAuthzUserGroupService groupService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IAuthzRoleService roleService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private AuthzRoleManagerService authzRoleManagerService;
    @Autowired
    private OrganizationCacheService organizationCacheService;
    @Autowired
    private OrganizationIndexService organizationIndexService;
    @Value("${redis.manage.authz.expired}")
    private Long redisManageAuthzExpired;
    @Autowired
    private org.springframework.core.task.TaskExecutor executor;

    /**
     * 新增组织机构
     *
     * @param orgVO
     * @return
     */
    @ApiOperation(value = "新增一个组织机构", notes = "新增一个组织机构")
    @PostMapping("/insert")
    public Response<String> insert(@RequestBody OrgVO orgVO) {
        try {
            List<String> names = new ArrayList<>();
            names.add(orgVO.getName());
            names = existedOrgNameCheck(ContextHolder.get().getCompanyId(), orgVO.getParentId(), names, null);
            if (CollectionUtils.isNotEmpty(names)) {
                return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER5.getCode());
            }
            if (StringUtils.isEmpty(orgVO.getCode())) {
                orgVO.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            orgVO.setCompanyId(ContextHolder.get().getCompanyId());
            com.yizhi.system.application.domain.Organization organization =  (com.yizhi.system.application.domain.Organization)converter.toDO(orgVO, com.yizhi.system.application.domain.Organization.class);
            organizationService.insertDetail(organization);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 删除一个组织机构
     *
     * @param orgVO
     * @return
     */
    @ApiOperation(value = "删除一个组织机构", notes = "删除一个组织机构（会同步循环删除该节点下所有子节点）")
    @PostMapping("/delete")
    public Response<String> delete(@RequestBody OrgVO orgVO) {
        try {
            organizationService.delete(orgVO.getId(), ContextHolder.get().getCompanyId());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除组织", notes = "批量删除组织（会同步循环删除节点下所有子节点）")
    @PostMapping("/delete/batch")
    public Response<String> deleteBacth(@RequestParam("ids") Long[] ids) {
        try {
            organizationService.batchDelete(ids, ContextHolder.get().getCompanyId());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更新组织机构
     *
     * @param orgVO
     * @return
     */
    @ApiOperation(value = "修改组织机构", notes = "根据id更新组织机构")
    @PostMapping(value = "/update")
    public Response<String> update(@RequestBody OrgVO orgVO) {
        LOG.info("传入的对象内容：{}",orgVO.getName()+":::"+orgVO.getId()+":::"+orgVO.getParentId()+":::"+orgVO.getDescription());
        try {
            if (null == orgVO.getId()) {
                return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER1.getCode());
            }
            com.yizhi.system.application.domain.Organization oldOne = organizationService.selectById(orgVO.getId());
            if (null == oldOne) {
                return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER2.getCode());
            }
            if (oldOne.getCode().indexOf(AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX) != -1) {
                return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER3.getCode());
            }
            // 检查code
            if (StringUtils.isNotEmpty(orgVO.getCode())) {
                com.yizhi.system.application.domain.Organization organization = new com.yizhi.system.application.domain.Organization();
                organization.setCode(orgVO.getCode());
                organization.setCompanyId(ContextHolder.get().getCompanyId());
                organization.setDeleted(false);
                organization = organization.selectOne(new EntityWrapper(organization));
                if (organization != null && !organization.getId().equals(orgVO.getId())) {
                    return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER4.getCode());
                }
            }
            List<String> names = new ArrayList<>();
            names.add(orgVO.getName());
            names = existedOrgNameCheck(ContextHolder.get().getCompanyId(), orgVO.getParentId(), names, orgVO.getId());
            if (CollectionUtils.isNotEmpty(names)) {
                return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER5.getCode());
            }
            if (StringUtils.isEmpty(orgVO.getCode())) {
                orgVO.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            }
//            com.yizhi.system.application.domain.Organization organization = (com.yizhi.system.application.domain.Organization) converter.toDO(orgVO, com.yizhi.system.application.domain.Organization.class);
            com.yizhi.system.application.domain.Organization organization=new com.yizhi.system.application.domain.Organization();
            organization.setId(orgVO.getId());
            organization.setCompanyId(orgVO.getCompanyId());
            organization.setParentId(orgVO.getParentId());
            organization.setDescription(orgVO.getDescription());
            organization.setName(orgVO.getName());
            organizationService.update(organization);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 查找单个组织机构
     *
     * @param id Id
     * @return
     */
    @ApiOperation(value = "根据id查找单个组织机构", notes = "根据id查找单个组织机构")
    @GetMapping(value = "/get")
    public Response<OrgVO> findById(@RequestParam("id") long id) {
        try {
            com.yizhi.system.application.domain.Organization organization = organizationService.selectById(id);
            if (organization == null) {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
            return Response.ok((OrgVO) converter.toVO(organization, OrgVO.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查找单个组织机构
     *
     * @param code
     * @return
     */
    @ApiOperation(value = "根据code查找单个组织机构", notes = "根据code查找单个组织机构")
    @GetMapping(value = "/code/get")
    public Response<OrgVO> findByCode(@RequestParam("code") String code) {
        try {
            com.yizhi.system.application.domain.Organization organization = organizationService.findByCode(code, ContextHolder.get().getCompanyId());
            if (organization == null) {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
            return Response.ok((OrgVO) converter.toVO(organization, OrgVO.class));
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 分页查询组织机构
     *
     * @param orgVO
     * @param pageInfo
     * @return
     */
    @ApiOperation(value = "分页查询组织机构", notes = "分页查询组织机构")
    @GetMapping(value = "/list")
    public Response<PageInfo<OrgVO>> listByPage(OrgVO orgVO, PageInfo pageInfo) {
        Page<com.yizhi.system.application.domain.Organization> page = null;
        orgVO.setCompanyId(ContextHolder.get().getCompanyId());
        try {
            page = organizationService.list((com.yizhi.system.application.domain.Organization) converter.toDO(orgVO, com.yizhi.system.application.domain.Organization.class), PageUtil.vice(pageInfo));
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok((Page<OrgVO>) converter.toPageVO(page, OrgVO.class));
    }

    /**
     * @param id
     * @return
     */
    @ApiOperation(value = "查询当前组织机构下的子节点", notes = "查询当前组织机构下的子节点")
    @GetMapping(value = "/child/list")
    public Response<List<Organization>> list(@RequestParam(name = "id", defaultValue = "0") Long id) {
        try {
            List<com.yizhi.system.application.domain.Organization> result = organizationService.listChildren(id);
            return Response.ok(converter.toDOList(result,Organization.class));
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    /**
     * 检查该组织下是否有子数据
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "查询当前组织机构下的子节点", notes = "查询当前组织机构下是否有子组织机构 true:有；false:没有")
    @GetMapping(value = "/child/check")
    public Response<Boolean> chedkHasChild(@RequestParam("id") Long id) {
        try {
            Boolean result = organizationService.listChildren(id).size() > 0;
            return Response.ok(result);
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 检查是否已经存在该code
     *
     * @param code
     * @return
     */
    @ApiOperation(value = "检查code是否已经存在", notes = "检查code是否已经存在")
    @GetMapping(value = "/code/check")
    public Response<String> checkCode(@RequestParam("code") String code) {
        try {
            organizationService.countExistCodeOrg(0L, ContextHolder.get().getCompanyId(), code);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 检查是否已经存在该name
     *
     * @param name
     * @return
     */
    @ApiOperation(value = "检查name是否已经存在", notes = "检查name是否已经存在")
    @GetMapping(value = "/name/check")
    public Response<String> checkName(@RequestParam("name") String name) {
        try {
            organizationService.countExistNameOrg(0L, ContextHolder.get().getCompanyId(), name);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 批量导入部门
     *
     * @param model
     * @return
     */
    @ApiOperation(value = "批量导入部门", notes = "批量导入部门")
    @PostMapping(value = "/import")
    public Response<String> importOrgs(@RequestBody FileUploadModel model) {
        LOG.info("导入文件信息=====" + JSON.toJSONString(model));
        String taskLogSerialNo = "ORG-" + DateUtil.getYMDHMSS();
        try {
            Long taskId = idGenerator.generate();
            RequestContext context = ContextHolder.get();
            Long companyId = context.getCompanyId();
            Long siteId = context.getSiteId();
            Long accountId = context.getAccountId();
            TaskContext taskContext = new TaskContext(taskId, taskLogSerialNo, "批量导入组织部门", accountId, new Date(), siteId, companyId);
            ImportModel importModel = (ImportModel) converter.toDO(context, ImportModel.class);
            importModel.setTaskId(taskId);
            ImportCallBack callBack = new ImportCallBack() {
                @Override
                public Boolean exec(TaskHandler taskHandler, List dataObjs) {
                    importModel.setData(dataObjs);
                    List<OrgImpModel> models = organizationService.orgImport(importModel);
                    //所有的信息要上传到oss服务器
                    AbstractExporter<OrgImpModel> exporter = AbstractExporter.build(FileType.XLS, createExpTemplate(), models);
                    exporter.bindContext(taskContext);
                    exporter.bindPublisher(publisher);
                    exporter.handle();
                    return true;
                }
            };
            //"D:/importpath"
            AbstractImporter importer = AbstractImporter.build(model.getFileUrl(), null, model.getFileName(), callBack, createImpTemplate(), OrgImpModel.class);
            importer.bindContext(taskContext);
            importer.bindPublisher(publisher);
            taskExecutor.asynExecute(importer);
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok(taskLogSerialNo);
    }

    @ApiOperation(value = "组织部门列表 -- 权限改造", response = OrganizationTreeListVo.class)
    @GetMapping(value = "/userGroup/list")
    public Response<OrganizationTreeListVo> treeList(
            @ApiParam(value = "业务发起类型,</br>" +
                    "课程：course</br>" +
                    "证书：certificate</br>" +
                    "考试：exam</br>" +
                    "调研：research</br>" +
                    "投票：vote</br>" +
                    "做课：lesson</br>" +
                    "学习营销：marketingCourse</br>" +
                    "直播：live</br>" +
                    "作业：assignment</br>" +
                    "项目：trainingProject</br>" +
                    "消息：message</br>" +
                    "banner：banner</br>" +
                    "积分：point</br>" +
                    "站点：site</br>" +
                    "系统：system</br>")
            @RequestParam("type") String type
    ) {
        try {
            RequestContext context = ContextHolder.get();
            Long siteId = context.getSiteId();
            Boolean isAdmin = context.isAdmin();
            Long companyId = context.getCompanyId();
            String companyCode = context.getCompanyCode();
            Boolean isAllOrg = false;

            Site site = siteService.selectById(siteId);
            if (null != site) {
                List<CommonTree> trees = null;
                List<com.yizhi.system.application.domain.AuthzUserGroup> userGroups = null;
                // 1. 如果是站点管理员
                if (isAdmin) {
                    // 1.1 如果是默认站点，查出所有部门
                    if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                        trees = getAllOrgTree(companyId, companyCode);
                    }
                    // 1.2 如果不是默认站点
                    else {
                        trees = getSiteOrgTree(siteId, companyId, companyCode);
                        userGroups = groupService.selectBatchIds(CollectionUtil.getArrayList(site.getUserGroupId()));
                    }
                }
                // 2. 如果是业务管理员
                else {
                    // 2.1 根据类型值查询出模块 --> 查询出角色
                    List<Long> roleIds = roleService.getIdByModuleCodeInSite(context.getCompanyId(),
                            context.getSiteId(), context.getAccountId(), type);
                    if (!CollectionUtils.isEmpty(roleIds)) {
                        // 2.2  --> 查出管辖的部门(包含下级部门)
                        Set<Long> orgIds = getOrgIdsByRoleIds(roleIds);
                        if (!CollectionUtils.isEmpty(orgIds)) {
                            List<com.yizhi.system.application.domain.Organization> organizations = organizationService.selectBatchIds(orgIds);
                            List<Organization> list = converter.toDOList(organizations, Organization.class);
                            trees = buildOrgTree(list, false);
                        }
                        // 2.3 如果是系统管理的，还要查询出管辖区--> 查询出角色下管辖的部门、和管辖的管辖区
                        if (type.equalsIgnoreCase(SystemConstant.TYPE_SYSTEM)) {
                            Set<Long> groupIds = getGroupIdsByRoleIds(roleIds);
                            userGroups = groupService.selectBatchIds(groupIds);
                        }
                    }
                }

                // 返回结果
                OrganizationTreeListVo vo = new OrganizationTreeListVo();
                vo.setTrees(trees);
                if (!CollectionUtils.isEmpty(userGroups)) {
                    List<OrganizationUserGroupVo> userGroupVos = new ArrayList<>();
                    for (AuthzUserGroup userGroup : userGroups) {
                        OrganizationUserGroupVo userGroupVo = new OrganizationUserGroupVo();
                        userGroupVo.setId(userGroup.getId());
                        userGroupVo.setName(userGroup.getName());
                        userGroupVos.add(userGroupVo);
                    }
                    vo.setUserGroups(userGroupVos);
                }
                return Response.ok(vo);
            }
            return Response.fail("4001", InternationalEnums.ORGANIZATIONCONTROLLER6.getCode());
        } catch (Exception e) {
            LOG.error("", e);
            return Response.fail(e.getMessage());
        }
    }

    /**
     * 管辖区内的人员id
     */
    @GetMapping(value = "/group/accountId/list")
    public List<Long> getAccountIds() {
        RequestContext context = ContextHolder.get();
        if (context.isAdmin()) {
            return null;
        }
        LOG.info("当前的循上下文：",JSON.toJSON(context));
//        List<AuthzRoleMenu> authzRoleMenus = authzAccountRoleService.selectMenuListByAccountId(context.getAccountId(), 261L);
//        LOG.info("当前的管理员权限：",JSON.toJSON(authzRoleMenus));
//        if (CollectionUtils.isEmpty(authzRoleMenus)) {
//            List<Object> objects = Collections.emptyList();
//            return Collections.emptyList();
//        }

        Response<OrganizationTreeListVo> organizationTreeListVoResponse = this.treeList("system");
        OrganizationTreeListVo vo = (OrganizationTreeListVo) organizationTreeListVoResponse.getData();
        // 组织id
        List<CommonTree> trees = vo.getTrees();
        LOG.info("获取组织:{}", JSON.toJSON(trees));
        List<Long> accountIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(trees)) {
            List<Long> treeIds = new ArrayList<>();
            for (CommonTree tree : trees) {
                LOG.info("当前的实体：{}",tree);
//                Object id = tree.getId();
                Long id = Long.valueOf(String.valueOf(tree.getId()));
                LOG.info("当前的id：{}",id);
                Response<PageInfo<AccountVO>> pageInfoResponse = accountController.orgAccountListPage(id, null, null, null, null, 1, 1, Integer.MAX_VALUE);
                if (pageInfoResponse != null) {
                    PageInfo<AccountVO> data = (PageInfo<AccountVO>) pageInfoResponse.getData();
                    List<AccountVO> records = data.getRecords();
                    if (CollectionUtils.isNotEmpty(records)) {
                        List<Long> ids = records.parallelStream().map(accountVO -> {
                            return accountVO.getId();
                        }).collect(Collectors.toList());
                        treeIds.addAll(ids);
                    }
                }
            }
            LOG.info("获取组织人数:{}", JSON.toJSON(treeIds));
            accountIds.addAll(treeIds);
        }
        //
        List<OrganizationUserGroupVo> userGroupVos = vo.getUserGroups();
        LOG.info("获取管辖区:{}", JSON.toJSON(userGroupVos));
        if (CollectionUtils.isNotEmpty(userGroupVos)) {
            List<Long> groupIds = new ArrayList<>();
            for (OrganizationUserGroupVo groupVO : userGroupVos) {
                Response<PageInfo<AccountVO>> list = accountController.list(groupVO.getId(), null, null, null, null, 1, 1, Integer.MAX_VALUE);
                if (list != null) {
                    PageInfo<AccountVO> data = (PageInfo<AccountVO>) list.getData();
                    List<AccountVO> records = data.getRecords();
                    if (CollectionUtils.isNotEmpty(records)) {
                        List<Long> ids = records.parallelStream().map(accountVO -> {
                            return accountVO.getId();
                        }).collect(Collectors.toList());
                        groupIds.addAll(ids);
                    }
                }
            }
            LOG.info("获取管辖区的用户人数:{}", JSON.toJSON(groupIds));
            accountIds.addAll(groupIds);
        }
        return accountIds;

    }

    @ApiOperation(value = "重新建立索引")
    @PostMapping("/index/rebuild")
    public Response<Boolean> rebuildOrgIndex(@RequestBody ArrayList<String> companyCodes) {
        executor.execute(() -> {
            if (CollectionUtils.isNotEmpty(companyCodes)) {
                LOG.info("------------开始 部门 重新建立索引，涉及相关企业：{}---------------", companyCodes);
                companyCodes.forEach(item -> {
                    long companyId = organizationIndexService.initLeftRight(item);
                    organizationIndexService.initParentIdLayer(companyId);
                });
                LOG.info("------------完成 部门 重新建立索引，涉及相关企业：{}---------------", companyCodes);
            } else {
                LOG.info("------------开始 部门 重新建立索引，涉及相关企业：全部---------------");
                List<com.yizhi.system.application.domain.Company> companies = companyService.selectList(new EntityWrapper<>());
                if (CollectionUtils.isNotEmpty(companies)) {
                    companies.forEach(item -> {
                        LOG.info("------------开始 重新建立全部索引，进度到达企业：{}---------------", item.getCode());
                        organizationIndexService.initLeftRight(item.getId());
                        organizationIndexService.initParentIdLayer(item.getId());
                        LOG.info("------------完成 重新建立全部索引，进度到达企业：{}---------------", item.getCode());
                    });
                }
                LOG.info("------------完成 部门 重新建立索引，涉及相关企业：全部---------------");
            }
        });
        return Response.ok(true);
    }


    private Template createImpTemplate() {
        Template template = new Template();
        List<TemplateColumn> columns = new ArrayList<>();
        columns.add(new TemplateColumn("code", "编码", 1));
        columns.add(new TemplateColumn("name", "名称", 2));
        columns.add(new TemplateColumn("parentCode", "上级部门编码", 3));
        template.setColumns(columns);
        return template;
    }

    private Template createExpTemplate() {
        Template template = createImpTemplate();
        List<TemplateColumn> columns = template.getColumns();
        columns.add(new TemplateColumn("result", "结果", 4));
        template.setColumns(columns);
        template.setBrowserExport(false);
        return template;
    }

    /**
     * 根据角色id 获取管理的部门
     *
     * @param roleIds
     * @return
     */
    private Set<Long> getOrgIdsByRoleIds(List<Long> roleIds) {
        return organizationService.getByRoleId4UnionSet(roleIds, true);
    }

    /**
     * 根据角色id 获取管理的用户组
     *
     * @param roleIds
     * @return
     */
    private Set<Long> getGroupIdsByRoleIds(List<Long> roleIds) {
        return groupService.getByRoleId(roleIds);
    }

    /**
     * 组织架构下同级下组织名称不可以重复校验
     *
     * @param companyId
     * @param parentId
     * @param orgNames
     * @param id        修改时，排除自己
     * @return
     */
    public List<String> existedOrgNameCheck(Long companyId, Long parentId, List<String> orgNames, Long id) {
        if (CollectionUtils.isNotEmpty(orgNames)) {
            com.yizhi.system.application.domain.Organization organization = new com.yizhi.system.application.domain.Organization();
            organization.setParentId(parentId);
            organization.setCompanyId(companyId);
            organization.setDeleted(Boolean.valueOf(false));
            EntityWrapper<com.yizhi.system.application.domain.Organization> ew = new EntityWrapper<>(organization);
            ew.in("name", orgNames);
            if (id != null) {
                ew.notIn("id", id);
            }
            List<com.yizhi.system.application.domain.Organization> organizations = organizationService.selectList(ew);
            if (CollectionUtils.isNotEmpty(organizations)) {
                List<String> result = new ArrayList<>(organizations.size());
                for (com.yizhi.system.application.domain.Organization o : organizations) {
                    result.add(o.getName());
                }
                return result;
            }
        }
        return null;
    }

    /**
     * 查出所有部门
     *
     * @param companyId
     * @param companyCode
     * @return
     */
    private List<CommonTree> getAllOrgTree(Long companyId, String companyCode) {
        // 先从缓存查
        Object object = redisCache.hget(CacheNamespace.REDIS_COMPANY_ORGS, companyCode);
        if (null != object) {
            return JsonUtil.json2List(object.toString(), CommonTree.class);
        }
        // 缓存未命中
        else {
            Company company = companyService.selectById(companyId);
            return organizationCacheService.cacheCompanyOrganization(company);
        }
    }

    private List<CommonTree> getSiteOrgTree(Long siteId, Long companyId, String companyCode) {
        return organizationService.getBySiteId(siteId, companyId, companyCode);
    }

    /**
     * 组建树形结构
     *
     * @param organizations
     * @param isAllOrg
     * @return
     */
    private List<CommonTree> buildOrgTree(List<Organization> organizations, boolean isAllOrg) {
        if (CollectionUtils.isNotEmpty(organizations)) {
            List<CommonTree> trees = new ArrayList<>();
            for (Organization o : organizations) {
                CommonTree tree = new CommonTree();
                tree.setNode(o);
                tree.setName(o.getName());
                tree.setPId(o.getParentId());
                tree.setId(o.getId());
                trees.add(tree);
            }
            if (isAllOrg) {
                return TreeUtil.buildTree(trees, 0L);
            } else {
                return TreeUtil.buildTree(trees);
            }
        }
        return null;
    }


}

