package com.yizhi.system.application.controller.oauth2;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * 轻学堂Oauth2 认证流程
 *
 * @author admin
 */
@Api(tags = "轻学堂H5接口")
@RestController
@RequestMapping(value = "/public/oauth2")
public class Oauth2Controller {



    private static final Logger LOG = LoggerFactory.getLogger(Oauth2Controller.class);

    @Autowired
    private IAccountService accountService;

    @Autowired
    private ICompanyService companyService;

    @Autowired
    private RedisCache redisCache;

    @Value("${xmly_app_id}")
    private String APP_ID;

    @Value("${xmly_app_secret}")
    private String APP_SECRET;

    /**
     * 获取access_token
     *
     * @param appid
     * @param secret
     * @param code
     * @param grant_type
     * @return
     */
    @GetMapping(value = "/access_token",produces = "application/json;charset=utf-8")
    public String access_token(@RequestParam(required = true) String appid,
                               @RequestParam(required = true) String secret, @RequestParam(required = true) String code,
                               @RequestParam(required = true) String grant_type) {

        LOG.info("appid:" + appid + ";secret:" + secret + ";code:" + code + ";grant_type=" + grant_type);
        Map<String, Object> map = new HashMap<String, Object>();
        Long expires = 7200L;
        Long curTime = System.currentTimeMillis();
        String md5Code = DigestUtils.md5Hex(code);

        if (!appid.equals(APP_ID)) {
            map.put("code", -1);
            map.put("msg", Constants.APP_ID_FAIL.getName());
            return JSON.toJSONString(map);
        }
        if (!grant_type.equals("authorization_code")) {
            return "";
        }
        String hget = (String) redisCache.hget(md5Code, md5Code);
        LOG.info("返回的redis hget：{}", hget);
        map.put("expires_in", expires);

        if (hget == null) {
            com.yizhi.system.application.domain.Account account = accountService.selectById(Long.parseLong(code));
            LOG.info("查询用户信息：{}", JSON.toJSON(account));
            if (account == null) {
                map.put("code", Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST);
                return JSON.toJSONString(map);
            }
            map.put("auth_corpid", account.getCompanyId());
            redisCache.hset(md5Code, md5Code, "" + account.getCompanyId() + "_" + curTime, expires);

            map.put("access_token", md5Code);
            map.put("refresh_token", md5Code);
            map.put("openid", code);
        } else {
            String[] split = hget.split("_");
            expires = expires - ((curTime - Long.parseLong(split[1])) / 1000);
            map.put("auth_corpid", split[0]);
            map.put("access_token", md5Code);
            map.put("refresh_token", md5Code);
            map.put("openid", code);
        }
        LOG.info("获取到的accessToken：{}", JSON.toJSON(map));
        return JSON.toJSONString(map);
    }

    @GetMapping(value = "/corpinfo",produces ="application/json;charset=utf-8" )
    public String corpinfo(@RequestParam(required = true) String appid,
                           @RequestParam(required = true) String auth_corpid, @RequestParam(required = true) String sign) {
        Map<String, Object> map = new HashMap<String, Object>();
        String md5 = "appid=" + appid + "&auth_corpid=" + auth_corpid + "&appSecret=" + APP_SECRET;
        LOG.info("当前参数：{}", md5);


        String md5Hex = DigestUtils.md5Hex(md5);
        LOG.info("加密后的：{}", md5Hex);

        if (!appid.equals(APP_ID)) {
            map.put("code", -1);
            map.put("msg", Constants.APP_ID_FAIL.getName());
            return JSON.toJSONString(map);
        }
        sign = sign.toUpperCase();
        if (!md5Hex.toUpperCase().equals(sign)) {
            map.put("code", -1);
            map.put("msg", Constants.SIGN_FAIL.getName());
            return JSON.toJSONString(map);
        }
        Company company = companyService.selectById(Long.parseLong(auth_corpid));
        LOG.info("返回企业的company信息：{}", JSON.toJSON(company));

        if (company == null) {
            map.put("code", -1);
            map.put("msg", Constants.AUTH_CORPID_FAIL.getName());
            return JSON.toJSONString(map);
        }


        map.put("auth_corpid", company.getId());
        map.put("auth_corpname", company.getName());
        return JSON.toJSONString(map);
    }

    @GetMapping(value = "/userinfo",produces = "application/json;charset=utf-8" )
    public String userinfo(@RequestParam(required = true) String access_token,
                           @RequestParam(required = true) String openid) {
        Map<String, Object> map = new HashMap<String, Object>(8);
        if (!redisCache.exists(access_token)) {
            map.put("code", -1);
            map.put("msg", Constants.ACCESS_TOKEN_NO_EXIST.getName());
            return JSON.toJSONString(map);
        }
        com.yizhi.system.application.domain.Account account = accountService.selectById(Long.parseLong(openid));
        LOG.info("返回用户account的信息：{}", JSON.toJSON(account));
        if (account == null) {
            map.put("code", -1);
            map.put("msg", Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST.getName());
            return JSON.toJSONString(map);
        }
        map.put("auth_corpid", account.getCompanyId());
        map.put("openid", account.getId());
        map.put("nickname", account.getName());
        map.put("username", account.getFullName());
        Integer gender = 0;
        if ("M".equals(account.getSex())) {
            gender =1;
        } else if("F".equals(account.getSex())) {
            gender = 2 ;
        }
        map.put("gender", gender);
        map.put("avatar", account.getHeadPortrait());
        map.put("mobile", account.getMobile());
        map.put("empno", account.getWorkNum());
        return JSON.toJSONString(map);
    }
}
