package com.yizhi.system.application.controller.remote;

import java.util.List;

import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.vo.domain.LanguageClassify;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.service.LanguageClassifyService;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/remote/languageClassify")
public class LanguageClassifyController {

	@Autowired
	private LanguageClassifyService languageClassifyService;

	@Autowired
	DomainConverter domainConverter;

	@ApiOperation("新增语种")
	@PostMapping("/save")
	public int save(@RequestBody LanguageClassify languageClassify) {
		com.yizhi.system.application.domain.LanguageClassify languageClassify1 = new com.yizhi.system.application.domain.LanguageClassify();
		BeanUtils.copyProperties(languageClassify,languageClassify1);
		return languageClassifyService.save(languageClassify1);
	}
	
	@ApiOperation("修改语种")
	@PostMapping("/update")
	public int update(@RequestBody LanguageClassify languageClassify) {
		com.yizhi.system.application.domain.LanguageClassify languageClassify1 = new com.yizhi.system.application.domain.LanguageClassify();
		BeanUtils.copyProperties(languageClassify,languageClassify1);
		return languageClassifyService.update(languageClassify1);
	}
	
	@ApiOperation("删除语种")
	@GetMapping("/delete")
	public int delete(@RequestParam(name = "id") Long id) {
		return languageClassifyService.delete(id);
	}
	
	@ApiOperation("语种排序")
	@PostMapping("/sort")
	public int sort(@RequestBody List<LanguageClassify> languageClassifies) {
		List<com.yizhi.system.application.domain.LanguageClassify> list = domainConverter.toDOList(languageClassifies, com.yizhi.system.application.domain.LanguageClassify.class);
		return languageClassifyService.sort(list);
	}
	
	@ApiOperation("语种列表")
	@GetMapping("/list")
	public List<LanguageClassify> list(@RequestParam(name = "type") Integer type){
		com.yizhi.system.application.domain.LanguageClassify classify = new com.yizhi.system.application.domain.LanguageClassify();
		classify.setDeleted(0);
		if (type!=0) {
			classify.setState(0);
		}
		EntityWrapper<com.yizhi.system.application.domain.LanguageClassify> wrapper = new EntityWrapper<com.yizhi.system.application.domain.LanguageClassify>(classify);
		wrapper.orderBy("sort", false);
		List<com.yizhi.system.application.domain.LanguageClassify> list = languageClassifyService.selectList(wrapper);
		return domainConverter.toDOList(list,LanguageClassify.class);
		
	}
}
