package com.yizhi.system.application.controller.remote;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.yizhi.system.application.domain.LanguageClassify;
import com.yizhi.system.application.domain.LanguageTranslation;
import com.yizhi.system.application.domain.LanguageWord;
import com.yizhi.system.application.task.LanguageExport;
import com.yizhi.system.application.task.LanguageImport;
import com.yizhi.system.application.task.LanguageUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.LanguageClassifyService;
import com.yizhi.system.application.service.LanguageTranslationService;
import com.yizhi.system.application.service.LanguageWordService;
import com.yizhi.system.application.vo.LanguageParam;
import com.yizhi.system.application.vo.LanguageVo;


@RestController
@RequestMapping("/language")
public class LanguageController {

    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageController.class);
    
	@Autowired
	private LanguageClassifyService languageClassifyService;
	
	@Autowired
	private LanguageImport languageImport;
	
	@Autowired
	private LanguageWordService languageWordService;
	
	@Autowired
	private LanguageUpload languageUpload;
	
	@Autowired
	private LanguageTranslationService languageTranslationService;
	
	@Autowired
	private IdGenerator idGenerator;
	
	@Autowired
	private LanguageExport languageExport;
	
	@PostMapping("/upload")
	public String upload(@RequestBody LanguageParam param) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Date date = new Date();
        String url = param.getOssUrl();
        Long classifyId = param.getClassifyId();
        Integer type = param.getType();
        com.yizhi.system.application.domain.LanguageClassify classify = languageClassifyService.selectById(classifyId);
        Long taskId = date.getTime();
        String serialNo = "LANGUAGE-IMPORT-" + taskId.toString();
        String taskName = "导入翻译-"+classify.getName();
        String result = "任务编号："+serialNo+"。任务名称："+taskName;
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("res", res);
        map.put("url", url);
        map.put("classify", classify);
        map.put("type", type);
        languageImport.execute(map, true);
		return result;
	}
	
	@PostMapping("/update")
	public int update(@RequestBody LanguageVo vo) {
		RequestContext context = ContextHolder.get();
		Long accountId = context.getAccountId();
		String accountName = context.getAccountName();
		Date date = new Date();
		com.yizhi.system.application.domain.LanguageWord word = new com.yizhi.system.application.domain.LanguageWord();
		word.setType(vo.getType());
		word.setKey(vo.getKey());
		LanguageWord one = languageWordService.selectOne(new EntityWrapper<com.yizhi.system.application.domain.LanguageWord>(word));
		if (one!=null) {
			one.setChinese(vo.getChinese());
			if (StringUtils.isNotBlank(vo.getDescription())) {
				one.setDescription(vo.getDescription());
			}
			one.setState(1);
			one.setUpdateById(accountId);
			one.setUpdateByName(accountName);
			one.setUpdateTime(date);
			com.yizhi.system.application.domain.LanguageTranslation translation = new LanguageTranslation();
			translation.setClassifyId(vo.getClassifyId());
			translation.setWordId(one.getId());
			com.yizhi.system.application.domain.LanguageTranslation one2 = languageTranslationService.selectOne(new EntityWrapper<com.yizhi.system.application.domain.LanguageTranslation>(translation));
			if (one2!=null) {
				one2.setUpdateById(accountId);
				one2.setUpdateByName(accountName);
				one2.setUpdateTime(date);
			}else {
				one2 = new com.yizhi.system.application.domain.LanguageTranslation();
				one2.setId(idGenerator.generate());
				one2.setClassifyId(vo.getClassifyId());
				one2.setWordId(one.getId());
				one2.setCreateById(accountId);
				one2.setCreateByName(accountName);
				one2.setCreateTime(date);
			}
			one2.setValue(vo.getValue());
			one.setState(1);
			try {
				languageWordService.updateById(one);
				languageTranslationService.insertOrUpdate(one2);
				Map<String,Object> map = new HashMap<String, Object>();
				map.put("classifyId", vo.getClassifyId());
				map.put("type", vo.getType());
				languageUpload.execute(map, true);
				return 1;
			} catch (Exception e) {
				// TODO Auto-generated catch block
				LOGGER.error("字段翻译失败"+vo.getKey(),e);
				return 0;
			}
		}
		return 0;
	}
	
	@PostMapping("/list")
	public Page<LanguageVo> list(@RequestBody LanguageParam param){
		Long classifyId = param.getClassifyId();
		String kwd = param.getKwd();
		Integer state = param.getState();
		Integer type = param.getType();
		Integer pageNo = param.getPageNo();
		Integer pageSize = param.getPageSize();
		Page<LanguageVo> page = languageWordService.page(classifyId, type, state, kwd, pageNo, pageSize);
		return page;
	} 
	
	@PostMapping("/export")
	public String export(@RequestBody LanguageParam param) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Date date = new Date();
        Long classifyId = param.getClassifyId();
        Integer type = param.getType();
        Integer state = param.getState();
        String kwd = param.getKwd();
        LanguageClassify classify = languageClassifyService.selectById(classifyId);
        Long taskId = date.getTime();
        String serialNo = "LANGUAGE-EXPORT-" + taskId.toString();
        String taskName = "导出翻译-"+classify.getName();
        String result = "任务编号："+serialNo+"。任务名称："+taskName;
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("res", res);
        map.put("classify", classify);
        map.put("type", type);
        map.put("state", state);
        map.put("kwd", kwd);
		languageExport.execute(map, true);
		return result;
	}
}
