package com.yizhi.system.application.controller.remote;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.SwhyKeyService;
import com.yizhi.system.application.vo.domain.SwhyKey;
import com.yizhi.system.application.vo.OutsideUserVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * 外部系统查询基础信息相关处理
 */
@RestController
@RequestMapping(value = "/remote/outside/account")
public class OutsideSystemController {

    @Autowired
    private IAccountService accountService;

    @Autowired
    private SwhyKeyService swhyKeyService;

    @Autowired
    DomainConverter domainConverter;

    private static final Logger logger = LoggerFactory.getLogger(OutsideSystemController.class);

    @GetMapping(value = "/beta/user")
    public List<OutsideUserVO> getRcUsers(@RequestParam("userName") String userName,
                                             @RequestParam("companyId") Long companyId,
                                             @RequestParam("siteId") String siteId) {
        return accountService.getRcUsers(userName, companyId, siteId);
    }

    /**
     * 根据appId 获取相关配置
     * @param appId
     * @return
     */
    @GetMapping(value = "/appId/info/get")
    public SwhyKey getSwhyKeyConfig(@RequestParam("appId") String appId, @RequestParam("companyId") Long companyId){
        if(StringUtils.EMPTY.equals(StringUtils.trimToEmpty(appId))){
            return null;
        }

        EntityWrapper<com.yizhi.system.application.domain.SwhyKey> ewSk = QueryUtil.condition(new com.yizhi.system.application.domain.SwhyKey());
        ewSk.eq("company_id", companyId).eq("uuid",appId);
        com.yizhi.system.application.domain.SwhyKey swhyKeyConfig = swhyKeyService.selectOne(ewSk);
        if(swhyKeyConfig == null){ //appId 不存在
            return null;
        }
        // 验证appId是否过期
        Date appIdExpireTime = swhyKeyConfig.getExpireTime();
        if(appIdExpireTime.getTime() < System.currentTimeMillis()){
            return null;
        }
        SwhyKey swhyKey = new SwhyKey();
        BeanUtils.copyProperties(swhyKeyConfig,swhyKey);
        return swhyKey;
    }
}
