package com.yizhi.system.application.controller.remote;

import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.using.AccountRangeExportService;
import com.yizhi.system.application.service.using.ExperiencePoolRangeExportService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 可见范围导入、导出
 *
 * @Author: shengchenglong
 * @Date: 2018/9/5 11:41
 */
@RestController
@RequestMapping("/remote/account/range")
public class RemoteAccountRangeController {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAccountRangeController.class);

    @Autowired
    private AuthService authService;
    @Autowired
    private IAccountService accountService;
    @Autowired
    private AccountRangeExportService accountRangeExportService;
    @Autowired
    private ExperiencePoolRangeExportService poolRangeExportService;

    @Autowired
    private AccountMapper accountMapper;


    @PostMapping("/import")
    public AccountRangeImportModel doImport(@RequestBody AccountRangeImportParam param) throws Exception {
        AccountRangeImportModel model = new AccountRangeImportModel();
        RequestContext context = param.getRequestContext();
        // 创建workbook
        URL url = null;
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        Workbook book = null;
        try {
            String ossUrl = param.getOssUrl();
            String fileName = ossUrl.substring(ossUrl.lastIndexOf("/") + 1);
            String ossUrlPrefix = ossUrl.substring(0, ossUrl.lastIndexOf("/") + 1);
            ossUrl = ossUrlPrefix + URLEncoder.encode(fileName, "utf-8");
            url = new URL(ossUrl);
            conn = (HttpURLConnection) url.openConnection();
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            book = WorkbookFactory.create(inputStream);
        } catch (MalformedURLException e) {
            LOGGER.error("创建ossurl 连接错误", e.getMessage());
            throw e;
        } catch (IOException e) {
            LOGGER.error("创建ossurl 连接错误", e.getMessage());
            throw e;
        } catch (InvalidFormatException e) {
            LOGGER.error("创建Workbook 对象错误", e.getMessage());
            throw e;
        }

        if (null == book) {
            String errMsg = "创建Workbook 对象失败， param:" + param.toString();
            LOGGER.error(errMsg);
            throw new Exception(errMsg);
        }

        LOGGER.info("siteId===========" + context.getSiteId());

        com.yizhi.system.application.domain.Site site = new Site();
        site.setId(context.getSiteId());
        site = site.selectById();

        if (null != site) {
            Sheet sheet = book.getSheetAt(0);
            if (null != sheet) {
                List<Long> idsInGroup = new ArrayList<>();
                Set<Long> idsInManage = authService.getAccountIdsInManage(site, context, AuthzConstant.moduleType.valueOf(param.getType().getValue()));
                idsInGroup.addAll(idsInManage);

                if (CollectionUtils.isEmpty(idsInGroup)) {
                    LOGGER.info("idsInManage:==================" + idsInGroup);
                    return null;
                }
                Row row;
                Cell cell;
                List<String> accountNames = new ArrayList<>(sheet.getLastRowNum());
                //获取无效用户名
                List<String> unUsefulAccountNames = new ArrayList<>(sheet.getLastRowNum());
                //存储用户，对应的行数 由于存在name相同的数据，导致行数覆盖，故增加行数辅助确认
                //<name+row,row>
                Map<String, Integer> nameRowMap = new HashMap<>(sheet.getLastRowNum());
                Set<String> nameSet = new HashSet<>(sheet.getLastRowNum());
                String accountName = null;
                int lastRowNum = sheet.getLastRowNum();
                String key = null;
                Integer rowNum = null;
                for (int i = 0; i < lastRowNum; i++) {
                    row = sheet.getRow(i + 1);
                    if (null != row) {
                        cell = row.getCell(0);
                        if (null != cell) {
                            try {
                                cell.setCellType(CellType.STRING);
                                accountName = cell.getStringCellValue().toLowerCase();//统一大小写格式
                                accountName = StringUtils.isNotEmpty(accountName) ? accountName.trim() : accountName;
                                rowNum = i + 2;
                                key = accountName + rowNum;
                                accountNames.add(accountName);
                                nameRowMap.put(key, rowNum);
                                if (nameSet.contains(accountName)) {
                                    model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(rowNum, "用户名：" + accountName + "有重复！"));
                                    continue;
                                }
                                nameSet.add(accountName);
                            } catch (Exception e) {
                                model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(rowNum, e.getMessage()));
                            }
                        } else {
                            model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(rowNum, "用户名不能为空！"));
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(accountNames)) {
                    List<com.yizhi.system.application.domain.Account> accounts = accountMapper.getIdsByNames(accountNames, context.getCompanyId());
                    List<String> usefulNames = null;
                    Map<String, Long> accountMap = new HashMap<>(accounts.size());
                    if (CollectionUtils.isNotEmpty(accounts)) {
                        model.setSuccessList(new ArrayList<>(accounts.size()));
                        usefulNames = accounts.parallelStream().map(a -> a.getName().toLowerCase()).collect(Collectors.toList());
                        for (Account account : accounts) {
                            accountMap.put(account.getName().toLowerCase(), account.getId());
                        }
                    }
                    //处理有效数据，返回错误信息
                    dealData(sheet, usefulNames, accountMap, idsInGroup, model, nameRowMap);
                }
            }
        }
        return model;
    }

    /**
     * 处理数据
     *
     * @param accountMap
     * @param idsInGroup
     * @param model
     * @param nameRowMap
     */
    private void dealData(Sheet sheet,
                          List<String> usefulNames,
                          Map<String, Long> accountMap,
                          List<Long> idsInGroup,
                          AccountRangeImportModel model,
                          Map<String, Integer> nameRowMap) {
        int lastRowNum = sheet.getLastRowNum();
        String key = null;
        Integer rowNum = null;
        Row row;
        Cell cell;
        String accountName = null;
        Set<Long> successIds = new HashSet<>();
        for (int i = 0; i < lastRowNum; i++) {
            row = sheet.getRow(i + 1);
            if (null != row) {
                cell = row.getCell(0);
                if (null != cell) {
                    cell.setCellType(CellType.STRING);
                    accountName = cell.getStringCellValue().toLowerCase();
                    rowNum = i + 2;
                    key = accountName + rowNum;
                    if (usefulNames == null) {
                        model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(nameRowMap.get(key), "无效的用户名！"));
                        continue;
                    } else {
                        if (!usefulNames.contains(accountName)) {
                            model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(nameRowMap.get(key), "无效的用户名！"));
                            continue;
                        }
                    }
                    Long accountId = accountMap.get(accountName);
                    //判断excel name是否在管辖区内
                    if (!idsInGroup.contains(accountId)) {
                        model.getErrorList().add(new AccountRangeImportModel.ErrorAccount(nameRowMap.get(key), "管辖范围内无该用户"));
                    } else {
                        if (!successIds.contains(accountId)) {
                            successIds.add(accountId);
                            model.getSuccessList().add(new AccountRangeImportModel.SuccessAccount(accountId, accountName));
                        }
                    }
                }
            }
        }
    }


    /**
     * 返回任务名称
     *
     * @param param
     * @return
     */
    @PostMapping("/export")
    public String doExport(@RequestBody AccountRangeExportParam param) {
        // 参数检查
        boolean pass = true;
        if (CollectionUtils.isEmpty(param.getAccountIds()) && CollectionUtils.isEmpty(param.getOrgIds())) {
            pass = false;
        }
        if (null == param.getContext()) {
            pass = false;
        }
        String fileNamePattern = param.getBizName().replaceAll("/", ".") + "-可见范围导出";
        LOGGER.info("{}, : accountIds.size:{}, orgIds.siez:{}", fileNamePattern,
                null == param.getAccountIds() ? 0 : param.getAccountIds().size(),
                null == param.getOrgIds() ? 0 : param.getOrgIds().size());
        if (!pass) {
            LOGGER.info("Account range param check error! return");
            return null;
        }
        return accountRangeExportService.doExport(param, "USER-RANGE-EXPORT-", fileNamePattern);
    }

    /**
     * 返回任务名称
     *
     * @param param
     * @return
     */
    @PostMapping("/experiencePoolExport")
    public String doExperiencePoolExport(@RequestBody AccountRangeExportParam param) {
        // 参数检查
        String fileNamePattern = param.getBizName().replaceAll("/", ".") + "-可见范围导出";
        LOGGER.info("{}, : accountIds.size:{}, orgIds.siez:{}", fileNamePattern,
                null == param.getAccountIds() ? 0 : param.getAccountIds().size(),
                null == param.getOrgIds() ? 0 : param.getOrgIds().size());
        return poolRangeExportService.doExport(param, "USER-RANGE-EXPORT-", fileNamePattern);
    }

}
