package com.yizhi.system.application.controller.remote;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.system.application.utils.recursion.TreeObjectVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.vo.CompanyVO;

/**
 * 企业
 */
@RestController
@RequestMapping(value="/remote/company")
@Slf4j

public class RemoteCompanyController {

	@Value("${redis.manage.authz.expired}")
	private Long redisManageAuthzExpired;

	@Autowired
	ICompanyService iCompanyService;
	@Autowired
	IAccountService accountService;
	@Autowired
	RedisCache redisCache;
	@Autowired
	ISiteService siteService;
	@Autowired
	DomainConverter converter;

    /**
     * 根据站点code查询站点信息
	 * @param code 企业code
	 * @return
     */
	@GetMapping(value = "/name/get")
	public CompanyVO findByCode(@RequestParam(value = "code") String code){
		com.yizhi.system.application.domain.Company company = new com.yizhi.system.application.domain.Company();
		company.setCode(code);
		company.setStatus(2);
		Company resultCompany = iCompanyService.selectOne(QueryUtil.condition(company));
		if(null == resultCompany){
			return null;
		}
		CompanyVO companyVO = new CompanyVO();
		BeanUtils.copyProperties(resultCompany,companyVO);
		try {
			redisCache.hset(CacheNamespace.REDIS_COMPANIES, code, JSON.toJSONString(companyVO), redisManageAuthzExpired);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return companyVO;
	}
	/**
	 * 获取用户管理所属组织以及下属子组织
	 * @param companyId 企业ID
	 * @return
	 */
	@GetMapping(value = "/orgs")
	public List<TreeObjectVO> getOrgs(@RequestParam long companyId) {
		List<TreeObjectVO> ret = null;
		ret = accountService.selectOrgList(companyId);
		return ret;
	}

	@GetMapping(value = "/site/top/get")
	public SiteVO getTopSite(@RequestParam Long companyId) {
		SiteVO siteVO = null;
		try{
			if(companyId==null){
				return siteVO;
			}
			EntityWrapper<com.yizhi.system.application.domain.Site> where = QueryUtil.condition(new com.yizhi.system.application.domain.Site());
			where.where("enabled={0}",1);
			where.and().eq("company_id",companyId)
			.and().eq("user_group_id",0);// 查询企业顶级id

			Site site = siteService.selectOne(where);
			return (SiteVO)converter.toVO(site, SiteVO.class);
		}catch(Exception e){
			return siteVO;
		}
	}
	
	/**
	 * @param authcode
	 * @return
     */
	@GetMapping(value = "/authcode/get")
	public CompanyVO findByAuthCode(@RequestParam(value = "authcode") String authcode){
		CompanyVO resultCompany = iCompanyService.findByAuthCode(authcode);
		if(null == resultCompany){
			return null;
		}
		 
		return resultCompany;
	}

	/**
	 * 社群企业同步
	 * @param date
	 * @return
	 */
	@PostMapping(value="/public/community/syncCompany")
	public List<Company> syncCompany(@RequestParam("indexTime") long indexTime){
		log.info("===================社群company同步==========================");
		EntityWrapper<Company> wrapper = new EntityWrapper<>();
		wrapper.gt("index_time", DateUtil.formatDateTime(new Date(indexTime)));
		List<Company> companies = iCompanyService.selectList(wrapper);
		if (CollectionUtils.isEmpty(companies)){
			return null;
		}
		return companies;
	}

	public static void main(String[] args) {
		System.out.println(DateUtil.formatDateTime(new Date()));
	}

}
