package com.yizhi.system.application.controller.remote;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.ILoginExportService;
import com.yizhi.system.application.service.ILoginLogService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.vo.domain.LoginLog;
import com.yizhi.system.application.vo.domain.Organization;
import com.yizhi.system.application.task.LoginExportAsy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:01 2018/8/28
 * @Modified By
 */
@RestController
@RequestMapping(value="/remote/loginLog")
public class RemoteLoginExportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginExportController.class);

    @Autowired
    private ILoginExportService loginExportService;

    @Autowired
    private IOrganizationService organizationService;

    @Autowired
    private LoginExportAsy export;

    @Autowired
    private ILoginLogService loginLogService;

    @Autowired
    DomainConverter domainConverter;

    @PostMapping("/add/log")
    public Boolean addLoginLog(@RequestBody LoginLogAddReqVO vo){
        com.yizhi.system.application.domain.LoginLog loginLog = new com.yizhi.system.application.domain.LoginLog();
        loginLog.setAccountId(vo.getAccountId());
        loginLog.setCompanyId(vo.getCompanyId());
        loginLog.setSiteId(vo.getSiteId());
        loginLog.setOrgId(vo.getOrgId());
        loginLog.setLoginType(vo.getType());
        loginLog.setLoginDate(new Date());
        loginLogService.insert(loginLog);
        return true;
    }

    /**
     * 获取图表数据
     * @param startDate
     * @param endDate
     * @param type
     * @return
     */
    @GetMapping("/chart/view")
    public List<LoginUserChartVO> loginLogChart(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "type", required = true, defaultValue = "1") Integer type
            /*@RequestParam(name = "companyId") Long companyId,
            @RequestParam(name = "siteId") Long siteId,
            @RequestParam(name = "orgIds") String orgIds*/
            )
    {
        RequestContext reques = ContextHolder.get();
        List<Long> siteAdminOrgs = reques.getOrgIds();
        if(reques.isAdmin()){
            siteAdminOrgs = Arrays.asList(-1L);
            Set<Long> siteOrg = organizationService.getOrgIdsInSite(reques.getSiteId(),reques.getCompanyCode(),reques.getSiteCode());
            if(CollectionUtils.isNotEmpty(siteOrg)){
                siteAdminOrgs = Arrays.asList(siteOrg.toArray(new Long[]{}));
            }
        }else {
            if(CollectionUtils.isEmpty(siteAdminOrgs)){
                return null;
            }
		}
        List<LoginUserChartVO> data = loginExportService.loginLogChart(startDate,endDate,
                type,reques.getCompanyId(),reques.getSiteId(),siteAdminOrgs);

        return data;
    }

    @GetMapping("/list/org")
    public Page<LoginUserOrgExportVO> loginLogByOrg(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
/*            @RequestParam(name = "companyId") Long companyId,
            @RequestParam(name = "siteId") Long siteId,
            @RequestParam(name = "orgIds") String orgIds*/
    ){
         RequestContext reques = ContextHolder.get();
/*        List<Long> orgs = null;
        if(StringUtils.isNotBlank(orgIds)){
            orgs = Arrays.asList(orgIds.split(",")).stream().map(obj->Long.valueOf(obj)).collect(Collectors.toList());
        }*/
        List<Long> siteAdminOrgs = reques.getOrgIds();
        if(reques.isAdmin()){
            siteAdminOrgs = Arrays.asList(-1L);
            Set<Long> siteOrg = organizationService.getOrgIdsInSite(reques.getSiteId(),reques.getCompanyCode(),reques.getSiteCode());
            if(CollectionUtils.isNotEmpty(siteOrg)){
                siteAdminOrgs = Arrays.asList(siteOrg.toArray(new Long[]{}));
            }
        }else {
            if(CollectionUtils.isEmpty(siteAdminOrgs)){
                return null;
            }
		}

        // 查询组织分页信息
        EntityWrapper<com.yizhi.system.application.domain.Organization> ewOrg = QueryUtil.condition(new com.yizhi.system.application.domain.Organization());
        ewOrg.in("id",siteAdminOrgs);
        if(StringUtils.isNotBlank(kwd)){
            ewOrg.andNew().like("code",kwd, SqlLike.DEFAULT).or().like("name",kwd, SqlLike.DEFAULT);
        }
        Page<LoginUserOrgExportVO> redata = new Page<>();

        Page<com.yizhi.system.application.domain.Organization> pages = new Page(pageNo,pageSize);
        pages.setOrderByField("id").setAsc(false);
        Page<com.yizhi.system.application.domain.Organization> pageData = organizationService.selectPage(pages,ewOrg);
        BeanUtils.copyProperties(pageData,redata,"records");
        List<com.yizhi.system.application.domain.Organization> organizations = pageData.getRecords();
        // 获取各个组织的下级组织
        List<Organization> organizationVos = domainConverter.toDOList(organizations, Organization.class);
        Map<String,Organization> countMap = new HashMap<>();
        Set<Long> selectOrgs = new HashSet();
        for(Organization item : organizationVos){
            Set<Long> itemChidren = organizationService.listChildrenId(Arrays.asList(item.getId()));
            //String key = StringUtils.join(itemChidren,",")+",";
            String key = ","+StringUtils.join(itemChidren,",")+",";
            countMap.put(key,item);
            selectOrgs.addAll(itemChidren);
        }

        // 查询分页组织的报表数据
        List<Long> longList = new ArrayList<>(selectOrgs);
        Page<LoginUserOrgExportVO> data = loginExportService.loginLogByOrg(startDate,endDate,
                null,null,null,reques.getCompanyId(),reques.getSiteId(),longList);
        List<LoginUserOrgExportVO> allData = data.getRecords();
        //LOGGER.info("查询的数据={}",JSON.toJSONString(allData));

        // 最后返回的List对象数据
        List<LoginUserOrgExportVO> retList = new ArrayList<>();
        // 把包含子组织的统计汇总
        for(Map.Entry<String,Organization> itemVal : countMap.entrySet()){

            Organization organizationTemp = itemVal.getValue();
            String forOrgId = itemVal.getKey();
            LOGGER.info("查询的key={}",forOrgId);
            // Objects.equals(a，b),如果两个参数都为 null， Objects.equals(a，b) 调用将返回 true ; 如果其中一个参数为 null ,则返回 false ; 否则，如果两个参数都不为 null， 则调用 a.equals(b)
            //testList.removeIf(test->test.startsWith("1")); 排除，filter保留为true
            Map<Long,LoginUserOrgExportVO> gList = allData.parallelStream().filter(objItem->forOrgId.indexOf((objItem.getOrgId().toString()+","))>=0)
                    .collect(Collectors.toMap(key1->key1.getOrgId(),val1->val1));
            LOGGER.info("获取root的orgId={}",organizationTemp.getId());
            LoginUserOrgExportVO loginUserOrgExportVO = gList.get(organizationTemp.getId());

            // 新建数据存储对象
            LoginUserOrgExportVO loginUserOrgExportVONew = new LoginUserOrgExportVO();
            loginUserOrgExportVONew.setOrgId(organizationTemp.getId());
            loginUserOrgExportVONew.setOrgName(organizationTemp.getName());
            loginUserOrgExportVONew.setOrgCode(organizationTemp.getCode());

            if(loginUserOrgExportVO == null){
                loginUserOrgExportVONew.setLoginUserNum(0L);
                loginUserOrgExportVONew.setStopUserNum(0L);
                loginUserOrgExportVONew.setEnableUserNum(0L);
                loginUserOrgExportVONew.setUserSumNum(0L);
                loginUserOrgExportVONew.setLoginVisit(0L);
                retList.add(loginUserOrgExportVONew);
                continue;
            }
            // 循环追加子组织的统计信息
            long userSumNum = loginUserOrgExportVO.getUserSumNum();
            long enableUserNum = loginUserOrgExportVO.getEnableUserNum();
            long stopUserNum = loginUserOrgExportVO.getStopUserNum();
            long loginUserNum = loginUserOrgExportVO.getLoginUserNum();
            long loginVisit = loginUserOrgExportVO.getLoginVisit();
            gList.remove(organizationTemp.getId());
            Collection<LoginUserOrgExportVO> voCollection = gList.values();
            for(LoginUserOrgExportVO loginUserOrgExportVO1 : voCollection){
                userSumNum = userSumNum+loginUserOrgExportVO1.getUserSumNum().longValue();
                enableUserNum = enableUserNum+loginUserOrgExportVO1.getEnableUserNum().longValue();
                stopUserNum = stopUserNum + loginUserOrgExportVO1.getStopUserNum().longValue();
                loginUserNum = loginUserNum+loginUserOrgExportVO1.getLoginUserNum().longValue();
                loginVisit = loginVisit+loginUserOrgExportVO1.getLoginVisit().longValue();
            }
            loginUserOrgExportVONew.setUserSumNum(userSumNum);
            loginUserOrgExportVONew.setEnableUserNum(enableUserNum);
            loginUserOrgExportVONew.setStopUserNum(stopUserNum);
            loginUserOrgExportVONew.setLoginUserNum(loginUserNum);
            loginUserOrgExportVONew.setLoginVisit(loginVisit);
            retList.add(loginUserOrgExportVONew);
        }
        redata.setRecords(retList);
        return redata;
    }

    @GetMapping("/list/account")
    public Page<LoginUserExportVO> loginLogByAccount(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
   /*         @RequestParam(name = "companyId") Long companyId,
            @RequestParam(name = "siteId") Long siteId,
            @RequestParam(name = "orgIds") String orgIds*/
    ){
        RequestContext reques = ContextHolder.get();
/*        List<Long> orgs = null;
        if(StringUtils.isNotBlank(orgIds)){
            orgs = Arrays.asList(orgIds.split(",")).stream().map(obj->Long.valueOf(obj)).collect(Collectors.toList());
        }*/
        List<Long> siteAdminOrgs = reques.getOrgIds();
        if(reques.isAdmin()){
            siteAdminOrgs = Arrays.asList(-1L);
            Set<Long> siteOrg = organizationService.getOrgIdsInSite(reques.getSiteId(),reques.getCompanyCode(),reques.getSiteCode());
            if(CollectionUtils.isNotEmpty(siteOrg)){
                siteAdminOrgs = Arrays.asList(siteOrg.toArray(new Long[]{}));
            }
        }else {
            if(CollectionUtils.isEmpty(siteAdminOrgs)){
                return null;
            }
		}
        Page<LoginUserExportVO> data = loginExportService.loginLogByAccount(startDate,endDate,
                kwd,pageSize,pageNo,reques.getCompanyId(),reques.getSiteId(),reques.getOrgIds(),siteAdminOrgs);

        return data;
    }

    @PostMapping("/list/org/export")
    public List<LoginUserOrgExportVO> loginLogByOrgExp(@RequestBody Map<String,Object> parament){
        RequestContext requestContext = ContextHolder.get();
        //LOGGER.info("%%%%%%%%%%%%%%%%%%%%上下文信息="+ JSON.toJSONString(requestContext));
        parament.put("requestContext",requestContext);
        // 执行异步，并且设置成异步启动
        export.execute(parament,true);
        return null;
    }

    @PostMapping("/list/account/export")
    public List<LoginUserExportVO> loginLogByAccountExp(@RequestBody Map<String,Object> parament){
        RequestContext requestContext = ContextHolder.get();
        LOGGER.info("%%%%%%%%%%%%%%%%%%%%上下文信息="+ JSON.toJSONString(requestContext));
        parament.put("requestContext",requestContext);
        export.execute(parament,true);
        return null;
    }
    
    
    
    
    @GetMapping("/look/num")
    public Integer loginLookNum(@RequestParam("siteId")Long siteId,@RequestParam("loginType")Integer loginType) {
    	return loginLogService.loginLookNum(siteId, loginType);
    }
    
    @GetMapping("/count")
    public LoginDataStatisticsVO loginCount(@RequestParam("siteId")Long siteId) {
    	
    	return loginExportService.getLoginCountBySiteId(siteId);
    }
    
    @GetMapping("/list/date")
    public List<LoginLog> getLogByDate(@RequestParam("siteId")Long siteId,@RequestParam("accountId")Long accountId){
        List<com.yizhi.system.application.domain.LoginLog> logByDate = loginLogService.getLogByDate(siteId, accountId, new Date());
        return domainConverter.toDOList(logByDate,LoginLog.class);
    }
}