package com.yizhi.system.application.controller.remote;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.system.application.util.CollectionUtil;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.vo.domain.Organization;
import com.yizhi.system.application.util.HQInManageParam;
import com.yizhi.system.application.util.OrgIndexUtil;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.page.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 16:31 2018/7/16
 * @Modified By
 */
@RestController
@RequestMapping(value = "/remote/report/account")
public class ReportAccountController {

    private static final Logger logger = LoggerFactory.getLogger(ReportAccountController.class);

    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IAccountService accountService;
    @Autowired
    private ISiteService siteService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private AuthService authService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private IAuthzGroupMemberService authzGroupMemberService;

    @Autowired
    private OrganizationClient organizationClient;

    /**
     * 报表获取用户信息列表
     *
     * @param reportAccountVO
     * @return
     */
    @PostMapping(value = "/list")
    public PageInfo<ReportAccountRespVO> getAccounts(@RequestBody ReportAccountReqVO reportAccountVO) {
        PageInfo<ReportAccountRespVO> ret = null;
        logger.info("获取部门信息请求的参数：{}" + JSON.toJSONString(reportAccountVO));

        // 上下文信息
        RequestContext requestContext = reportAccountVO.getRequestContext();
        // 获取管理的用户组织信息
        List<Long> orgs = organizationService.getMgrOrgs(requestContext);

        // 查询站点信息
        if (CollectionUtils.isEmpty(orgs)) {
            return ret;
        }
        ret = accountService.getOrgsUsers(orgs,
                reportAccountVO.getPageNo(),
                reportAccountVO.getPageSize(),
                reportAccountVO.getOrgCodeOrOrgName(),
                reportAccountVO.getAccountName());

        // 获取每个组织的的父组织
        Long companyId = requestContext.getCompanyId();
        List<ReportAccountRespVO> respVOS = ret.getRecords();
        if (!CollectionUtils.isEmpty(respVOS)) {
            respVOS.forEach(item -> {
                item.setParentOrgNames(organizationService.getOrgNames(item.getOrgId(), companyId));
            });
        }
        return ret;
    }

    /**
     * 查询站点下的用户名列表
     *
     * @param siteId
     * @return
     */
    @GetMapping("/site/accounts")
    public Map<String, Long> findSiteAccountIds(@RequestParam("siteId") Long siteId) {
        Set<Long> ids = getSiteOrgIds(siteId);
        Map<String, Long> data = accountService.getRangeUserNames(ids);
        return data;
    }

    /**
     * @return
     */
    @PostMapping(value = "/range/list")
    public List<ReportAccountRespVO> getRangeAccounts(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO) {
        Long siteId = rangeAccountReqVO.getSiteId();
        List<Long> orgIds = rangeAccountReqVO.getOrgIds();
        List<Long> accountIds = rangeAccountReqVO.getAccountIds();
        if (accountIds == null) {
            accountIds = new ArrayList<>();
        }


        if (null == siteId) {
            logger.error("-------------报表查询站点 参数错误，siteId为null-----------");
            return null;
        }

        com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.error("-------------报表查询站点（id: {}）,未查询到-----------", siteId);
            return null;
        }
        com.yizhi.system.application.domain.Company company = companyService.selectById(site.getCompanyId());
        if (null == company) {
            logger.error("-------------报表查询公司（id: {}）,未查询到-----------", siteId);
            return null;
        }
        List<RightLeftIndex> indices = new ArrayList<>();
        boolean allCompanyRange = rangeListDeal(orgIds, accountIds, indices, site, company);
        if (allCompanyRange) {
            return accountService.getReportAccountRespVO(company.getId(), rangeAccountReqVO.getEnabled(), rangeAccountReqVO.getAccountName(), rangeAccountReqVO.getOrgName(), null, null,null, allCompanyRange, null);
        } else {
            return accountService.getReportAccountRespVO(company.getId(), rangeAccountReqVO.getEnabled(), rangeAccountReqVO.getAccountName(), rangeAccountReqVO.getOrgName(), indices, accountIds,null, allCompanyRange, null);
        }
    }

    @PostMapping(value = "/range/list/inManage")
    public ReportAccountRespInManageVO getRangeAccountsInManage(@RequestBody HQAccountInManageParam param) {
        Long accountId = param.getAccountId();
        Long siteId = param.getSiteId();
        AuthzConstant.moduleType moduleType = param.getModuleType();
        if (null == accountId || null == siteId || null == moduleType) {
            logger.error("-------------报表查询站点 参数不全，accountId: {}, siteId: {}, moduleType: {}-----------", accountId, siteId, moduleType);
            return null;
        }
        com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.error("-------------报表查询站点（id: {}）,未查询到-----------", siteId);
            return null;
        }
        com.yizhi.system.application.domain.Company company = companyService.selectById(site.getCompanyId());
        if (company == null) {
            logger.error("-------------报表查询企业（id: {}）,未查询到-----------", site.getCompanyId());
        }
        AuthAccountSiteModel authAccountModel = null;
        // 一：管辖区关联部门的
        Object object = redisCache.hget(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS.concat(company.getCode()), site.getCode().concat(CacheNamespace.REDIS_HASH_SEPARATOR).concat(String.valueOf(accountId)));
        if (object == null) {
            authAccountModel = authService.getSiteAutho(company.getCode(), company.getId(), accountId, siteId, CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS);
        } else {
            authAccountModel = JsonUtil.json2Ojbect(object.toString(), AuthAccountSiteModel.class);
        }
        // 1. 站点管理员 管理全站点
        if (authAccountModel != null && authAccountModel.getSiteAdmin()) {
            return new ReportAccountRespInManageVO(true, null);
        }
        HQInManageParam hqInManageParam = authService.getHQInManageParam(accountId, site, moduleType);
        if (hqInManageParam == null) {
            return new ReportAccountRespInManageVO(false, null);
        }
        // 2. 如果管理了根部门，相当于站点管理员，可见范围为全站点
        if (hqInManageParam.getContainRootOrg()) {
            return new ReportAccountRespInManageVO(true, null);
        }
        // 3. 没有根部门，则查询指定的管辖区指定的范围
        if (CollectionUtils.isEmpty(hqInManageParam.getAccountIds()) && CollectionUtils.isEmpty(hqInManageParam.getIndices())) {
            return null;
        }
        List<ReportAccountRespVO> vos = accountService.getReportAccountRespVO(site.getCompanyId(), null, param.getAccountName(), param.getOrgName(), hqInManageParam.getIndices(), hqInManageParam.getAccountIds(),null, false, null);
        return new ReportAccountRespInManageVO(false, vos);
    }

    /**
     * @return
     */
    @PostMapping(value = "/range/list/page")
    public Page<ReportAccountRespVO> getRangeAccountsPage(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO) {
        Long siteId = rangeAccountReqVO.getSiteId();
        List<Long> orgIds = rangeAccountReqVO.getOrgIds();
        List<Long> accountIds = rangeAccountReqVO.getAccountIds();
        if (ObjectUtil.isEmpty(accountIds)){
            accountIds = new ArrayList<>();
        }

        if (null == siteId) {
            logger.error("-------------报表查询站点 参数错误，siteId为null-----------");
            return null;
        }

        com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.error("-------------报表查询站点（id: {}）,未查询到-----------", siteId);
            return null;
        }
        com.yizhi.system.application.domain.Company company = companyService.selectById(site.getCompanyId());
        List<RightLeftIndex> indices = new ArrayList<>();
        //***********//

        List<Long> orgIds1 = null;
        List<com.yizhi.system.application.domain.Organization> pOrganizations=null;
        if (rangeAccountReqVO.getOrgName()!=null&&!"".equals(rangeAccountReqVO.getOrgName())){
            com.yizhi.system.application.domain.Organization organization = new com.yizhi.system.application.domain.Organization();
            organization.setCompanyId(site.getCompanyId());
            organization.setDeleted(false);
            EntityWrapper<com.yizhi.system.application.domain.Organization> entity = new EntityWrapper<>(organization);
            entity.like("name",rangeAccountReqVO.getOrgName());
            //根据模糊查询 查到相应的部门
             pOrganizations = organizationService.selectList(entity);
        }
        //通过 父部门 查到相应的子部门并将子部门id取出来
        if (!CollectionUtils.isEmpty(pOrganizations)) {
            List<Long> finalOrgIds = new ArrayList<>();
            pOrganizations.forEach(organization1->{
                List<Organization> list1 = organizationClient.selectAllByPId(organization1.getId());
                if (!CollectionUtils.isEmpty(list1)) {
                    for (Organization o : list1) {
                        finalOrgIds.add(o.getId());
                    }
                }
            });
            orgIds1 = finalOrgIds;
        }
        //*****************//
        boolean allCompanyRange = rangeListDeal(orgIds, accountIds, indices, site, company);
        List<ReportAccountRespVO> list = null;
        Page page = rangeAccountReqVO.getPage();
        if (allCompanyRange) {
            list = accountService.getReportAccountRespVO(company.getId(), rangeAccountReqVO.getEnabled(), rangeAccountReqVO.getAccountName(), rangeAccountReqVO.getOrgName(), null, null,orgIds1, allCompanyRange, page);
        } else {
            list = accountService.getReportAccountRespVO(company.getId(), rangeAccountReqVO.getEnabled(), rangeAccountReqVO.getAccountName(), rangeAccountReqVO.getOrgName(), indices, accountIds, orgIds1,allCompanyRange, page);
        }
        page.setRecords(list);
        return page;
    }

    @PostMapping(value = "/range/list/inManage/page")
    public Page<ReportAccountRespVO> getRangeAccountsInManagePage(@RequestBody HQAccountInManageParam param) {
        Long accountId = param.getAccountId();
        Long siteId = param.getSiteId();
        AuthzConstant.moduleType moduleType = param.getModuleType();
        if (null == accountId || null == siteId || null == moduleType) {
            logger.error("-------------报表查询站点 参数不全，accountId: {}, siteId: {}, moduleType: {}-----------", accountId, siteId, moduleType);
            return null;
        }
        com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.error("-------------报表查询站点（id: {}）,未查询到-----------", siteId);
            return null;
        }
        com.yizhi.system.application.domain.Company company = companyService.selectById(site.getCompanyId());
        if (company == null) {
            logger.error("-------------报表查询企业（id: {}）,未查询到-----------", site.getCompanyId());
        }
        AuthAccountSiteModel authAccountModel = null;
        // 一：管辖区关联部门的
        Object object = redisCache.hget(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS.concat(company.getCode()), site.getCode().concat(CacheNamespace.REDIS_HASH_SEPARATOR).concat(String.valueOf(accountId)));
        if (object == null) {
            authAccountModel = authService.getSiteAutho(company.getCode(), company.getId(), accountId, siteId, CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS);
        } else {
            authAccountModel = JsonUtil.json2Ojbect(object.toString(), AuthAccountSiteModel.class);
        }
        // 1. 站点管理员 管理全站点
        if (authAccountModel != null && authAccountModel.getSiteAdmin()) {
            return rangeListInManageAdminDeal(siteId, param.getPage());
        }
        HQInManageParam hqInManageParam = authService.getHQInManageParam(accountId, site, moduleType);
        if (hqInManageParam == null) {
            return null;
        }
        // 2. 如果管理了根部门，相当于站点管理员，可见范围为全站点
        if (hqInManageParam.getContainRootOrg()) {
            return rangeListInManageAdminDeal(siteId, param.getPage());
        }
        // 3. 没有根部门，则查询指定的管辖区指定的范围
        if (CollectionUtils.isEmpty(hqInManageParam.getAccountIds()) && CollectionUtils.isEmpty(hqInManageParam.getIndices())) {
            return null;
        }
        List<ReportAccountRespVO> vos = accountService.getReportAccountRespVO(site.getCompanyId(), null, param.getAccountName(), param.getOrgName(), hqInManageParam.getIndices(), hqInManageParam.getAccountIds(), null,false, param.getPage());
        Page page = param.getPage();
        page.setRecords(vos);
        return page;
    }

    @PostMapping(value = "/range/count")
    public Long getRangeAccountCountNum(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO) {
        Long siteId = rangeAccountReqVO.getSiteId();
        List<Long> orgIds = rangeAccountReqVO.getOrgIds();
        List<Long> accountIds = rangeAccountReqVO.getAccountIds();

        if (null == siteId) {
            logger.error("-------------报表查询站点 参数错误，siteId为null-----------");
            return null;
        }

        Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.error("-------------报表查询站点（id: {}）,未查询到-----------", siteId);
            return null;
        }
        Company company = companyService.selectById(site.getCompanyId());

        boolean allCompanyRange = false;
        List<RightLeftIndex> indices = null;
        // 1. 该业务全站点可见
        if (CollectionUtils.isEmpty(orgIds) && CollectionUtils.isEmpty(accountIds)) {
            // 1.1 如果是主站点，查询所有企业下的用户
            if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                allCompanyRange = true;
            }
            // 1.2 否则是子站点，子站点下的部门包含根部门，则 查询所有企业下的用户
            else {
                Organization rootOrg = getRootOrg(company.getId());
                Set<Long> siteOrgIds = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 1);
                if (!CollectionUtils.isEmpty(siteOrgIds) && siteOrgIds.contains(rootOrg.getId())) {
                    allCompanyRange = true;
                }
                // 1.3 否则查询子站点下部门
                else {
                    Set<Long> accountIdSet = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 2);
                    if (!CollectionUtils.isEmpty(accountIdSet)) {
                        accountIds = new ArrayList<>();
                        accountIds.addAll(accountIdSet);
                    }
                    if (!CollectionUtils.isEmpty(siteOrgIds)) {
                        indices = OrgIndexUtil.getChildrenRange(organizationService.selectBatchIds(siteOrgIds));
                    }
                }
            }
        }
        // 2. 该业务指定范围可见
        else {
            // 2.1 如果指定了部门
            if (!CollectionUtils.isEmpty(orgIds)) {
                // 2.1.1 如果指定了部门中含有根部门，查询所有企业下的用户
                Organization rootOrg = getRootOrg(company.getId());
                if (orgIds.contains(rootOrg.getId())) {
                    allCompanyRange = true;
                }
                // 2.1.2 找出指定部门的左右索引集合
                else {
                    indices = OrgIndexUtil.getChildrenRange(organizationService.selectBatchIds(orgIds));
                }
            }
        }
        if (allCompanyRange) {
            return accountService.getReportAccountRespVOCount(company.getId(), rangeAccountReqVO.getEnabled(), null, null, allCompanyRange);
        } else {
            return accountService.getReportAccountRespVOCount(company.getId(), rangeAccountReqVO.getEnabled(), indices, accountIds, allCompanyRange);
        }
    }


    private boolean rangeListDeal(List<Long> orgIds, List<Long> accountIds,
                                  List<RightLeftIndex> indices, com.yizhi.system.application.domain.Site site, com.yizhi.system.application.domain.Company company) {
        boolean allCompanyRange = false;
        // 1. 该业务全站点可见
        if (CollectionUtils.isEmpty(orgIds) && CollectionUtils.isEmpty(accountIds)) {
            // 1.1 如果是主站点，查询所有企业下的用户
            if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                allCompanyRange = true;
            }
            // 1.2 否则是子站点，子站点下的部门包含根部门，则 查询所有企业下的用户
            else {
                Organization rootOrg = getRootOrg(company.getId());
                Set<Long> siteOrgIds = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 1);
                if (!CollectionUtils.isEmpty(siteOrgIds) && siteOrgIds.contains(rootOrg.getId())) {
                    allCompanyRange = true;
                }
                // 1.3 否则查询子站点下部门
                else {
                    Set<Long> accountIdSet = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 2);
                    if (!CollectionUtils.isEmpty(accountIdSet)) {
                        accountIds.addAll(accountIdSet);
                    }
                    if (!CollectionUtils.isEmpty(siteOrgIds)) {
                        List<RightLeftIndex> indexList = OrgIndexUtil.getChildrenRange(organizationService.selectBatchIds(siteOrgIds));
                        if (!CollectionUtils.isEmpty(indexList)) {
                            indices.addAll(indexList);
                        }
                    }
                }
            }
        }
        // 2. 该业务指定范围可见
        else {
            // 2.1 如果指定了部门
            if (!CollectionUtils.isEmpty(orgIds)) {
                // 2.1.1 如果指定了部门中含有根部门，查询所有企业下的用户
                Organization rootOrg = getRootOrg(company.getId());
                if (orgIds.contains(rootOrg.getId())) {
                    allCompanyRange = true;
                }
                // 2.1.2 找出指定部门的左右索引集合
                else {
                    List<RightLeftIndex> indexList = OrgIndexUtil.getChildrenRange(organizationService.selectBatchIds(orgIds));
                    if (!CollectionUtils.isEmpty(indexList)) {
                        indices.addAll(indexList);
                    }
                }
            }
        }
        return allCompanyRange;
    }

    private Page<ReportAccountRespVO> rangeListInManageAdminDeal(Long siteId, Page page) {
        ReportRangeAccountReqVO vo = new ReportRangeAccountReqVO();
        vo.setSiteId(siteId);
        vo.setPage(page);
        return getRangeAccountsPage(vo);
    }

    private Set<Long> getSiteOrgIds(Long siteId) {
        com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);
        if (site == null) {
            logger.info("传入的站点ID{}在系统站点表没有找到信息", site);
        }
        com.yizhi.system.application.domain.Company company = companyService.selectById(site.getCompanyId());
        if (company == null) {
            logger.info("根据站点id查询的站点信息的企业id={}，没有查询到企业信息", site.getCompanyId());
        }
        Set<Long> retIds = organizationService.getOrgIdsInSite(site.getId(), company.getCode(), site.getCode());
        return retIds;
    }

    /**
     * 获取企业下根部门
     *
     * @param companyId
     * @return
     */
    private Organization getRootOrg(long companyId) {
        com.yizhi.system.application.domain.Organization rootOrg = new com.yizhi.system.application.domain.Organization();
        rootOrg.setCompanyId(companyId);
        rootOrg.setDeleted(false);
        rootOrg.setParentId(0L);
        rootOrg = rootOrg.selectOne(new EntityWrapper(rootOrg));
        Organization organization = new Organization();
        BeanUtils.copyProperties(rootOrg, organization);
        return organization;
    }
}
