package com.yizhi.system.application.controller.remote;


import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.domain.StudentEditPermission;
import com.yizhi.system.application.service.IStudentEditPermissionService;
import com.yizhi.system.application.vo.StudentEditPermissionVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 学员修改资料权限 前端控制器
 * </p>
 *
 * @author 谢海军123
 * @since 2019-03-07
 */
@RestController
@RequestMapping("/studentEditPermission")
public class StudentEditPermissionController {

    private static final Logger logger = LoggerFactory.getLogger(StudentEditPermissionController.class);

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private IStudentEditPermissionService permissionService;

    /**
     * 保存或者更新，根据id确定
     * @param vo
     * @return
     */
    @PostMapping(value = "/saveOrUpdate")
    public StudentEditPermissionVO saveOrUpdate(@RequestBody StudentEditPermissionVO vo){
        Long id = vo.getId();
        if(Objects.nonNull(id)){// 更新
            vo.setUpdateTime(new Date());
            com.yizhi.system.application.domain.StudentEditPermission upObj = new com.yizhi.system.application.domain.StudentEditPermission();
            BeanUtils.copyProperties(vo,upObj);
            permissionService.updateById(upObj);
        }else{
            id =  idGenerator.generate();
            vo.setId(id);
            vo.setCreateTime(new Date());
            com.yizhi.system.application.domain.StudentEditPermission saveObj = new com.yizhi.system.application.domain.StudentEditPermission();
            BeanUtils.copyProperties(vo,saveObj);
            permissionService.insert(saveObj);
        }
        return vo;
    }

    /**
     * 根据站点获取用户配置的修改信息权限
     * @param siteId
     * @return
     */
    @GetMapping(value = "/get")
    public StudentEditPermissionVO getBySiteId(@RequestParam("siteId") long siteId){
        StudentEditPermissionVO vo = null;
        com.yizhi.system.application.domain.StudentEditPermission ew = new com.yizhi.system.application.domain.StudentEditPermission();
        ew.setSiteId(siteId);
        StudentEditPermission obj = permissionService.selectOne(QueryUtil.condition(ew));
        if(obj != null){
            vo = new StudentEditPermissionVO();
            BeanUtils.copyProperties(obj,vo);
        }
        return vo;
    }
}

