package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 登陆统计（周）
 * </p>
 *
 * @author shengchenglong
 * @since 2019-10-09
 */
@Data
@Api(tags = "DaIndicatorLoginWeek", description = "登陆统计（周）")
@TableName("da_indicator_login_week")
public class DaIndicatorLoginWeek extends Model<DaIndicatorLoginWeek> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "登陆有多少人")
    @TableField("person_num")
    private Integer personNum;

    @ApiModelProperty(value = "登陆人次")
    @TableField("person_time")
    private Integer personTime;

    @ApiModelProperty(value = "开始时间（天）")
    @TableField("start_day")
    private Date startDay;

    @ApiModelProperty(value = "开始时间（天）")
    @TableField("end_day")
    private Date endDay;

    @ApiModelProperty(value = "处理时间")
    @TableField("process_time")
    private Date processTime;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
