package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzAccountRole;
import com.yizhi.system.application.domain.AuthzRoleMenu;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 员工关联角色 Mapper 接口
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-09
 */
public interface AuthzAccountRoleMapper extends BaseMapper<AuthzAccountRole> {

    /**
     * 根据账号id来获取角色id
     *
     * @param accountId
     * @return
     */
    @Select("select role_id from authz_account_role where account_id = #{accountId}")
    List<Long> getRoleIdsByAccountId(@Param("accountId") Long accountId);

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    Integer batchInsert(@Param("list") List<AuthzAccountRole> list);

    /**
     * 根据角色id查询账号id
     *
     * @param roleId
     * @return
     */
    @Select("select account_id from authz_account_role where role_id = #{roleId}")
    List<Long> getAccountIdsByRoleId(@Param("roleId") Long roleId);

    /**
     * 根据角色id查询管理员id
     *
     * @param roleIds
     * @return
     */
    Set<Long> getAccountIdsByRoleIds(@Param("roleIds") Set<Long> roleIds);

    /**
     * 获取当前站点下站点管理员的账号
     *
     * @return
     */
    @Select("select account_id from authz_account_role aar " +
            "left join authz_role ar on ar.id = aar.role_id " +
            "where ar.site_id = #{site_id} " +
            "and ar.code like '%_site_admin%'")
    Set<Long> getSiteAdminAccountId(@Param("site_id") Long siteId);
    
    
    
    /**
     * 得到所有的管理员，不区分站点信息
     * @return
     */
    @Select("SELECT DISTINCT(account_id) as accountId,site_id as siteId FROM `authz_account_role`")
    List<AuthzAccountRole> getAllAdmin();

    /**
     * 查看管理员是否有菜单权限
     * @param accountId 用户的id
     * @param menuId 菜单的id
     * @return LIST
     */
    List<AuthzRoleMenu> selectMenuListByAccountId(@Param("accountId") Long accountId, @Param("menuId") Long menuId);

    /**
     * 获取用户授权的管理员
     * @param companyId
     * @param siteId
     * @param accountId
     * @return List
     */
    List<Long> getAdminIdsByAccountId(@Param("companyId") Long companyId,
                                    @Param("siteId") Long siteId,
                                    @Param("accountId") Long accountId);

    /**
     * 根据账号id来获取角色id
     * @param accountIds
     * @return
     */
    List<AuthzAccountRole> getRoleIdsByAccountIds(@Param("accountIds") List<Long> accountIds);
}
