package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzGroupMember;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.RowBounds;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 组活动关联用户 Mapper 接口
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
public interface AuthzGroupMemberMapper extends BaseMapper<AuthzGroupMember> {

    /**
     * 点击其他，显示管辖区直接关联的用户
     *
     * @param userGroupId
     * @param rowBounds
     * @return
     */
    @Select("select * from authz_group_member where type = 2 and group_id = #{userGroupId} and deleted = 0")
    List<AuthzGroupMember> getPageByGroupId(@Param("userGroupId") Long userGroupId, RowBounds rowBounds);

    @Select("select count(1) from authz_group_member where type = 2 and group_id = #{userGroupId} and deleted = 0")
    Integer getPageByGroupIdCount(@Param("userGroupId") Long userGroupId);

    /**
     * 根据管辖区id获取memberid列表
     *
     * @param groupId
     * @return
     */
    @Select("select member_id from authz_group_member where type = #{type} and group_id = #{groupId} and deleted = 0")
    List<Long> getMemberIdsByGroupId(@Param("type") Integer type, @Param("groupId") Long groupId);

    /**
     * 根据管辖区id获取groupmember列表
     *
     * @param groupId
     * @return
     */
    @Select("select * from authz_group_member where group_id = #{groupId} and deleted = 0")
    List<AuthzGroupMember> listByGroupId(@Param("groupId") Long groupId);


    /**
     * 根据账号id、部门id查询所在管辖区
     *
     * @param accountId
     * @param orgIds
     * @return
     */
    Set<Long> getIdsByAccountOrgId(@Param("accountId") Long accountId, @Param("orgIds") Set<Long> orgIds);

    Integer batchInsert(@Param("list") List<AuthzGroupMember> list);

    /**
     * 根据类型查找指定管辖区的memberId
     *
     * @param groupId
     * @param type
     * @return
     */
    @Select("select member_id from authz_group_member where group_id = #{groupId} and type = #{type} and deleted = 0")
    Set<Long> getMemberIdByGroupIdAndType(@Param("groupId") Long groupId, @Param("type") Integer type);

    /**
     * 根据类型查找指定管辖区的memberId
     *
     * @param groupIds
     * @param type
     * @return
     */
    @Select("<script>" +
            "select member_id from authz_group_member where deleted = 0 and group_id in" +
            "<foreach collection='groupIds' open='(' close=')' separator=',' item='groupId' index='index'> " +
            " #{groupId}" +
            "</foreach>" +
            "and type = #{type}" +
            "</script>")
    Set<Long> getMemberIdByGroupIdsAndType(@Param("groupIds") List<Long> groupIds, @Param("type") Integer type);

    /**
     * 根据管辖区id查询关联的member
     *
     * @param groupId
     * @return
     */
    @Select("select member_id from authz_group_member where group_id = #{groupId} and deleted = 0")
    Set<Long> getMemberIdByGroupId(@Param("groupId") Long groupId);

    /**
     * 根据管辖区id逻辑删除可见范围
     *
     * @param groupId
     * @return
     */
    @Update("update authz_group_member set deleted = 1 where group_id = #{groupId}")
    Integer deleteByGroupId(@Param("groupId") Long groupId);
}
