package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzRole;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

public interface AuthzRoleMapper extends BaseMapper<AuthzRole> {
    /**
     * 查询重code的角色数量
     *
     * @param id
     * @param siteId
     * @param code
     * @return
     */
    @Select("select count(*)  from authz_role where "
            + "id <> #{id}  and code = #{code} and site_id= #{siteId} and enabled=1")
    int countExistCode(@Param(value = "id") Long id, @Param(value = "siteId") Long siteId, @Param(value = "code") String code);

    /**
     * 查询重name的角色数量
     *
     * @param id
     * @param siteId
     * @param name
     * @return
     */
    @Select("select count(*)  from authz_role where "
            + "id <> #{id} and name = #{name} and site_id= #{siteId} and enabled=1")
    int countExistName(@Param(value = "id") Long id, @Param(value = "siteId") Long siteId, @Param(value = "name") String name);

    /**
     * 根据账号id获取已经关联的角色
     *
     * @return
     */
    List<AuthzRole> getByAccountId(@Param("accountId") Long accountId);

    /**
     * 根据账号 获取 指定站点下分配的 角色
     *
     * @param accountId
     * @param siteId
     * @return
     */
    List<AuthzRole> getByAccountAndSiteId(@Param("accountId") Long accountId, @Param("siteId") Long siteId);

    /**
     * 由模块查出角色（站点内）
     * <p>
     * 模块 --> 角色
     *
     * @param code
     * @param accountId
     * @param siteId
     * @return
     */
    List<Long> getIdByModuleCodeInSite(@Param("code") String code, @Param("accountId") Long accountId, @Param("siteId") Long siteId);

    /**
     * 查询一个站点下所有的启用角色 id（各自管理各自的角色）
     *
     * @param siteId
     * @param currentManagerAccountId 当前用户创建的角色
     * @return
     */
    @Select("select id from authz_role where site_id = #{siteId} and enabled = 1 and create_by_id = #{createById}")
    Set<Long> getIdsBySiteId(@Param("siteId") Long siteId, @Param("createById") Long currentManagerAccountId);
}
