package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.LoginLog;
import com.yizhi.system.application.vo.LoginDataStatisticsVO;
import com.yizhi.system.application.vo.LoginUserChartVO;
import com.yizhi.system.application.vo.LoginUserExportVO;
import com.yizhi.system.application.vo.LoginUserOrgExportVO;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-06-08
 */
public interface LoginLogMapper extends BaseMapper<LoginLog> {

    public List<LoginUserChartVO> loginLogChart(@Param("startDate") String startDate,
                                                @Param("endDate") String endDate,
                                                @Param("type") Integer type,
                                                @Param("cid") Long cid,
                                                @Param("siteId") Long siteId,
                                                @Param("orgs") List<Long> orgs);

    public List<LoginUserOrgExportVO> loginLogByOrg(@Param("startDate") String startDate,
                                                    @Param("endDate") String endDate,
                                                    @Param("cid") Long cid,
                                                    @Param("siteId") Long siteId,
                                                    @Param("orgs") List<Long> orgs);

    public List<LoginUserOrgExportVO> orgGroup(@Param("kwd") String kwd,
                                                @Param("cid") Long cid,
                                                @Param("siteId") Long siteId,
                                                @Param("orgs") List<Long> orgs);

//    public List<LoginUserExportVO> loginLogByAccount(@Param("startDate") String startDate,
//                                                     @Param("endDate") String endDate,
//                                                     @Param("cid") Long cid,
//                                                     @Param("siteId") Long siteId,
//                                                     @Param("orgs") List<Long> orgs);

    public List<LoginUserExportVO> accountGroup(@Param("kwd") String kwd,
                                                @Param("cid") Long cid,
                                                @Param("siteId") Long siteId,
                                                @Param("orgs") List<Long> orgs);
    
    public LoginDataStatisticsVO getLoginCountBySiteId(@Param("siteId")Long siteId);
    
    public List<LoginUserExportVO> loginLogByAccount(@Param("kwd") String kwd,
    		@Param("startDate") String startDate,
            @Param("endDate") String endDate,
            @Param("cid") Long cid,
            @Param("siteId") Long siteId,
            @Param("orgs") List<Long> orgs);

    Integer countActiveAccount(@Param("siteId") long siteId, @Param("startDate") Date startDate,
                               @Param("endDate") Date endDate);

    /**
     * 按照天统计 人数
     * @param siteId
     * @param day
     * @return
     */
    List<LoginLog> getListByDay(@Param("siteId") long siteId, @Param("day") Date day);
    
    List<LoginLog> getLogByDate(@Param("siteId") Long siteId,@Param("accountId") Long accountId,@Param("date") Date date);
}

