package com.yizhi.system.application.service;

import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.domain.AuthzRole;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.system.application.model.AccessSite;
import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.util.HQInManageParam;
import com.yizhi.system.application.vo.practice.OrgAccountVo;

import java.util.List;
import java.util.Set;

/**
 * 权限服务接口
 *
 * @Author: shengchenglong
 * @Date: 2018/5/18 11:34
 */
public interface AuthService {

    /**
     * 管理端：可以管理的站点列表
     *
     * @param accountId
     * @return
     */
    @Deprecated
    List<Site> getAccessSite(Long accountId);

    /**
     * 管理端：可以访问de站点
     *
     * @param companyId
     * @param accountId
     * @return
     */
    Set<Long> AccessSiteIds(Long companyId, Long accountId);

    /**
     * 后台管理：获取一个站点的管理权限
     *
     * @param accountId
     * @param siteId
     * @return
     */
    AuthAccountSiteModel getSiteAutho(String companyCode, Long companyId, Long accountId, Long siteId, String key);

    /**
     * 学员端：是否可以访问的站点
     *
     * @param companyId
     * @param accountId
     * @return
     */
    Set<Long> AccessSiteIdsFront(Long companyId, String companyCode, Long accountId);

    /**
     * 学员端relationids
     *
     * @param companyId
     * @param accountId
     * @param siteId
     * @return
     */
    List<Long> getRelationIds(Long companyId, Long accountId, Long siteId);

    /**
     * 获取用户可以管理的站点和相应菜单
     *
     * @param accountId
     * @return
     */
    List<AccessSite> getAccessSiteWithMenu(String companyCode, Long accountId, Long siteId) throws AuthNoManagementException, AuthNotManageException;

    /**
     * 获取管理员管辖的用户 id 集合
     *
     * @param site
     * @param context
     * @param moduleType
     * @return
     */
    Set<Long> getAccountIdsInManage(Site site, RequestContext context, AuthzConstant.moduleType moduleType);

    /**
     * 获取分级授权的 管辖范围 参数
     * @param accountId
     * @param site
     * @param moduleType
     * @return
     */
    HQInManageParam getHQInManageParam(Long accountId, Site site, AuthzConstant.moduleType moduleType);

    /**
     * 根据登陆人的ID和siteID 获取关联的部门及子部门和用户
     * @param accountId
     * @param siteId
     * @return
     */
    public OrgAccountVo getOrgAndUserOfAdmin(Long accountId, Long siteId);

    /**
     * 返回 用户管辖的部门及用户 与 业务可见范围中 部门Id,用户ID 交集中的用户数量
     * @param adminManageUserInfo 用户管辖的部门及用户
     * @param serviceVisibleOrgIds 业务可见范围中 部门可见的Id集合
     * @param serviceVisibleUserIds 业务可见范围中 可见用户的ID集合
     * @return 管辖区下可见业务的用户数量
     */
    public Integer getOverlapUserCount(OrgAccountVo adminManageUserInfo,List<Long> serviceVisibleOrgIds,List<Long> serviceVisibleUserIds,Long siteId,Long companyId);


    /**
     * 根据用户ID查询关联角色
     * @param accountId
     * @return
     */
    public List<AuthzRole> getByAccountId(Long accountId);
}
