package com.yizhi.system.application.service;

import java.util.List;

import com.yizhi.system.application.vo.Tree;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/20 15:42
 */
public interface AuthorityService {

    /**
     * 获取公司整个部门树
     * @return
     */
    List<Tree> getAllOrgTree(Long companyId);
    /**
     * 生成公司部门树
     * @param companyId
     * @return
     */
    List<Tree> buildLayerOrgIds(Long companyId);
    /**
     * 获取子部门
     * @param id
     * @param companyId
     * @return
     */
    List<Long> getChildOrgIds(Long id,Long companyId);
    /**
     * 获取某一个部门的树
     * @param orgId
     * @param companyId
     * @return
     */
    Tree getOrgTree(Long orgId,Long companyId); 
    /**
     * 根据用户id和站点id获取可查看数据的部门id和用户组id列表
     * @param accountId
     * @param siteId
     * @return
     */
    List<Long> getAuthOrgAndGroup(Long accountId,Long siteId);
    /**
     * 获取父部门
     * @param id
     * @param companyId
     * @return
     */
    List<Long> getChiefOrgIds(Long id,Long companyId);

}
