package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.system.application.model.AccountImpModel;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.model.RangeModel;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.AccountEnableLog;
import com.yizhi.system.application.domain.AuthzRole;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.system.application.utils.recursion.TreeObjectVO;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IAccountService extends IService<Account> {

    /**
     * 获取待入职的员工
     * @param userName
     * @param companyId
     * @param siteId
     * @return
     */
    List<OutsideUserVO> getRcUsers(String userName, Long companyId, String siteId);

    /**
     * 获取企业下对接的全部启用用户信息
     * @param companyId
     * @param enable
     * @return
     */
    List<OutsideUserVO> getCompanyOutsideUsers(Long companyId, Integer enable);

    /**
     * 检查手机验证码是否正确
     *
     * @param smsSendBizType 发送短信业务类型
     * @param mobile         手机号
     * @param verifyCode     验证码
     * @param extend         是否需要扩展字段处理特殊业务
     */
    void checkVerifyCode(SmsSendBizType smsSendBizType, Long mobile, String verifyCode, String extend);

    /**
     * 检查手机号是否存在
     *
     * @param mobile
     * @return
     * @throws BizException
     */
    Account mobileBindCheck(long mobile) throws BizException;

    /**
     * 检查修改的密码的数据是否符合业务规范
     *
     * @param vo 要修改的数据
     * @return
     */
    Account checkUpPwdData(FirstLoginUpdateVO vo, SmsSendBizType smsSendBizType,
                           String smsSendRequestNo) throws BizException;

    /**
     * 新增账号
     *
     * @param account
     * @return
     */
    Long add(Account account);

    /**
     * 更新账号
     *
     * @param account
     * @return
     */
    Boolean update(Account account);

    /**
     * 禁止账号
     *
     * @param log
     * @return
     */
    Boolean close(AccountEnableLog log);

    /**
     * 开通账号
     *
     * @param log
     * @return
     */
    Boolean open(AccountEnableLog log);

    /**
     * 更新密码
     *
     * @param id
     * @param password
     * @return
     */
    Boolean updatePassword(Long id, String password);

    /**
     * 查询账号列表
     *
     * @param account
     * @return
     */
    Page<Account> list(Account account, Page<Account> page);

    /**
     * 站点下的管理员
     * @param account
     * @param page
     * @return
     */
    Page<Account> managerList(AccountPageVO accountPageVO);
    /**
     * 查找账号角色列表
     *
     * @param accountId
     * @return
     */
    List<AuthzRole> findRoles(Long accountId);

    /**
     * 根据账号名和公司查找账号
     *
     * @param companyId
     * @param accountName
     * @return
     */
    Account find(Long companyId, String accountName);

    /**
     * 根据名称(用户名和全名)
     *
     * @param name
     * @return
     */
    List<Account> fuzzySearchByName(String name, Long companyId);

    /**
     * 判断名称唯一
     *
     * @param companyId
     * @param name
     * @return
     */
    Boolean nameExists(Long id, Long companyId, String name);

    /**
     * 根据ids列表查询账号列表
     *
     * @param ids
     * @return
     */
    List<Account> getAccountByIds(List<Long> ids);

    /**
     * 根据orgName模糊查询符合条件下的部门account列表
     *
     * @param name
     * @return
     */
    List<Account> getAccountByOrgName(String name, Long companyId);

    /**
     * 获取账号信息
     *
     * @param id
     * @return
     */
    Account get(Long id);

    /**
     * 获取账号信息
     *
     * @param id
     * @return
     */
    Account getCard(Long id);

    /**
     * 批量修改部门
     *
     * @param accountIds
     * @param orgId
     */
    void batchUpdateOrg(List<Long> accountIds, Long orgId);

    /**
     * 批量解绑微信
     *
     * @param accountIds
     */
    void batchDeleteWechat(List<Long> accountIds);

    /**
     * 批量禁用账号
     *
     * @param accountIds
     */
    void batchDisable(List<Long> accountIds);

    /**
     * 根据企业id和组织id查询组织的下级组织和当前组织下的用户
     *
     * @param cid
     * @param orgId
     * @param siteId
     * @param queryStr 查询字段
     * @param type     1:组织；2：用户；3：用户组
     * @return
     */
    List<OrgAccountVO> selectOrgAndAccount(Long cid, Long orgId, Long siteId, String queryStr, int type);

    /**
     * 查询部门下所有的员工
     *
     * @param orgId
     * @return
     */
    List<Account> selectByOrgId(Long orgId, Long companyId);

    /**
     * 查询用户组下所有的员工
     *
     * @param groupId
     * @return
     */
    List<Account> selectByGroupId(Long groupId, Long companyId);

    /**
     * 获取全平台下所有的用户
     *
     * @param siteId
     * @return
     */
    List<Account> selectBySiteId(Long siteId);

    /**
     * 判断用户对站点是否有访问权限
     *
     * @param accountId
     * @param siteId
     * @return
     */
    Boolean isAccessToSite(Long accountId, Long siteId);

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param userInfoVO
     * @return
     */
    Map<Long, UserInfoVO> selectUserInfo(UserInfoVO userInfoVO);

    /**
     * 查询用户列表
     * @param userInfoVO
     * @return
     */
    List<Account> getUserInfoVOList(UserInfoVO userInfoVO);

    /**
     * 获取排序后逇idlist
     * @param accountIdList
     * @return
     */
    List<Long> selectAccountIdList(List<Long> accountIdList);

    /**
     * 根据企业id查询组织列表
     *
     * @param companyId
     * @return
     */
    List<TreeObjectVO> selectOrgList(long companyId);

    /**
     * 根据相关类型和id查询用户信息
     * key为count时，value为人数
     * key为account时，value为用户列表
     *
     * @param models
     * @return
     */
    Map<String, Object> findMemberInfo(List<RangeModel> models);

    /**
     * 新增用户app id
     *
     * @param account
     */
    void updateRegistrationId(Account account);

    /**
     * 组织下人员接口-其他 -- 权限改造
     *
     * @param userGroupId
     * @param name
     * @param mobile
     * @param workNum
     * @param fullName
     * @param email
     * @param enabled
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<Account> orgAccountListPageOther(Long userGroupId, String name, String mobile,
                                          String workNum, String email,
                                          Integer enabled, Integer pageNo, Integer pageSize);

    /**
     * 组织下人员接口-部门 -- 权限改造
     *
     * @param rightLeftIndices
     * @param name
     * @param mobile
     * @param workNum
     * @param fullName
     * @param email
     * @param enabled
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<Account> orgAccountListPage(Long companyId, List<RightLeftIndex> rightLeftIndices, String name, String mobile,Long orgId,
                                     String workNum, String fullName, String email,
                                     Integer enabled, Integer pageNo, Integer pageSize);


    Page<Account> orgAccountListById(Long companyId, List<RightLeftIndex> rightLeftIndices, String name, String mobile,Long orgId,
                                     String workNum, String fullName, String email,
                                     Integer enabled, Integer pageNo, Integer pageSize);

    /**
     * 管辖范围内，查询用户列表
     *
     * @param noRange          是否不管orgIds和userGroupIds，查询所有（查全企业）
     * @param rightLeftIndices
     * @param userGroupIds
     * @param companyId
     * @return
     */
    List<Account> listByNamesInManageRange(List<String> names, Boolean noRange,
                                           List<RightLeftIndex> rightLeftIndices, List<Long> userGroupIds, Long companyId,Integer type);

    /**
     * 根据用户id集合查询用户信息
     *
     * @param ids
     * @return
     */
    List<AccountVO> idsGet(List<Long> ids);

    /**
     * 查询一个站点下的用户数
     *
     * @param siteId
     * @param companyId
     * @return
     */
    Integer getSiteAccountNum(Long siteId, Long companyId);

    /**
     * 查询一个站点下的用户
     *
     * @param siteId
     * @param companyId
     * @return
     */
    List<Account> getSiteAccount(Long siteId, Long companyId);


    /**
     * 用户的导入
     *
     * @param importModel
     * @return
     */

    List<AccountImpModel> importAccount(ImportModel importModel, RequestContext context);


    /**
     * 查询用户信息
     *
     * @param orgs
     * @param pageNo
     * @param pageSize
     * @param orgName
     * @param userName
     * @return
     */
    PageInfo<ReportAccountRespVO> getOrgsUsers(List<Long> orgs, Integer pageNo, Integer pageSize, String orgName, String userName);

    /**
     * 查询指定范围内的用户名列表
     *
     * @param ids
     * @return
     */
    Map<String, Long> getRangeUserNames(Set<Long> ids);

    Long getRangeAccountCountNum(List<Long> ids, boolean isAllAccout, String nameOrFullName, Long groupId);

    /**
     * 获取用户的详情
     *
     * @param name      用户名
     * @param companyId 公司id
     * @return
     */
    AccountVO findUser(String name, Long companyId);

    /**
     * 查询id
     *
     * @param account
     * @return
     */
    Set<Long> getIds(Account account);

    /**
     * 查询id
     *
     * @param account
     * @param rightLeftIndices
     * @return
     */
    Set<Long> getIds(Account account, List<RightLeftIndex> rightLeftIndices);

    /**
     * 获取指定部门下的用户，包含子部门（包含指定的用户）
     *
     * @param companyId
     * @param orgIds
     * @param accountIds
     * @return
     */
    Set<Account> getList(Long companyId, Collection<Long> orgIds, Collection<Long> accountIds);

    /**
     * 根据用户名来查询账号 id，包括数据权限的校验
     *
     * @param names
     * @param companyId
     * @param SiteId
     * @param managerContext
     * @param moduleType
     * @return
     */
    Map<String, Long> getAccountIdByNames(List<String> names, Long companyId, Long SiteId, RequestContext managerContext, String moduleType);

    /**
     * 判断图形验证码是否正确
     *
     * @param captchaKey 验证码请求前端生成的UUID
     * @param captchaVal 前端输入的验证码值
     * @return 相等验证通过返回true
     */
    boolean validateCaptcha(String captchaKey, String captchaVal);

    /**
     * 验证手机号
     */
    Integer VerifyPhoneNum(String phone);

    /**
     * PC端修改个人信息   账号-姓名-头像-公司名称-职级-手机号-个人介绍
     *
     * @param account
     * @return
     */

    Boolean updateInfo(Account account);

    /**
     * 对图形、短信验证码进行校验
     *
     * @param smsSendBizType
     * @param mobile
     * @param verifyCode
     * @return
     */
    Boolean VerifyCode(SmsSendBizType smsSendBizType, String mobile, String verifyCode);


    /**
     * 根据companId,id查询账号姓名
     *
     * @param companyId
     * @param ids
     * @return
     */
    List<Account> getAccountsByCompanIdIds(Long companyId, List<Long> ids);


    /**
     * 查询用户id集合
     *
     * @param orgId
     * @param isEnable
     * @return
     */
    List<Long> listAccountIdByOrgIdAndEnable(Long orgId, Boolean isEnable);

    /**
     *
     * @param companyId
     * @param enabled
     * @param accountName   模糊查询accountName,fullName
     * @param orgName       模糊查询orgname,orgCode
     * @param indices
     * @param accountIds
     * @return
     */
    List<ReportAccountRespVO> getReportAccountRespVO(Long companyId, Boolean enabled, String accountName, String orgName, List<RightLeftIndex> indices, List<Long> accountIds,List<Long> orgIds, boolean allComppany, Page page);

    /**
     *
     * @param companyId
     * @param enabled
     * @param accountName
     * @param orgName
     * @param indices
     * @param accountIds
     * @return
     */
    List<Long> getAccountId(Long companyId, Boolean enabled, String accountName, String orgName, List<RightLeftIndex> indices, List<Long> accountIds);

    Long getReportAccountRespVOCount(Long companyId, Boolean enabled, List<RightLeftIndex> indices, List<Long> accountIds, boolean allComppany);

    List<Account> getByParam(Long companyId, Boolean enabled, String accountName, String mobile, List<RightLeftIndex> rightLeftIndices, List<Long> accountIds, Page<Account> page);

    /**
     * 丁小伟添加,外部经验导入需要用户的部门id和部门名称
     *
     * @param names
     * @param companyId
     * @param siteId
     * @param managerContext
     * @param moduleType
     * @return
     */
    Map<String, Map<String, Object>> getAccountByNames(List<String> names, Long companyId, Long siteId, RequestContext managerContext, String moduleType);

    List<AccountCountVO> getAccountCount(Long companyId);

    Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page);

    Page getPageByRuleItems(RuleVisibleRangeVo vo,Page page);

    /**
     * 保存第用户
     * @param account
     * @return
     */
    Account saveThirdAccount(Account account);

    Map<Long, UserInfoVO> getUser(UserInfoVO userInfoVO);

    Integer getUserCount(List<Long> orgIds,Long companyId);

    Long findSiteId(Long accountId);
}
