package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.AuthzAccountRole;
import com.yizhi.system.application.domain.AuthzRoleMenu;

import java.util.List;

/**
 * <p>
 * 角色和账号关联表
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
public interface IAuthzAccountRoleService extends IService<AuthzAccountRole> {
	
	
	/**
	 * 得到所有管理员，不区分站点
	 * @return
	 */
	List<AuthzAccountRole> getAllAdmin();


    /**
     * 查询用户的id
     * @param accountId
     * @param menuId
     * @return
     */
    List<AuthzRoleMenu> selectMenuListByAccountId(Long accountId, Long menuId);

    /**
     * 获取业务下授权的管理员
     * @param companyId
     * @param siteId
     * @param accountId
     * @return
     */
    List<Long> getAdminIdsByAccountId(Long companyId,Long siteId,Long accountId);

	/**
	 * 根据用户ID查询关联角色ID集合
	 * @param accountIds
	 * @return
	 */
	List<AuthzAccountRole> getRoleIdsByAccountIds(List<Long> accountIds);
}
