package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.AuthzResource;
import com.yizhi.system.application.vo.AuthzResourceVo;
import com.yizhi.system.application.vo.OperationVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 操作表 服务类
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-09
 */
public interface IAuthzResourceService extends IService<AuthzResource> {
    /**
     * 添加一条资源
     *
     * @param authzResource
     * @return
     */
    Boolean saveAuthzResource(AuthzResource authzResource);

    /**
     * 删除一条资源
     *
     * @param id
     * @return
     */
    Boolean deleteAuthzResource(Long id);

    /**
     * 修改一条资源
     *
     * @param authzResource
     * @return
     */
    Boolean updateAuthzResource(AuthzResource authzResource);

    /**
     * 根据ID查询一条资源
     *
     * @param id
     * @return
     */
    AuthzResource queryAuthzResource(Long id);

    /**
     * 分页查询资源信息
     *
     * @param name
     * @param pageNo
     * @param pageSize
     * @return
     */

    Page<AuthzResource> ListAuthzResource(String name,Integer status ,Integer pageNo, Integer pageSize);


    /**
     * 查询所有的父节点
     *
     * @return
     */
    List<AuthzResource> getParentOperations();

    /**
     * 根据父节点查询子节点
     *
     * @param parentId 父节点ID
     * @return
     */
    Map<String, List<AuthzResource>> getSubOperations(Long parentId);

    /**
     * 获取菜单树状列表
     *
     * @return
     */
    List<OperationVO> getMenuList();

//    /**
//     * 获取用户菜单
//     *
//     * @return
//     */
//    List<CommonTree> getMenu(Long accountId, List<Long> roleIds);

    /**
     * 忽略操作
     * @param id
     * @return
     */
    Boolean ignoreAction(Long id);

    /**
     * 修改资源Vo
     *
     * @param authzResourceVo
     * @return
     */
    Boolean updateAuthzResourceVo(AuthzResourceVo authzResourceVo);

    /**
     * 根据菜单Id，查询相应资源
     * @param menuId
     * @return
     */
    List<AuthzResource> menuResourceList(Long menuId);

}