package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.AuthzUserGroup;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * 学习组 服务类
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
public interface IAuthzUserGroupService extends IService<AuthzUserGroup> {
    /**
     * 新增用户组
     *
     * @param group
     * @return
     */
    Boolean save(AuthzUserGroup group);

    /**
     * 修改用户组
     *
     * @param group
     * @return
     */
    Boolean update(AuthzUserGroup group);

    /**
     * 删除用户组
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 查询用户组
     *
     * @param id
     * @return
     */
    AuthzUserGroup findById(Long id);

    /**
     * 查询用户组列表
     *
     * @param group
     * @param manageAccountId 所属管理员id
     * @return
     */
    List<AuthzUserGroup> list(AuthzUserGroup group, Long manageAccountId);

    /**
     * 检查名称是否存在
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    Boolean checkName(Long id, String name, Long companyId, Long siteId);

    /**
     * 分页查询用户组列表
     *
     * @param group
     * @param page
     * @return
     */
    Page<AuthzUserGroup> listByPage(AuthzUserGroup group, Page<AuthzUserGroup> page);

    /**
     * 根据groupId查询orgId列表和accountId列表
     * key为org时取的是orgId列表
     * key为org时取的是accountId列表
     *
     * @param groupId
     * @return
     */
    Map<String, List<Long>> getOrgIdAndAccountIdByGroupId(Long groupId);

    /**
     * 根据角色id获取
     *
     * @param roleId
     * @return
     */
    Set<Long> getByRoleId(List<Long> roleId);

    /**
     * 删除权限缓存
     *
     * @param companyCode
     * @param siteCode
     * @param groupId
     */
    void deleteAccountAuthzInfo(String companyCode, String siteCode, Long groupId);

    /**
     * 管辖区人数
     *
     * @param companyId 所属企业id
     * @param groupId   要查询的管辖区
     * @return
     */
    Integer getGroupAccountNum(Long companyId, Long groupId);
}
