package com.yizhi.system.application.service;

import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.CompanyContactor;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;

import java.util.List;

/**
 * <p>
 * 企业管理 服务类
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
public interface ICompanyService extends IService<Company> {


	List<Company> findAllCompany();

	/**
	 * 查询公司列表
	 * @param company
	 * @param page
	 * @return
	 */
	
	Page<Company> list(Company company,Page<Company> page);
	
	/**
	 * 更改服务到期时间
	 * @param company
	 * @return
	 */
	Boolean updateEndTime(Company company);
	
	/**
	 * 更改企业状态
	 * @param id
	 * @return
	 */
	Boolean updateState(Long id,Integer companyState);
	
	/**
	 * 更改企业名字
	 * @param id
	 * @param companyName
	 * @return
	 */
	Boolean updateCompanyName(Long id,String companyName);
	
	/**
	 * 更改公司联系人
	 * @param contactor
	 * @return
	 */
	Boolean updateContact(CompanyContactor contactor);
	
    
    /**
     * 查找公司封装vo
     * @param id
     * @return
     */
    Company get(Long id);
	/**
	 * 查找公司封装vo
	 * @param id
	 * @return
	 */
	Page<Company> getPage(Long id, Integer pageNo, Integer pageSize);
    /**
     * 新增公司信息
     * @param company 
     * @return
     */
    Boolean insertDetail(Company company);
    /**
     * 修改公司信息
     * @param company
     * @return
     */
    Boolean update(Company company);
    /**
     * 删除企业联系人
     * @param contactor
     * @return
     */
    void deleteContact(CompanyContactor contactor);
    /**
     * 新增企业联系人
     * @param contactor
     * @return
     */
    void insertContact(CompanyContactor contactor);
    
    /**
     * 根据授权码获取企业信息
     * @param authcode
     * @return
     */
    CompanyVO findByAuthCode(@Param(value="authcode") String authcode);
}
