package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.model.BaseModel;
import com.yizhi.system.application.request.SiteUnselectedResq;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.vo.CompanySiteVO;
import com.yizhi.system.application.vo.SiteAdminVo;
import com.yizhi.system.application.vo.SiteProtectDefinedVO;
import com.yizhi.system.application.vo.SiteVO;

import java.util.List;

/**
 * <p>
 * 站点 服务类
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
public interface ISiteService extends IService<Site> {
    /**
     * 新增站点
     *
     * @param model
     * @return
     */
    Boolean save(BaseModel<SiteVO> model);

    /**
     * 修改站点
     *
     * @param model
     * @return
     */
    Boolean update(BaseModel<SiteVO> model);

    /**
     * 上架站点
     *
     * @param id
     * @return
     */
    Boolean up(Long id, String companyCode);

    /**
     * 下架站点
     *
     * @param id
     * @return
     */
    Boolean down(Long id, String companyCode);

    /**
     * 查询站点
     *
     * @param id
     * @return
     */
    Site findById(Long id);

    /**
     * 根据公司id查询
     *
     * @param companyId
     * @return
     */
    List<Site> findByCompanyId(Long companyId);

    /**
     * 检查code是否存在
     *
     * @param id
     * @param companyId
     * @param code
     * @return
     */
    Boolean checkCode(Long id, Long companyId, String code);

    /**
     * 检查名称是否存在
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    Boolean checkName(Long id, Long companyId, String name);

    /**
     * 分页查找公司内站点列表
     *
     * @param site
     * @param page
     * @return
     */
    Page<Site> list(Site site, Page<Site> page,Long accessSiteId);

    //	权限改造#####################################################################################

    /**
     * 设置站点管理员
     *
     * @param model
     * @return
     */
    Integer setSiteAdmin(BaseModel<SiteAdminVo> model);

    /**
     * 查询站点管理员
     *
     * @param siteId
     * @return
     */
    List<Account> getSiteAdmin(Long siteId);

    /**
     * 清除站点下组织缓存信息
     *
     * @param siteCode
     * @param companyCode
     */
    void clearSiteOrgIdsCache(String siteCode, String companyCode);

    /**
     * 课程授权其他站点列表
     *
     * @param context 当前用户的上下文
     * @return
     */
    List<Site> courseAuthOtherSite(RequestContext context);

    List<Long> getAllSiteId();

    List<Site> getAllSiteByCompanyCode(String companyCode);

    /**
     * 获取所有站点列表
     * @return
     */
    List<CompanySiteVO> getSiteList();
    
    /**
     * 根据公司id查询
     *
     * @param companyId
     * @return
     */
    List<Site> getSites(Long companyId);
    
    List<Long> getSiteIds(Long companyId);

    /**
     * 根据条件查询站点列表
     * @param siteReq 查询条件
     * @return 站点列表
     */
    Page<SiteProtectDefinedVO> getUnselectedSiteList(SiteUnselectedResq siteReq);

    Page<Site> getPage(Site site, Page<Site> page);

    void initSiteLoginCode();

    /**
     * 获取站点的唯一code
     *
     * @return
     */
     String getLoginCode();

}
