package com.yizhi.system.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.enums.MemberType;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.core.application.enums.SmsSendMode;
import com.yizhi.core.application.enums.TaskParamsEnums;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.system.application.constant.AccountExportConditionConstant;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.constant.CheckPassword;
import com.yizhi.core.application.constant.DroolsRelation;
import com.yizhi.system.application.constant.ImpAccountError;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.controller.manage.AccountController;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.mapper.*;
import com.yizhi.system.application.service.*;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.core.application.log.LogQueue;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.system.application.enums.AccountDisableReason;
import com.yizhi.system.application.enums.OrderField;
import com.yizhi.system.application.model.AccountImpModel;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.model.RangeModel;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.util.OrgIndexUtil;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.util.application.clazz.ClassUtil;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.regex.RegexUtil;
import com.yizhi.system.application.utils.recursion.TreeObjectVO;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.domain.*;
import com.yizhi.wechat.application.vo.wechat.domain.TrAccountUserinfoVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class AccountServiceImpl extends ServiceImpl<AccountMapper, Account> implements IAccountService {

    private static final int SECOND = -90; //短信过期时间
    private static final Logger logger = LoggerFactory.getLogger(AccountServiceImpl.class);

    @Autowired
    AccountMapper accountMapper;
    @Autowired
    AuthzAccountRoleMapper accountRoleMapper;
    @Autowired
    AuthzRoleMapper roleMapper;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    SiteMapper siteMapper;
    @Autowired
    CompanyMapper companyMapper;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    AccountEnableLogMapper logMapper;
    @Autowired
    AuthzGroupMemberMapper memberMapper;
    @Autowired
    IAuthzUserGroupService groupService;
    @Autowired
    OrganizationMapper organizationMapper;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private AuthzGroupMemberMapper groupMemberMapper;
    @Autowired
    private OrganizationIndexService organizationIndexService;
    @Autowired
    private OrganizationCacheService organizationCacheService;
    @Autowired
    private AuthService authService;
/*
    @Autowired
    RabbitTemplate rabbitTemplate;*/

    @Autowired
    RedisCache redisCache;

    @Autowired
    WeiXinClient weiXinClient;

    @Autowired
    private ISmsSendRecordService smsSendRecordService;

    @Override
    public Map<String, Long> getRangeUserNames(Set<Long> ids) {
        List<ReportAccountRespVO> searchRet = accountMapper.getRangeUserNames(ids);
        if (CollectionUtils.isNotEmpty(searchRet)) {
            Map<String, Long> data = searchRet.stream().parallel().collect(Collectors.toMap(
                    key -> key.getUserName(), val -> val.getUserId()));
            return data;
        } else {
            return null;
        }
    }

    @Override
    public Long getRangeAccountCountNum(List<Long> ids, boolean isAllAccout,
                                        String nameOrFullName, Long groupId) {
        return this.baseMapper.getOrgsRangeUserCountNum(ids, isAllAccout, nameOrFullName, groupId);
    }


    @Override
    public AccountVO findUser(String name, Long companyId) {
        Account account = new Account();
        account.setName(name);
        account.setCompanyId(companyId);
        account.setEnabled(true);
        Account user = this.selectOne(QueryUtil.condition(account));
        AccountVO accountVO = new AccountVO();

        if (user != null) {
            BeanUtils.copyProperties(user, accountVO);
            return accountVO;
        } else {
            return null;
        }

    }

    @Override
    public Set<Long> getIds(Account account) {
        if (null != account) {
            return accountMapper.getIds(account);
        }
        return null;
    }

    @Override
    public Set<Long> getIds(Account account, List<RightLeftIndex> rightLeftIndices) {
        if (null != account && CollectionUtils.isNotEmpty(rightLeftIndices)) {
            return accountMapper.getIdsInManage(account, rightLeftIndices);
        }
        return null;
    }

    @Override
    public Set<Account> getList(Long companyId, Collection<Long> orgIds, Collection<Long> accountIds) {
        List<RightLeftIndex> indices = null;
        if (!CollectionUtils.isEmpty(orgIds)) {
            List<Organization> organizations = organizationService.selectBatchIds(orgIds);
            if (!CollectionUtils.isEmpty(organizations)) {
                indices = OrgIndexUtil.getChildrenRange(organizations);
            }
        }
        if (CollectionUtils.isNotEmpty(indices) || CollectionUtils.isNotEmpty(accountIds)) {
            return accountMapper.getInManage(companyId, indices, accountIds);
        }
        return null;
    }

    @Override
    public Map<String, Long> getAccountIdByNames(List<String> names, Long companyId,
                                                 Long siteId, RequestContext managerContext, String moduleType) {
        if (!CollectionUtils.isNotEmpty(names)) {
            return null;
        }
        Site site = siteMapper.selectById(siteId);
        if (site != null) {
            Set<Long> idsInManage = authService.getAccountIdsInManage(site, managerContext, AuthzConstant.moduleType.valueOf(moduleType));
            if (CollectionUtils.isNotEmpty(idsInManage)) {
                List<List<String>> nameListList = splitList(names, 300);
                List<Account> queryAccounts = null;
                Map<String, Long> map = new HashMap<>(names.size());
                for (List<String> nameList : nameListList) {
                    queryAccounts = accountMapper.getIdsByNames(nameList, companyId);
                    if (!CollectionUtils.isEmpty(queryAccounts)) {
                        for (Account account : queryAccounts) {
                            map.put(account.getName().toLowerCase(), account.getId());
                        }
                    }
                }
                return map;
            }
        }
        return null;
    }

    @Override
    public Map<String, Map<String, Object>> getAccountByNames(List<String> names, Long companyId, Long siteId, RequestContext managerContext, String moduleType) {
        if (!CollectionUtils.isNotEmpty(names)) {
            return null;
        }
        Site site = siteMapper.selectById(siteId);
        if (site != null) {
            Set<Long> idsInManage = authService.getAccountIdsInManage(site, managerContext, AuthzConstant.moduleType.valueOf(moduleType));
            if (CollectionUtils.isNotEmpty(idsInManage)) {
                List<List<String>> nameListList = splitList(names, 300);
                List<Account> queryAccounts = null;
                Map<String, Map<String, Object>> resultMap = new HashMap<>(names.size());
                for (List<String> nameList : nameListList) {
                    queryAccounts = accountMapper.getIdsByNames(names, companyId);
                    if (!CollectionUtils.isEmpty(queryAccounts)) {
                        for (Account account : queryAccounts) {
                            Map<String, Object> map = new HashMap<>(3);
                            map.put("accountId", account.getId());
                            map.put("orgId", account.getOrgId());
                            map.put("orgName", account.getOrgName());
                            resultMap.put(account.getName(), map);
                        }
                    }
                }
                return resultMap;
            }
        }
        return null;
    }

    /**
     * 查询用户信息
     *
     * @param orgs
     * @param pageNo
     * @param pageSize
     * @param orgName
     * @param userName
     * @return
     */
    @Override
    public PageInfo<ReportAccountRespVO> getOrgsUsers(List<Long> orgs, Integer
            pageNo, Integer pageSize, String orgName, String userName) {
        if (StringUtils.trimToEmpty(orgName).equals(StringUtils.EMPTY)) {
            orgName = null;
        } else {
            orgName = "%" + orgName + "%";
        }

        if (StringUtils.trimToEmpty(userName).equals(StringUtils.EMPTY)) {
            userName = null;
        } else {
            userName = "%" + userName + "%";
        }
        PageInfo<ReportAccountRespVO> retInfo = new PageInfo<>();
        Page<ReportAccountRespVO> page = null;
        if (pageNo != null) {
            page = new Page<>();
            page.setCurrent(pageNo);
            page.setSize(pageSize);
            List<ReportAccountRespVO> searchRet = accountMapper.getOrgsCountUser(page, orgs, orgName, userName);
            retInfo = PageUtil.versa(page.setRecords(searchRet));
        } else {
            List<ReportAccountRespVO> searchRet = accountMapper.getOrgsCountUser(orgs, orgName, userName);
            retInfo.setRecords(searchRet);
        }
        return retInfo;
    }

    /**
     * 检查手机号是否存在
     *
     * @param mobile
     * @return
     * @throws BizException
     */
    @Override
    public Account mobileBindCheck(long mobile) throws BizException {
        RequestContext rc = ContextHolder.get();
        Account account = new Account();
        account.setEnabled(true);
        account.setMobile(String.valueOf(mobile));
        account.setCompanyId(rc.getCompanyId());
        List<Account> accounts = this.selectList(QueryUtil.condition(account));
        if (CollectionUtils.isEmpty(accounts)) {
            // 手机号码未绑定
            throw new BizException(Constants.SYSTEM_MSG_MOBILE_NUMBER_UNBOUND.getCode().toString()
                    , Constants.SYSTEM_MSG_MOBILE_NUMBER_UNBOUND.getName());
        } else if (accounts.size() > 1) {
            // 该手机号被多个账号注册
            throw new BizException(Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND.getCode().toString()
                    , Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND.getName());
        }
        return accounts.get(0);
    }

    /**
     * 检查修改的密码的数据是否符合业务规范
     *
     * @param vo 要修改的数据
     * @return
     */
    @Override
    public Account checkUpPwdData(FirstLoginUpdateVO vo, SmsSendBizType smsSendBizType,
                                  String smsSendRequestNo) throws BizException {
        RequestContext rq = ContextHolder.get();
        Long accountId = vo.getAccountId();
        Long mobile = vo.getMobile();
        if (Objects.isNull(mobile)) {
            // 手机号码为空
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString(),
                    Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getName());
        }
        Account account = null;
        if (Objects.nonNull(accountId)) {
            account = this.selectById(accountId);
            if (account == null) {
                // 账号不存在
                throw new BizException(Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST.getCode().toString()
                        , Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST.getName());
            } else if (StringUtils.isNotBlank(account.getMobile()) && !mobile.toString().equals(account.getMobile())) {
                //与账户绑定的手机号不符
                throw new BizException(Constants.SYSTEM_MSG_MOBILE_NUMBER_UNBOUND.getCode().toString()
                        , Constants.SYSTEM_MSG_MOBILE_NUMBER_UNBOUND.getName());
            }
        } else {
            if (StringUtils.equals(SmsSendBizType.FIRST_LOGIN.getCode(), smsSendBizType.getCode())) {
                // 账号不存在
                throw new BizException(Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST.getCode().toString()
                        , Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST.getName());
            }
            // 按手机号取出用户
            Account isExtisMobile = new Account();
            isExtisMobile.setMobile(mobile.toString());
            isExtisMobile.setCompanyId(rq.getCompanyId());
            account = this.selectOne(QueryUtil.condition(isExtisMobile));
            if (account == null) {
                //手机号未注册
                throw new BizException(Constants.SYSTEM_MSG_MOBILE_NUMBER_NOT_REGISTERED.getCode().toString()
                        , Constants.SYSTEM_MSG_MOBILE_NUMBER_NOT_REGISTERED.getName());
            }
        }
        // 不是手机号登陆时，都要验证密码是否正确
        if (!StringUtils.equals(SmsSendBizType.MOBILE_LOGIN.getCode(), smsSendBizType.getCode())) {
            // 密码校验
            String password = StringUtils.trimToEmpty(vo.getPassword());
            String confirmPassword = vo.getConfirmPassword();
            if (StringUtils.EMPTY.equals(password)) {
                // 密码为空
                throw new BizException(Constants.SYSTEM_MSG_PWD_EMPTY.getCode().toString()
                        , Constants.SYSTEM_MSG_PWD_EMPTY.getName());
            } else if (!StringUtils.equals(password, confirmPassword)) {
                // 确认密码不一致
                throw new BizException(Constants.SYSTEM_MSG_CONFIRM_PWD_NOT_CORRECT.getCode().toString()
                        , Constants.SYSTEM_MSG_CONFIRM_PWD_NOT_CORRECT.getName());
            } else if (!CheckPassword.checkPasswordRule(password, account.getName())) {
                // 新密码校验规则
                throw new BizException(Constants.NON_COMPLIANT_PASSWORD.getCode().toString(), Constants.NON_COMPLIANT_PASSWORD.getName());
            }
            // 密码是否存在
            if (ShaEncrypt.comparePassword(password, account.getPassword())) {
                throw new BizException(Constants.SYSTEM_MSG_PWD_EXITS.getCode().toString()
                        , Constants.SYSTEM_MSG_PWD_EXITS.getName());
            }
        }

        // 短信验证码校验
        String verifyCode = StringUtils.trimToEmpty(vo.getSmsVerifyCode());

        checkVerifyCode(smsSendBizType, mobile, verifyCode, smsSendRequestNo);

        return account;
    }

    /**
     * 获取待入职的员工
     *
     * @param userName
     * @param companyId
     * @param siteId
     * @return
     */
    @Override
    public List<OutsideUserVO> getRcUsers(String userName, Long companyId, String siteId) {
        return this.baseMapper.getRcUsers(userName, companyId, siteId);
    }

    /**
     * 获取企业下对接的全部启用用户信息
     *
     * @param companyId
     * @param enable
     * @return
     */
    @Override
    public List<OutsideUserVO> getCompanyOutsideUsers(Long companyId, Integer enable) {
        return this.baseMapper.getCompanyOutsideUsers(companyId, enable);
    }

    /**
     * 检查手机验证码是否正确
     *
     * @param smsSendBizType 发送短信业务类型
     * @param mobile         手机号
     * @param verifyCode     验证码
     */
    @Override
    public void checkVerifyCode(SmsSendBizType smsSendBizType, Long mobile,
                                String verifyCode, String extend) throws BizException {
        if (StringUtils.EMPTY.equals(verifyCode)) {
            throw new BizException(Constants.SYSTEM_MSG_CODE_EMPTY.getCode().toString()
                    , Constants.SYSTEM_MSG_CODE_EMPTY.getName());
        }
        if (StringUtils.isBlank(extend)) {
            logger.error("短信验证码发送成功后返回的业务号传参为空,具体业务：", smsSendBizType.getCode());
            throw new BizException(Constants.SYSTEM_MSG_EXTENT_EMPTY.getCode().toString()
                    , Constants.SYSTEM_MSG_EXTENT_EMPTY.getName());
        }
        logger.info("验证短信验证码参数：mobile={},verifyCode={},extend=" + extend, mobile, verifyCode);
        // 根据手机和短信验证码有效时间查询发送短信的记录
        EntityWrapper<SmsSendRecord> ewSr = QueryUtil.condition(new SmsSendRecord());
        ewSr.eq("phone_num", mobile);
        ewSr.eq("send_type", SmsSendMode.SIMPLE.getCode());// 单次发送
        ewSr.eq("biz_type", smsSendBizType.getCode());
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.SECOND, SECOND);//前一分钟
        ewSr.gt("create_date", calendar.getTime());
        ewSr.orderBy("create_date", false);
        Page<SmsSendRecord> page = new Page<>(1, 1);
        Page<SmsSendRecord> recordPage = smsSendRecordService.selectPage(page, ewSr);
        //PageUtil.split(recordPage); // 分页信息和数据分离
        logger.info("手机号{}查询出来的短信发送记录={}", mobile, JSON.toJSONString(recordPage));
        if (recordPage == null) {
            // 验证码已过期
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                    , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
        }
        List<SmsSendRecord> records = recordPage.getRecords();
        if (CollectionUtils.isEmpty(records)) {
            // 验证码已过期
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                    , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
        }
        SmsSendRecord obj = null;
        for (SmsSendRecord item : records) {
            if (extend.equals(item.getExtend())) {
                obj = item;
                break;
            }
        }
        if (obj == null) {
            // 验证码已过期
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                    , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
        } else {
            Map mapType = JSON.parseObject(obj.getTemplateParam(), Map.class);
            if (!StringUtils.equals(verifyCode, mapType.get("code").toString())) {
                // 验证码错误
                throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString()
                        , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getName());
            }
        }
   /*     if(StringUtils.trimToEmpty(extend).equals(StringUtils.EMPTY)){
            SmsSendRecord sendRecord = records.get(0);
            Map mapType = JSON.parseObject(sendRecord.getTemplateParam(),Map.class);
            if(!StringUtils.equals(verifyCode,mapType.get("code").toString())){
                // 验证码错误
                throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString()
                        ,Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getName());
            }
        }else{
            SmsSendRecord obj = null;
            for(SmsSendRecord item : records){
                if(extend.equals(item.getExtend())){
                    obj = item;
                    break;
                }
            }
            if(obj == null){
                // 验证码已过期
                throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                        ,Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
            }else{
                Map mapType = JSON.parseObject(obj.getTemplateParam(),Map.class);
                if(!StringUtils.equals(verifyCode,mapType.get("code").toString())){
                    // 验证码错误
                    throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString()
                            ,Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getName());
                }
            }
        }*/

    }

    /**
     * 新增账号
     *
     * @param account
     * @return
     */
    @Override
    public Long add(Account account) {
        logger.info("新增账号{}", account);

        if (!RegexUtil.checkAccountPassword(account.getPassword().trim())) {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.PASSWORD_FORMAT_ERROR);
        }
        //1.判断账号名是否重复(没有全局重复的账号)
        if (StringUtils.isNotEmpty(account.getName())) {
            if (accountMapper.countExistAccount(0L, account.getCompanyId(), account.getName()) > 0) {
                throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "用户名已存在");
            }
        }
        if (null != account.getMobile() && StringUtils.isNotEmpty(account.getMobile())) {
            if (accountMapper.countExistMobile(0L, account.getCompanyId(), account.getMobile()) > 0) {
                throw new BizException(ReturnCode.MOBILE_EXIST.getCode(), "手机号码已经存在系统中");
            }
        }
        //检查worknum是否存在
        if (StringUtils.isNotEmpty(account.getWorkNum())) {
            if (accountMapper.countExistWorknum(0L, account.getCompanyId(), account.getWorkNum()) > 0) {
                throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "工号已存在");
            }
        }
        //2.判断账号过期类型
        if (null == account.getExpiredType() || "1".equals(account.getExpiredType())) {//长期有效，任何时间不限制
            account.setExpiredTime(null);
            account.setStartTime(null);
            account.setEndTime(null);
            account.setValidDays(null);
        } else if ("2".equals(account.getExpiredType())) {//周期有效
            if (null == account.getStartTime() || null == account.getEndTime()) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
        } else {//天数内有效
            if (null != account.getValidDays()) {
                Calendar cal = Calendar.getInstance();
                cal.add(Calendar.DATE, account.getValidDays());//根据有效天数计算账号过期时间
                account.setExpiredTime(cal.getTime());
            } else {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
        }
        //3.密码加密
        account.setPassword(ShaEncrypt.encryptNewPassword(account.getPassword()));
        //4.生成账号id
        Long accountId = idGenerator.generate();
        account.setId(accountId);
        account.setName(account.getName().trim().toLowerCase());
        //5.插入账号信息
        if (this.insert(account)) {
            if(account.getOrgId()!=null){
                RequestContext context = ContextHolder.get();
                AuthzAccountRole accountRole = new AuthzAccountRole();
                accountRole.setAccountId(accountId);
                accountRole.setRoleId(account.getOrgId());
                accountRole.setSiteId(context.getSiteId());
                accountRole.setCreateById(context.getAccountId());
                accountRole.setCreateByName(context.getAccountName());
                accountRole.setCreateTime(new Date());
                accountRoleMapper.insert(accountRole);
            }
            return accountId;
        } else {
            throw new BizException(ReturnCode.SAVE_FAIL.getCode(), ReturnCode.SAVE_FAIL.getMsg());
        }
    }

    /**
     * 更新密码
     *
     * @param id
     * @param password
     * @return
     */
    @Override
    public Boolean updatePassword(Long id, String password) {
        logger.info("账号{}进行更新密码操作", id);
        Account account = new Account();
        account.setId(id);
        account.setPassword(ShaEncrypt.encryptNewPassword(password));
        if (updateById(account)) {
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }

    }

    /**
     * 更新账号
     *
     * @param account
     * @return
     */
    @Override
    public Boolean update(Account account) {
        String remarkFirst = account.getRemarkFirst();
        logger.info("remarkFirst的值是：" + remarkFirst);
        if (StringUtils.isNotEmpty(remarkFirst)) {
            if (!RegexUtil.isSuccessRemark(remarkFirst.trim())) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_REQUIRED);
            }
            if ((remarkFirst.trim()).length() > 50) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_LENGTH);
            }
        }

        String remarkSecond = account.getRemarkSecond();
        if (StringUtils.isNotEmpty(remarkSecond)) {
            if (!RegexUtil.isSuccessRemark(remarkSecond.trim())) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_REQUIRED);
            }
            if ((remarkSecond.trim()).length() > 50) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_LENGTH);
            }
        }

        String remarkThird = account.getRemarkThird();
        if (StringUtils.isNotEmpty(remarkThird)) {
            if (!RegexUtil.isSuccessRemark(remarkThird.trim())) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_REQUIRED);
            }
            if ((remarkThird.trim()).length() > 50) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ImpAccountError.REMARK_LENGTH);
            }
        }


        account.setCompanyId(ContextHolder.get().getCompanyId());
        if (null != account.getName()) {
            if (accountMapper.countExistAccount(account.getId(), account.getCompanyId(), account.getName()) > 0) {
                throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "用户名已存在");
            }
        }
        if (account.getMobile() != null && StringUtils.isNotEmpty(account.getMobile())) {
            int count = accountMapper.countExistMobile(account.getId(), account.getCompanyId(), account.getMobile().trim());
            logger.info("数量：" + count);

            if (count > 0) {
                throw new BizException(ReturnCode.MOBILE_EXIST.getCode(), "手机号码已经存在系统中");
            }

        }
        if (null != account.getWorkNum() && StringUtils.isNotEmpty(account.getWorkNum())) {
            //检查worknum是否存在
            if (accountMapper.countExistWorknum(account.getId(), account.getCompanyId(), account.getWorkNum()) > 1) {
                throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "工号已存在");
            }
        }
        if (null != account.getExpiredType() && account.getExpiredType().compareTo(Integer.valueOf(3)) == 0) {//周期有效
            if (null != account.getValidDays()) {
                Calendar cal = Calendar.getInstance();
                cal.add(Calendar.DATE, account.getValidDays());//根据有效天数计算账号过期时间
                account.setExpiredTime(cal.getTime());
            } else {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
        }
        logger.info("账号{}进行账号更新操作", account.getId());
        if (updateById(account)) {
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 根据账号名和公司查找账号
     *
     * @param companyId
     * @param accountName
     * @return
     */
    @Override
    public Account find(Long companyId, String accountName) {
        logger.info("查询公司{}账号名为{}的账号信息", companyId, accountName);
        Account condition = new Account();
        EntityWrapper<Account> ew = QueryUtil.condition(condition);
        ew.where("company_id = {0}", companyId);
        ew.eq("name", accountName);
        return selectOne(ew);
    }

    /**
     * 查询账号列表
     *
     * @param account
     * @return
     */
    @Override
    public Page<Account> list(Account account, Page<Account> page) {
        logger.info("查询账号列表条件：{}", account);
        //默认按创建时间排序
        page.setOrderByField(OrderField.CREATETIME.getCode());
        page.setAsc(false);
        //判断是否按名称模糊查询
        String name = account.getName();
        if (StringUtils.isNotEmpty(name)) {
            account.setName(null);
        }
        //获取部门的子部门
        List<Long> orgIds = authorityService.getChildOrgIds(account.getOrgId(), account.getCompanyId());
        account.setOrgId(null);
        Wrapper<Account> wrapper = QueryUtil.condition(account);
        wrapper.in("org_id", orgIds);
        if (StringUtils.isNotEmpty(name)) {
            wrapper.andNew().like("name", name).or().like("full_name", name).or().like("work_num", name);
        }

        return this.selectPage(page, wrapper);
    }

    @Override
    public Page<Account> managerList(AccountPageVO accountPageVO) {
        Page<Account> accountPage = new Page<>(accountPageVO.getPageNo(), accountPageVO.getPageSize());
        logger.info("查询账号列表条件：{}", accountPageVO);
        RowBounds rowBounds = new RowBounds(accountPage.getOffset(),accountPage.getSize());
        //判断是否按名称模糊查询
        List<Account> accounts = accountMapper.selectManagerList(ContextHolder.get().getSiteId(),accountPageVO.getName(), rowBounds);
        logger.info("查询结果：{}", accounts);
        Integer count = accountMapper.selectManagerCount(ContextHolder.get().getSiteId(),accountPageVO.getName());
        logger.info("查询结果：{}", count);
        accountPage.setRecords(accounts);
        logger.info("查询结果分页的结果：{}", accountPage);
        accountPage.setTotal(count);
        return accountPage;
    }

    /**
     * 查找账号角色列表
     *
     * @param accountId
     * @return
     */
    @Override
    public List<AuthzRole> findRoles(Long accountId) {
        logger.info("查询账号{}的角色列表", accountId);
        AuthzAccountRole accountRole = new AuthzAccountRole();
        accountRole.setAccountId(accountId);
        List<AuthzAccountRole> accountRoles = accountRoleMapper.selectList(QueryUtil.condition(accountRole));
        List<AuthzRole> roles = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(accountRoles)) {
            for (AuthzAccountRole accountRole1 : accountRoles) {
                roles.add(roleMapper.selectById(accountRole1.getRoleId()));
            }
        }
        return roles;
    }

    /**
     * 禁止账号
     *
     * @param log
     * @return
     */
    @Override
    public Boolean close(AccountEnableLog log) {
        logger.info("禁止账号{}", log);
        RequestContext context = ContextHolder.get();
        Account condition = new Account();
        condition.setId(log.getAccountId());
        condition.setEnabled(false);
        if (updateById(condition)) {

            //停用微信端
            TrAccountUserinfoVo trAccountUserinfo = new TrAccountUserinfoVo();
            trAccountUserinfo.setSiteId(context.getSiteId());
            trAccountUserinfo.setAccountId(log.getAccountId());
            trAccountUserinfo.setIsDeleted(2);
            Boolean updateResult = weiXinClient.updateTrAccountUserInfo(trAccountUserinfo);
            logger.info("停用结果：" + updateResult);
            //插入日志
            log.setId(idGenerator.generate());
            log.setType(2);
            if (logMapper.insert(log) < 1) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
            }
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
        return true;
    }

    /**
     * 开通账号
     *
     * @param log
     * @return
     */
    @Override
    public Boolean open(AccountEnableLog log) {
        logger.info("开通账号{}", log);
        Account account = this.baseMapper.selectById(log.getAccountId());
        String mobile = account.getMobile();

        AccountVO user = this.findUser(account.getName(), account.getCompanyId());
        if (user != null) {
            throw new BizException(String.valueOf(Constants.SYSTEM_MSG_ACCOUNT_EXIST.getCode()), Constants.SYSTEM_MSG_ACCOUNT_EXIST.getName());
        }
        List<String> mobiles = this.baseMapper.selectMobilesExceptAccountId(account.getCompanyId(), log.getAccountId());
        if (CollectionUtils.isNotEmpty(mobiles)) {
            if (mobiles.contains(mobile)) {
                throw new BizException(ReturnCode.MOBILE_EXIST.getCode(), ReturnCode.MOBILE_EXIST.getMsg());
            } else {
                Account condition = new Account();
                condition.setId(log.getAccountId());
                condition.setEnabled(true);
                if (updateById(condition)) {
                    //插入日志
                    log.setId(idGenerator.generate());
                    log.setType(1);
                    if (logMapper.insert(log) < 1) {
                        throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
                    }
                } else {
                    throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
                }
            }
        }
        return true;
    }


    @Override
    public List<Account> fuzzySearchByName(String name, Long companyId) {
        EntityWrapper<Account> wrapper = QueryUtil.condition(new Account());
        wrapper.where("company_id={0}", companyId);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(name)) {
            wrapper.and().like("name", name).or().like("full_name", name);
        }
        return this.selectList(wrapper);
    }

    /**
     * 账号名重复检测
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    @Override
    public Boolean nameExists(Long id, Long companyId, String name) {
        logger.info("账号名重复检测：账号名{}", name);
        if (accountMapper.countExistAccount(id, companyId, name) > 0) {
            throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "用户名已存在");
        } else {
            return true;
        }
    }

    @Override
    public List<Account> getAccountByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<>();
        }
        List<Account> accounts = accountMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(accounts)) {
            List<Long> orgs = accounts.stream().map(item -> item.getOrgId()).
                    collect(Collectors.toList());
            List<Organization> orgsList = orgService.selectBatchIds(orgs);
            if (CollectionUtils.isNotEmpty(orgsList)) {
                Map<Long, String> mapData = orgsList.stream().
                        collect(Collectors.toMap(key -> key.getId(), val -> val.getName()));
                for (Account obj : accounts) {
                    if (mapData.containsKey(obj.getOrgId())) {
                        obj.setOrgName(mapData.get(obj.getOrgId()));
                    }
                }
            }
        }


        return accounts;
    }

    @Override
    public List<Account> getAccountByOrgName(String name, Long companyId) {
        List<Organization> orgPs = orgService.fuzzySearchByName(name, companyId);
        //取父部门下所有的子部门和本部门
        List<Organization> orgs = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(orgPs)) {
            for (Organization orgP : orgPs) {
                orgs.addAll(orgService.listChildren(orgP.getId()));
            }
        }
        //取部门下所有的员工
        List<Account> accounts = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(orgs)) {
            for (Organization org : orgPs) {
                Account condition = new Account();
                condition.setOrgId(org.getId());
                condition.setEnabled(true);
                accounts.addAll(this.selectList(QueryUtil.condition(condition)));
            }
        }
        return accounts;
    }

    @Override
    public Account get(Long id) {
        Account account = this.selectById(id);
        if (null != account) {
            accountAddtional(account);
        } else {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
        return account;
    }

    /**
     * 获取账号信息
     *
     * @param id
     * @return
     */
    @Override
    public Account getCard(Long id) {
        Account account = this.selectById(id);
        if (null != account) {
            accountAddtional(account);
        }
        return account;
    }

    @Override
    public void batchUpdateOrg(List<Long> accountIds, Long orgId) {
        if (CollectionUtils.isEmpty(accountIds)) {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
        Account account = new Account();
        account.setOrgId(orgId);
        Wrapper<Account> wrapper = QueryUtil.condition(new Account());
        wrapper.in("id", accountIds);
        wrapper.and("org_id", orgId);
        if (accountMapper.update(account, wrapper) < 1) {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    @Override
    public void batchDeleteWechat(List<Long> accountIds) {
        if (CollectionUtils.isEmpty(accountIds)) {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
        Account account = new Account();
        account.setWechat("");
        Wrapper<Account> wrapper = QueryUtil.condition(new Account());
        wrapper.in("id", accountIds);
        if (!this.update(account, wrapper)) {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    @Override
    public void batchDisable(List<Long> accountIds) {
        if (CollectionUtils.isNotEmpty(accountIds)) {
            for (Long accountId : accountIds) {
                AccountEnableLog log = new AccountEnableLog();
                log.setAccountId(accountId);
                log.setId(idGenerator.generate());
                log.setType(2);
                log.setReason(AccountDisableReason.QT.getName());
                if (logMapper.insert(log) < 1) {
                    throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
                }
            }
            Account account = new Account();
            account.setEnabled(false);
            Wrapper<Account> wrapper = QueryUtil.condition(new Account());
            wrapper.in("id", accountIds);
            if (!this.update(account, wrapper)) {
                throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
            }
        } else {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
    }

    /**
     * 根据企业id和组织id查询组织的下级组织和当前组织下的用户
     *
     * @param cid
     * @param orgId
     * @param siteId
     * @param queryStr 查询字段
     * @param type     1:组织和用户；2：用户组
     * @return
     */
    @Override
    public List<OrgAccountVO> selectOrgAndAccount(Long cid, Long orgId, Long siteId, String queryStr, int type) {
        if (type == 1) {
            return accountMapper.selectOrgAndAccount(cid, orgId, queryStr);
        } else if (type == 2) {
            return accountMapper.selectAccount(cid, siteId, queryStr);
        } else if (type == 3) {
            return accountMapper.selectUserGrouop(cid, siteId, queryStr);
        }
        return null;
    }

    @Override
    public Integer getUserCount(List<Long> orgIds, Long companyId) {
        if (orgIds == null || orgIds.isEmpty()) {
            return 0;
        }
        List<Long> allordIds = new ArrayList<Long>();
        for (Long orgId : orgIds) {
            allordIds.addAll(authorityService.getChildOrgIds(orgId, companyId));
        }

        if (CollectionUtils.isEmpty(allordIds)) {
            return 0;
        }
        Account account = new Account();
        account.setEnabled(true);
        Wrapper<Account> wrapper = QueryUtil.condition(account);
        wrapper.in("org_id", allordIds);
        return this.selectCount(wrapper);
    }

    @Override
    public List<Account> selectByOrgId(Long orgId, Long companyId) {
        // List<Long> orgIds = authorityService.getChildOrgIds(orgId, companyId);
        // Account account = new Account();
        // account.setEnabled(true);
        // Wrapper<Account> wrapper = QueryUtil.condition(account);
        // wrapper.in("org_id", orgIds);
        // return this.selectList(wrapper);
        if (orgId == null) {
            return new ArrayList<>();
        }
        List<Long> orgIds = authorityService.getChildOrgIds(orgId, companyId);
        if (CollectionUtils.isEmpty(orgIds)) {
            return new ArrayList<>();
        }
        Account account = new Account();
        account.setEnabled(true);
        Wrapper<Account> wrapper = QueryUtil.condition(account);
        wrapper.in("org_id", orgIds);
        return this.selectList(wrapper);
    }

    @Override
    public List<Account> selectByGroupId(Long groupId, Long companyId) {
        List<Account> accounts = new ArrayList<>();
        AuthzGroupMember condition = new AuthzGroupMember();
        condition.setGroupId(groupId);
        condition.setDeleted(0);
        List<AuthzGroupMember> members = memberMapper.selectList(QueryUtil.condition(condition));
        if (CollectionUtils.isNotEmpty(members)) {
            List<Long> accountIds = new ArrayList<>();
            for (AuthzGroupMember member : members) {
                Long memberId = member.getMemberId();
                if (MemberType.USER.getCode().intValue() == member.getType().intValue()) {//用户
                    accountIds.add(memberId);
                } else if (MemberType.ORG.getCode().intValue() == member.getType().intValue()) {//部门
                    accounts.addAll(this.selectByOrgId(memberId, companyId));
                } else {
                    //TODO 用户组暂时还不能包含用户组
                }
            }
            accounts.addAll(this.selectBatchIds(accountIds));
        }
        return accounts;
    }

    @Override
    public List<Account> selectBySiteId(Long siteId) {
        Site site = siteMapper.selectById(siteId);
        logger.info("************************根据站点id={},查询出站点信息={}", siteId, JSON.toJSONString(site));
        // 如果是默认站点，查询企业的所有人员
        if (site.getType() != null && AuthzConstant.SITE_TYPE_DEFAULT.compareTo(site.getType()) == 0) {
            logger.info("*******************************************站点为默认站点****************");
            Account accountEW = new Account();
            accountEW.setEnabled(Boolean.TRUE);
            accountEW.setCompanyId(site.getCompanyId());
            EntityWrapper<Account> ew = new EntityWrapper<>(accountEW);
            return accountMapper.selectList(ew);
        }
        // 如果是业务站点（关联管辖区）
        else {
            logger.info("*******************************************站点为非默认站点****************");
            // 先查出管辖区 和 人员或者部门的关联
            Long userGroupId = site.getUserGroupId();
            AuthzGroupMember groupMemberEW = new AuthzGroupMember();
            groupMemberEW.setGroupId(userGroupId);
            groupMemberEW.setDeleted(0);
            EntityWrapper<AuthzGroupMember> ew = new EntityWrapper(groupMemberEW);
            List<AuthzGroupMember> groupMembers = groupMemberMapper.selectList(ew);
            logger.info("*******************************************站点为非默认站点，查询出管辖区的范围信息={}****************", JSON.toJSONString(groupMembers));
            if (!CollectionUtils.isEmpty(groupMembers)) {
                List<Long> accountIds = new ArrayList<>();
                List<Long> orgIds = new ArrayList<>();
                Set<Account> set = new HashSet<>();
                for (AuthzGroupMember gm : groupMembers) {
                    // 如果是人员
                    if (gm.getType().equals(AuthzConstant.GROUP_MEMBER_TYPE_ACCOUNT)) {
                        accountIds.add(gm.getMemberId());
                    }
                    // 如果是部门
                    if (gm.getType().equals(AuthzConstant.GROUP_MEMBER_TYPE_ORG)) {
                        orgIds.add(gm.getMemberId());
                    }
                }
//                // 查询部门下的人
//                if (!CollectionUtils.isEmpty(orgIds)) {
//                    Account accountEW = new Account();
//                    accountEW.setCompanyId(site.getCompanyId());
//                    accountEW.setEnabled(Boolean.TRUE);
//                    EntityWrapper<Account> accountEntityWrapper = new EntityWrapper<>(accountEW);
//                    accountEntityWrapper.in("org_id", orgIds);
//                    list.addAll(accountMapper.selectList(accountEntityWrapper));
//                }
//                // 查询人员
//                if (!CollectionUtils.isEmpty(accountIds)) {
//                    Account accountEW = new Account();
//                    accountEW.setCompanyId(site.getCompanyId());
//                    accountEW.setEnabled(Boolean.TRUE);
//                    EntityWrapper<Account> accountEntityWrapper = new EntityWrapper<>(accountEW);
//                    accountEntityWrapper.in("id", accountIds);
//                    list.addAll(accountMapper.selectList(accountEntityWrapper));
//                }

                set = this.getList(site.getCompanyId(), orgIds, accountIds);
                List<Account> list = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(set)) {
                    list.addAll(set);
                    return list;
                }
            }
        }
        return null;
    }

    @Override
    public Boolean isAccessToSite(Long accountId, Long siteId) {
        boolean isContain = false;
        //获取站点信息
        Site site = siteMapper.selectById(siteId);
        //获取用户信息
        Account account = this.selectById(accountId);
        // 如果是默认站点
        if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
            //如果站点所属公司和用户所属公司不相等，则对站点无访问权
            return account.getCompanyId().longValue() == site.getCompanyId().longValue();
        }
        // 如果是业务站点
        else if (site.getType().equals(AuthzConstant.SITE_TYPE_SUB)) {
            // 先查询出管辖区id
            Long userGroupId = site.getUserGroupId();
            // 管辖区是否关联了当前账号
            AuthzGroupMember groupMemberEW = new AuthzGroupMember();
            groupMemberEW.setGroupId(userGroupId);
            groupMemberEW.setType(AuthzConstant.GROUP_MEMBER_TYPE_ACCOUNT);
            groupMemberEW.setMemberId(accountId);
            groupMemberEW.setDeleted(0);
            EntityWrapper<AuthzGroupMember> ew = new EntityWrapper(groupMemberEW);
            List<AuthzGroupMember> groupMembers = groupMemberMapper.selectList(ew);
            if (groupMembers.size() > 0) {
                return true;
            }
            // 管辖区是否关联用户所在部门
            Long orgId = account.getOrgId();
            groupMemberEW.setType(AuthzConstant.GROUP_MEMBER_TYPE_ORG);
            groupMemberEW.setMemberId(orgId);
            ew.setEntity(groupMemberEW);
            groupMembers = groupMemberMapper.selectList(ew);
            return groupMembers.size() > 0;
        }
        return false;
    }

    @Override
    public Map<Long, UserInfoVO> selectUserInfo(UserInfoVO userInfoVO) {
        Map<Long, UserInfoVO> retMap = new HashMap<>();
        List<UserInfoVO> list = accountMapper.selectUserInfo(userInfoVO.getName(), userInfoVO.getFullName(),
                userInfoVO.getOrgName(), userInfoVO.getCompanyId(), userInfoVO.getOrgIs());
        if (CollectionUtils.isNotEmpty(list)) {
            for (UserInfoVO user : list) {
                retMap.put(user.getId(), user);
            }
        }
        return retMap;
    }
    @Autowired
    private AccountController accountController;
    @Override
    public List<Account> getUserInfoVOList(UserInfoVO userInfoVO) {
        logger.info("参数：{}",JSON.toJSON(userInfoVO));
        String name = userInfoVO.getName();
        ArrayList<Account> accountList = new ArrayList<>();
        if (StringUtils.isNotBlank(userInfoVO.getName())) {
            logger.info("== 开始查询==");
            Account account = new Account();
            account.setCompanyId(userInfoVO.getCompanyId());
            account.setEnabled(true);
            EntityWrapper<Account> condition = QueryUtil.condition(account);
            condition.like("full_name",userInfoVO.getName());
            condition.or().like("name",userInfoVO.getName());
            List<Account> accounts = this.selectList(condition);
            logger.info("返回的列表：{}",accounts);
            if (CollectionUtils.isNotEmpty(accounts)) {
                accountList.addAll(accounts);
            }else {
                logger.info("getUserInfoVOList根据name= {} ,查询到用户数量为0;",name);
                return new ArrayList<>();
            }
        }
        logger.info("列表1：{}",accountList.size());
        //定义一个用户和部门用户查询的交集
        List<Account> aList = new ArrayList<>();
        if (StringUtils.isNotBlank(userInfoVO.getOrgName())){
            Organization organization = new Organization();
            organization.setCompanyId(userInfoVO.getCompanyId());
            EntityWrapper<Organization> condition = QueryUtil.condition(organization);
            condition.like("name",userInfoVO.getOrgName());
            List<Organization> organizations = orgService.selectList(condition);
            logger.info("获取组织列表：{}",organizations);
            for (Organization o : organizations) {
                List<Account> accountListByOrgId =
                        accountController.findAccountListByOrgId(userInfoVO.getCompanyId(), o.getId(), 1, Integer.MAX_VALUE);
               logger.info("返回的用户列表：{}",accountListByOrgId);
                if (CollectionUtils.isNotEmpty(accountListByOrgId)) {
                    if (StringUtils.isNotBlank(userInfoVO.getName())){
                        //求部门和用户的查询交集
                        List<Account> collect = accountListByOrgId.stream().filter(
                                orgAccount ->
                                        accountList.stream().anyMatch(account -> account.getId().equals(orgAccount.getId())))
                                .collect(Collectors.toList());
                        if (!collect.isEmpty()){
                            aList.addAll(collect);
                        }
                    }
                    //accountList.addAll(accountListByOrgId);
                }
            }
            logger.info("列表：{}",JSON.toJSON(accountList));
        }
        if (StringUtils.isNotBlank(userInfoVO.getOrgName()) && StringUtils.isNotBlank(userInfoVO.getName())){
            List<Account> newAccountList = aList.stream().distinct().collect(Collectors.toList());
            logger.info("组织和用户查询去重后的列表：{}",JSON.toJSON(newAccountList.size()));
            return newAccountList;
        }
        logger.info("去重前的列表：{}",JSON.toJSON(accountList.size()));
        List<Account> newAccountList = accountList.stream().distinct().collect(Collectors.toList());
        logger.info("去重后的列表：{}",JSON.toJSON(newAccountList.size()));
        return newAccountList;
    }

    @Override
    public List<Long> selectAccountIdList(List<Long> accountIdList) {
        return accountMapper.selectAccountIdList(accountIdList);
    }

    /**
     * 根据企业id查询组织列表
     *
     * @param companyId
     * @return
     */
    @Override
    public List<TreeObjectVO> selectOrgList(long companyId) {
        List<TreeObjectVO> trees = organizationMapper.selectCompanyOrgs(companyId);
        // 如果缓存没有，直接从数据库查询序列化放到缓存，过期为5分钟
        //redisCache.hset(CacheNamespace.REDIS_company_orgs,String.valueOf(companyId),JsonUtil.object2Json(trees),300);
        return trees;
    }

    @Override
    public Map<String, Object> findMemberInfo(List<RangeModel> models) {
        Map<String, Object> retMap = new HashMap<>();
        Long companyId = ContextHolder.get().getCompanyId();
        if (CollectionUtils.isNotEmpty(models)) {
            Set<Long> accountIds = new HashSet<>();
            for (RangeModel model : models) {
                if (model.getType().intValue() == MemberType.USER.getCode().intValue()) {
                    accountIds.add(model.getRelationId());
                } else if (model.getType().intValue() == MemberType.ORG.getCode().intValue()) {
                    List<Long> orgIds = authorityService.getChildOrgIds(model.getRelationId(), companyId);
                    Wrapper<Account> wrapper = QueryUtil.condition(new Account());
                    wrapper.in("org_id", orgIds);
                    List<Account> accounts = this.selectList(wrapper);
                    if (CollectionUtils.isNotEmpty(accounts)) {
                        for (Account account : accounts) {
                            accountIds.add(account.getId());
                        }
                    }
                } else if (model.getType().intValue() == MemberType.GROUP.getCode().intValue()) {
                    Map<String, List<Long>> idMap = groupService.getOrgIdAndAccountIdByGroupId(model.getRelationId());
                    accountIds.addAll(idMap.get("accountIds"));
                    if (CollectionUtils.isNotEmpty(idMap.get("orgIds"))) {
                        Wrapper<Account> wrapper = QueryUtil.condition(new Account());
                        wrapper.in("org_id", idMap.get("orgIds"));
                        List<Account> accounts = this.selectList(wrapper);
                        if (CollectionUtils.isNotEmpty(accounts)) {
                            for (Account account : accounts) {
                                accountIds.add(account.getId());
                            }
                        }
                    }
                } else {
                }
            }
            retMap.put("count", accountIds.size());
            retMap.put("accountIds", accountIds);
        }
        return retMap;
    }

    @Override
    public void updateRegistrationId(Account account) {
        if (!this.updateById(account)) {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), "更新app注册id失败");
        }
    }

    @Override
    public Page<Account> orgAccountListPageOther(Long userGroupId, String name, String mobile,
                                                 String workNum, String email,
                                                 Integer locked, Integer pageNo, Integer pageSize) {
        Page<Account> page = new Page<>(pageNo, pageSize);

        page.setRecords(accountMapper.orgAccountListPageOther(userGroupId, name, mobile, workNum, email,
                locked, new RowBounds(page.getOffset(), page.getLimit())));
        page.setTotal(accountMapper.orgAccountListPageOtherCount(userGroupId, name, mobile, workNum, email, locked));

        return page;
    }

    @Override
    public Page<Account> orgAccountListPage(Long companyId, List<RightLeftIndex> rightLeftIndices, String name, String mobile,Long orgId,
                                            String workNum, String fullName, String email,
                                            Integer enabled, Integer pageNo, Integer pageSize) {
        Page<Account> page = new Page<>(pageNo, pageSize);
        page.setRecords(accountMapper.orgAccountListPage(rightLeftIndices, name, mobile,orgId, workNum, fullName,
                email, enabled, companyId, new RowBounds(page.getOffset(), page.getLimit())));
        page.setTotal(accountMapper.orgAccountListPageCount(rightLeftIndices, name, mobile,orgId, workNum, fullName, email, enabled, companyId));

        return page;
    }
    @Override
    public Page<Account> orgAccountListById(Long companyId, List<RightLeftIndex> rightLeftIndices, String name, String mobile,Long orgId,
                                            String workNum, String fullName, String email,
                                            Integer enabled, Integer pageNo, Integer pageSize) {
        Page<Account> page = new Page<>(pageNo, pageSize);
        page.setRecords(accountMapper.orgAccountListPage(rightLeftIndices, name, mobile, orgId,workNum, fullName,
                email, enabled, companyId, new RowBounds(page.getOffset(), page.getLimit())));

        return page;
    }

    @Override
    public List<Account> listByNamesInManageRange(List<String> names, Boolean noRange,
                                                  List<RightLeftIndex> rightLeftIndices, List<Long> userGroupIds, Long companyId,Integer type) {
        if (noRange) {
            Account account = new Account();
            account.setCompanyId(companyId);
            if (type!=null&&type != 2) {
                account.setEnabled(Boolean.TRUE);
            }
            EntityWrapper<Account> ew = new EntityWrapper<>(account);

            if (CollectionUtils.isNotEmpty(names)) {
                for (String name : names) {
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty(name)) {
                        ew.or().like("name", name).or().like("full_name", name).or().like("work_num", name);
                    }
                }

                ew.orderBy("name", true);
            }
            return accountMapper.selectList(ew);
        }

        List<Account> temp = new ArrayList<>();

        if (!CollectionUtils.isEmpty(rightLeftIndices)) {
            List<Account> accounts = accountMapper.listByNamesInManageRangeOrg(names, rightLeftIndices, companyId);
            if (!CollectionUtils.isEmpty(accounts)) {
                temp.addAll(accounts);
            }
        }
        if (!CollectionUtils.isEmpty(userGroupIds)) {
            List<Account> accounts = accountMapper.listByNamesInManageRangeUserGroup(names, userGroupIds, companyId);
            if (!CollectionUtils.isEmpty(accounts)) {
                temp.addAll(accounts);
            }
        }
        // 去重
        Set<Account> result = new HashSet<>();
        for (Account a : temp) {
            result.add(a);
        }

        temp = new ArrayList<>();
        temp.addAll(result);
        return temp;
    }

    /**
     * 根据用户id集合查询用户信息
     *
     * @param ids
     * @return
     */
    @Override
    public List<AccountVO> idsGet(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return accountMapper.idsGet(ids);
    }

    @Override
    public Integer getSiteAccountNum(Long siteId, Long companyId) {
        Site site = siteMapper.selectById(siteId);
        Company company = companyMapper.selectById(companyId);

        Set<Long> ids = organizationService.getOrgIdsInSite(site.getId(), company.getCode(), site.getCode());

        EntityWrapper<Account> ew = QueryUtil.condition(new Account());
        ew.in("org_id", ids);
        return this.selectCount(ew);
        //return accountMapper.getSiteAccountNum(siteId, companyId);
    }

    @Override
    public List<Account> getSiteAccount(Long siteId, Long companyId) {
        Site site = siteMapper.selectById(siteId);
        Company company = companyMapper.selectById(companyId);

        Set<Long> ids = organizationService.getOrgIdsInSite(site.getId(), company.getCode(), site.getCode());

        EntityWrapper<Account> ew = QueryUtil.condition(new Account());
        ew.in("org_id", ids);
        return this.selectList(ew);
    }

    /**
     * 导入用户
     *
     * @param importModel
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<AccountImpModel> importAccount(ImportModel importModel, RequestContext context) {
        List<AccountImpModel> models = importModel.getData();
//        Long companyId = importModel.getCompanyId();
        // 获取企业的id
        Long companyId = context.getCompanyId();
        logger.info("当前用户的企业的companyId：" + companyId);
        // 获取当前企业的用户name 的列表
        List<String> names = accountMapper.selectNamesByCompanyId(companyId);

        logger.info("names size：" + names.size());
//        logger.info("names list：" + names);
        // 大写转小写
//        List<String> names = new ArrayList<>();

        List<String> newNames = new ArrayList<>();
//        List<String> tempCurrentList = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(nameList)) {
////            names.parallelStream().map(name->{
////                return name.toLowerCase();
////            }).collect(Collectors.toList());
//            for (String name : nameList) {
//                names.add(name);
//            }
////            tempCurrentList.addAll(names);
//        }

        logger.info("names lowCase：" + names.size());
        Long taskId = importModel.getTaskId();

        if (CollectionUtils.isNotEmpty(models)) {
            List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();

            // 根组织
            Organization rootOrg = new Organization();
            rootOrg.setParentId(0L);
            rootOrg.setDeleted(Boolean.valueOf(false));
            rootOrg.setCompanyId(context.getCompanyId());
            EntityWrapper<Organization> rootOrgEw = new EntityWrapper(rootOrg);
            rootOrgEw.like("code", AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX);
            rootOrg = rootOrg.selectOne(rootOrgEw);
            if (null == rootOrg) {
                failEvents.add(new TaskLogDetailEvent(taskId, "！！！查找根组织错误：未成功查询到根组织！！！"));
                // rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
                return models;
            }

            List<Account> accounts = new ArrayList<Account>();

            // 文件中的用户名集合
            List<String> accountNamesInFile = new ArrayList<String>();
            List<String> newAaccountNamesInFile = new ArrayList<>();

            // 初始化文件中的手机号集合
            List<String> accountMobileInFile = new ArrayList<String>();

            // 初始化组织id
            Long orgId = null;

            List<Map<String, Long>> tempList = new ArrayList<Map<String, Long>>();
            // 存放已添加的节点数据
            Map<String, Map<String, Long>> orgMap = new HashMap<String, Map<String, Long>>();
            Map<String, Long> childOrgMap = new HashMap<String, Long>();
            Map<Long, String> parentIdLayerMap = new HashMap<>();
            //判断是否有新节点产生
            boolean isNewNode = false;
            boolean clearFlag = false;

            Long parentId;
            List<Account> updateAccountList = new ArrayList<Account>();

            for (int j = 0; j < models.size(); j++) {
                parentId = rootOrg.getId();
                isNewNode = false;
                childOrgMap = new HashMap<String, Long>();

                AccountImpModel model = models.get(j);

                // add 2018-7-17 10:00:14
                String[] orgNameArray = model.getFullOrgName().trim().split("\\+");

                // 子组织名不能和跟组织相同 add 2019年4月2日
                if (orgNameArray.length > 0) {
                    int step = j + 2;
                    if (useArrayUtils(orgNameArray, rootOrg.getName())) {
                        model.setResult(ImpAccountError.ORGANIZATION_REPEAT);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + step + "行:" + ImpAccountError.ORGANIZATION_REPEAT));
                        continue;
                    }
                    orgNameArray = checkOrgImportCode(orgNameArray, rootOrg.getName().trim());
                    List<Organization> organizationList = new ArrayList<Organization>();
                    Date sysDate = new Date();

                    Organization midOrg = null;
                    String newOrgCode = null;
                    // 组织列表的新增
                    for (int k = 0; k < orgNameArray.length; k++) {
                        Long id = null;

                        if (!isNewNode && !orgMap.isEmpty()) {
                            if (orgMap.size() > 0 && orgMap.get(orgNameArray[0]) != null) {
                                parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                                if (parentId != null) {
                                    if (k == 0) {
                                        parentId = rootOrg.getId();
                                    } else {
                                        parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                                    }

                                    orgId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                                    if (k > 0) {
                                        if (k == 1) {
                                            logger.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                                    orgMap.get(orgNameArray[0]).get(orgNameArray[k] + k) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                                        } else {
                                            logger.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                                    orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k)) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                                        }

                                    }
                                    continue;
                                }
                            }
                        }
                        if (k == 0) {
                            parentId = rootOrg.getId();
                        } else {
                            parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                            logger.info("parentId:" + parentId);
                        }
                        midOrg = getOrg(orgNameArray[k], parentId);
                        if (midOrg != null) {
                            logger.info("已经存在导入组织的名称：" + k + "-层级-" + midOrg.getEnName());
                            logger.info("已经存在导入组织id：" + k + "-层级-" + midOrg.getId());
                            parentId = midOrg.getId();
                            orgId = parentId;
                            isNewNode = false;

                            if (k == 0) {
                                childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                                orgMap.put(orgNameArray[0], childOrgMap);
                                midOrg.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                                parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                            } else {
                                childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                                childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                                orgMap.put(orgNameArray[0], childOrgMap);
                                midOrg.setParentIdLayer(parentIdLayerMap.get(midOrg.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                                parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                            }
                            continue;
                        } else {
                            Organization organization = new Organization();
                            id = idGenerator.generate();
                            logger.info("公司id：" + context.getCompanyId());
                            organization.setCompanyId(context.getCompanyId());
                            // 生成组织编码
                            // 获取redis中的编码值编码
                            String orgCode = redisCache.get(context.getCompanyCode()) + "";
                            if (orgCode != null && !"".equals(orgCode) && !"null".equals(orgCode)) {
                                // 新的组织编码
                                newOrgCode = (Integer.valueOf(orgCode) + 1) + "";
                                // 放到缓存中
                                redisCache.set(context.getCompanyCode(), newOrgCode);
                            } else {
                                newOrgCode = "1";
                                redisCache.set(context.getCompanyCode(), newOrgCode);
                            }
                            String orgNum = "";
                            switch (newOrgCode.length()) {
                                case 1:
                                    orgNum = "000" + newOrgCode;
                                    break;
                                case 2:
                                    orgNum = "00" + newOrgCode;
                                    break;
                                case 3:
                                    orgNum = "0" + newOrgCode;
                                    break;
                                default:
                                    orgNum = newOrgCode;
                            }
                            organization.setCode(context.getCompanyCode() + orgNum);
                            organization.setId(id);
                            organization.setName(orgNameArray[k].trim());
                            // 设置 rootId
                            organization.setRootId(rootOrg.getId());
                            if (organization.getName().equals("理赔")) {
                                int uu = 0;
                                logger.info("理赔");
                            }
                            if (k == 0) {
                                organization.setParentId(rootOrg.getId());
                                organization.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                                parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                            } else {
                                if (k > 0) {
                                    parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                                    logger.info("父级parentId：" + parentId);
                                }
                                organization.setParentId(parentId);
                                organization.setParentIdLayer(parentIdLayerMap.get(organization.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                                parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                            }
                            organization.setLayer(k + 1);
                            organization.setCreateTime(sysDate);
                            organization.setCreateByName(context.getAccountName());
                            organization.setCompanyId(context.getCompanyId());
                            organizationList.add(organization);
                            parentId = id;
                            orgId = id;
                            logger.info("组织的id：" + orgId);

                        }
                        //有新节点产生，那么它下面的子节点全部是新增加
                        isNewNode = true;
                        if (k == 0) {
                            childOrgMap.put(getAllParentName(orgNameArray, k), id);
                            orgMap.put(orgNameArray[0], childOrgMap);
                        } else {
                            childOrgMap.put(getAllParentName(orgNameArray, k), id);
                            childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                            orgMap.put(orgNameArray[0], childOrgMap);
                        }
                        logger.info("添加新组织：" + orgNameArray[k] + "_" + k + ":" + id);
                    }

                    // 组织列表新增完成
                    if (organizationList != null && organizationList.size() > 0) {
                        // 批量新增组织
                        orgService.insertBatch(organizationList);
                        logger.info("organization add complete！");
                        clearFlag = true;
                    }
                } else {
                    //检查用组织不能为空
                    if (StringUtils.isEmpty(model.getFullOrgName().trim())) {
                        model.setResult(ImpAccountError.ORG_CODE_EMPTY);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + (j + 2) + "行:" + ImpAccountError.ORG_CODE_EMPTY));
                        continue;
                    }
                }
                // 获取用户名
                String name = model.getName().trim();
                logger.info("当前 current_name:" + name);

                String workNum = model.getWorknum();
                int i = j + 2;
                //检查用户名不能为空
                if (StringUtils.isEmpty(name)) {
                    model.setResult(ImpAccountError.NAME_EMPTY);
                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EMPTY));
                    continue;
                }
                // 转为小写
                name = name.toLowerCase();
                // 获取用户名密码
                String password = model.getPassword();
                // 获取操作栏位的信息
                String operation = model.getOperation();
                if (StringUtils.isEmpty(operation)) {
                    //检查密码不能为空
                    if (StringUtils.isEmpty(password)) {
                        model.setResult(ImpAccountError.PASSWORD_EMPTY);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_EMPTY));
                        continue;
                    }
                    //检查密码是否合法
                    if (!RegexUtil.checkAccountPassword(password.trim())) {
                        model.setResult(ImpAccountError.PASSWORD_FORMAT_ERROR);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_FORMAT_ERROR));
                        continue;
                    }
                }
                //检查名称是否合法
                if (StringUtils.isNotEmpty(name)) {
                    if (!RegexUtil.checkAccountName(name.trim())) {
                        model.setResult(ImpAccountError.NAME_FORMAT_ERROR);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_FORMAT_ERROR));
                        continue;
                    }
                }

                //检查手机是否合法
                String phone = model.getMobile();
                if (StringUtils.isNotEmpty(phone)) {
                    if (!RegexUtil.checkMobile(phone.trim())) {
                        model.setResult(ImpAccountError.PHONE_FORMAT_ERROR);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PHONE_FORMAT_ERROR));
                        continue;
                    }
                }
                //检查邮箱是否合法
                String email = model.getEmail();
                if (StringUtils.isNotEmpty(email.trim())) {
                    if (!RegexUtil.checkEmail(email.trim())) {
                        model.setResult(ImpAccountError.EMAIL_FORMAT_ERROR);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.EMAIL_FORMAT_ERROR));
                        continue;
                    }
                }
                //判断备注 add by ly 2019-4-4 11:28:18
                String remarkFirst = model.getRemarkFirst();
                logger.info("remarkFirst的值是：" + remarkFirst);
                if (StringUtils.isNotEmpty(remarkFirst)) {
                    if (!isLetterDigitOrChinese(remarkFirst.trim())) {
                        model.setResult(ImpAccountError.REMARK_REQUIRED);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                        continue;
                    }
                    if ((remarkFirst.trim()).length() > 20) {
                        model.setResult(ImpAccountError.REMARK_LENGTH);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                        continue;
                    }
                }

                String remarkSecond = model.getRemarkSecond();
                if (StringUtils.isNotEmpty(remarkSecond)) {
                    if (!isLetterDigitOrChinese(remarkSecond.trim())) {
                        model.setResult(ImpAccountError.REMARK_REQUIRED);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                        continue;
                    }
                    if ((remarkSecond.trim()).length() > 20) {
                        model.setResult(ImpAccountError.REMARK_LENGTH);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                        continue;
                    }
                }

                String remarkThird = model.getRemarkThird();
                if (StringUtils.isNotEmpty(remarkThird)) {
                    if (!isLetterDigitOrChinese(remarkThird.trim())) {
                        model.setResult(ImpAccountError.REMARK_REQUIRED);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                        continue;
                    }

                    if ((remarkThird.trim()).length() > 20) {
                        model.setResult(ImpAccountError.REMARK_LENGTH);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                        continue;
                    }
                }


                //检查微信是否合法
//                String wechat = model.getWechat();
//                if (StringUtils.isNotEmpty(wechat.trim())) {
//                    if (!RegexUtil.checkWechat(wechat)) {
//                        model.setResult(ImpAccountError.WECHAT_FORMAT_ERROR);
//                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.WECHAT_FORMAT_ERROR));
//                        continue;
//                    }
//                }

                //  判断导入用户 2019-2-28

                List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
                String newName = "";
                if (StringUtils.isEmpty(operation)) {

                    // 检查文件中是否有重名
                    if (accountNamesInFile.contains(name)) {
                        model.setResult(ImpAccountError.NAME_EXIST_IN_FILE);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST_IN_FILE));
                        continue;
                    }
                    accountNamesInFile.add(name);
                    //检查名称是否重复
                    // modified by shengchenglong，不区分大小写
                    if (names.contains(name)) {
                        model.setResult(ImpAccountError.NAME_EXIST);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST));
                        continue;
                    }
                    names.add(name);

                    // 新增用户
                    //检查手机号是否重复
                    if (StringUtils.isNotEmpty(phone)) {
                        if (accountMapper.countExistMobile(0L, context.getCompanyId(), phone.trim()) > 0) {
                            model.setResult(ImpAccountError.MOBILE_EXIST);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST));
                            continue;
                        }
                        mobileList.add(phone);
                    }

                } else {
                    if (AccountExportConditionConstant.UPDATE_NAME.equals(operation.trim())) {
                        if (!names.contains(name)) {
                            model.setResult(ImpAccountError.MODIFY_NAME_NOT_EXIST);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MODIFY_NAME_NOT_EXIST));
                            continue;
                        }
                        Account userInfo = new Account();
                        userInfo.setName(model.getName().trim());
                        userInfo.setCompanyId(companyId);
                        Account account = this.selectOne(QueryUtil.condition(userInfo));
                        logger.info("当前用户手机号：" + account.getMobile());

                        if (!StringUtils.isNotEmpty(account.getMobile())) {
                            if (StringUtils.isNotEmpty(phone)) {
                                if (!phone.equals(account.getMobile())) {
                                    if (mobileList.contains(phone)) {
                                        model.setResult(ImpAccountError.MOBILE_EXIST);
                                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST));
                                        continue;
                                    }
                                }
                            }
                        }

                        newName = model.getNewName().trim();

                        if (StringUtils.isNotEmpty(newName)) {
                            logger.info("当前的新名称：" + newName);
                            boolean flag = RegexUtil.checkAccountName(newName.trim());
                            logger.info("校验的结果：" + flag);
                            // 校验新用户名的格式
                            if (!RegexUtil.checkAccountName(newName.trim())) {
                                model.setResult(ImpAccountError.NEW_NAME_FORMAT_ERROR);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NEW_NAME_FORMAT_ERROR));
                                continue;
                            }

                            newName = newName.toLowerCase();
                            // 检查文件中是否有重名
                            if (newAaccountNamesInFile.contains(newName)) {
                                model.setResult(ImpAccountError.NEW_NAME_EXIST_IN_FILE);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NEW_NAME_EXIST_IN_FILE));
                                continue;
                            }
                            newAaccountNamesInFile.add(model.getNewName());

                            //检查名称是否和数据库中的名称重复
                            if (names.contains(model.getNewName())) {
                                model.setResult(ImpAccountError.NAME_EXIST);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST));
                                continue;
                            }
                            names.add(name);
                        }

                    }
                }

                // 判断文件中手机号是否重复
                if (StringUtils.isNotEmpty(phone)) {
                    if (accountMobileInFile.contains(phone)) {
                        model.setResult(ImpAccountError.MOBILE_EXIST_IN_FILE);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST_IN_FILE));
                        continue;
                    }
                }
                accountMobileInFile.add(phone);
                String fullName = model.getFullName();
                if (StringUtils.isNotEmpty(fullName)) {
                    if ((fullName.trim()).length() > 20) {
                        model.setResult(ImpAccountError.FULLNAME_LENGTH_LONG);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.FULLNAME_LENGTH_LONG));
                        continue;
                    }
                    mobileList.add(phone);
                }
                //查询账号过期类型
                Integer expiredType = 0;
                String validDate = model.getValidDate();
                Date startDate = null;
                Date endDate = null;
                Date expiredTime = null;
                Integer validDays = 0;
                try {
                    if (org.apache.commons.lang3.StringUtils.EMPTY.equals(org.apache.commons.lang3.StringUtils.trimToEmpty(validDate))) {
                        expiredType = 1;
                    } else {
                        if (validDate.indexOf("-") != -1) {
                            String[] dateArr = validDate.split("-");
                            if (dateArr.length < 2) {
                                model.setResult(ImpAccountError.VALIDDATE_FORMAT_ERROR);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.VALIDDATE_FORMAT_ERROR));
                                continue;
                            } else {
                                expiredType = 2;
                                startDate = DateUtil.parseShort(dateArr[0]);
                                endDate = DateUtil.parseShort(dateArr[1]);
                            }
                        } else {
                            expiredType = 3;
                            validDays = Integer.parseInt(validDate);
                            Calendar cal = Calendar.getInstance();
                            //根据有效天数计算账号过期时间
                            cal.add(Calendar.DATE, validDays);
                            expiredTime = cal.getTime();
                        }
                    }
                } catch (Exception e) {
                    model.setResult(ImpAccountError.VALIDDATE_FORMAT_ERROR);
                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.VALIDDATE_FORMAT_ERROR));
                    continue;
                }
                Account account = new Account();
                account.setId(idGenerator.generate());
                account.setName(name);
                account.setCompanyId(companyId);
                account.setEmail(email);
                account.setMobile(phone);
                account.setTelephone(phone);
//                account.setWechat(wechat);
                account.setWorkNum(workNum);
//                account.setPassword(ShaEncrypt.encryptNewPassword(password));
                account.setExpiredType(expiredType);
                account.setStartTime(startDate);
                account.setEndTime(endDate);
                account.setExpiredTime(expiredTime);
                account.setValidDays(validDays);
                account.setOrgId(orgId);
                logger.info("导入用户的用户组织id");
                account.setFullName(model.getFullName());
                account.setPosition(model.getPosition());
                account.setCreateById(importModel.getAccountId());
                account.setCreateByName(importModel.getAccountName());
                account.setCreateTime(new Date());
                // add by ly 2019-4-4 11:13:27
                account.setRemarkFirst(model.getRemarkFirst());
                account.setRemarkSecond(model.getRemarkSecond());
                account.setRemarkThird(model.getRemarkThird());

                // 判断导入用户还是新增用户
                logger.info("当前导入操作：" + operation.trim());
                if (StringUtils.isEmpty(operation)) {
                    // 新增用户
                    account.setPassword(ShaEncrypt.encryptNewPassword(password));
                    accounts.add(account);
                } else {
                    if (AccountExportConditionConstant.UPDATE_NAME.equals(operation.trim())) {

                        try {
                            // 获取用户信息
                            Account updateAccount = new Account();
                            updateAccount.setName(name);
                            updateAccount.setCompanyId(companyId);
                            updateAccount = this.selectOne(QueryUtil.condition(updateAccount));

                            if (StringUtils.isNotEmpty(password)) {
                                //检查密码是否合法
                                if (!RegexUtil.checkAccountPassword(password.trim())) {
                                    model.setResult(ImpAccountError.PASSWORD_FORMAT_ERROR);
                                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_FORMAT_ERROR));
                                    continue;
                                }
                                account.setPassword(ShaEncrypt.encryptNewPassword(password));
                            }
                            logger.info("返回实体：" + updateAccount);
                            if (updateAccount != null) {
                                logger.info("用户id：" + updateAccount.getId());
                                account.setId(updateAccount.getId());
                                // 可修改用户的名 add 2019年7月25日11:28:26 by lingye
                                String new_name = StringUtils.isNotEmpty(newName) ? newName : name;
                                account.setName(new_name);
                            }
                            updateAccountList.add(account);
                        } catch (Exception e) {
                            logger.info("更新异常{}", e);
                        }
                    }
                }

            }
            if (CollectionUtils.isNotEmpty(accounts)) {
                if (!this.insertBatch(accounts)) {
                    throw new BizException(ReturnCode.SAVE_FAIL.getCode(), ReturnCode.SAVE_FAIL.getMsg());
                }
                clearFlag = true;
            }
            // 更新用户信息
            if (CollectionUtils.isNotEmpty(updateAccountList)) {

                if (!this.updateBatchById(updateAccountList)) {
                    throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
                }
                clearFlag = true;
            }


            if (clearFlag) {
                Company company = companyMapper.selectById(companyId);
                if (company!=null){
                    // 计算左右索引
                    organizationIndexService.addInitTask(companyId);
                }
            }
            //错误的信息发送给任务详情表
            if (CollectionUtils.isNotEmpty(failEvents)) {
               // rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
            }
            return models;
        } else {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
    }

    /**
     * 查询组织
     *
     * @param name
     * @param parentId
     * @return
     */
    public Organization getOrg(String name, Long parentId) {
        Organization org = new Organization();
        org.setName(name.trim());
        org.setParentId(parentId);
        org.setDeleted(false);
        return orgService.selectOne(QueryUtil.condition(org));
    }

    private void accountAddtional(Account account) {
        //取部门名称
        Organization org = orgService.selectById(account.getOrgId());
        account.setOrgName(org == null ? "" : org.getName());
        // 取部门全名
        //	account.setOrgFullName((String)orgService.getFullOrgByOrgId(null, account.getOrgId()).get("name"));
        // 取公司名称
        Company company = companyMapper.selectById(account.getCompanyId());
        account.setCompanyName(company == null ? "" : company.getName());
        account.setCompanyAddress(company.getAddress());

        AccountEnableLog log = new AccountEnableLog();
        log.setAccountId(account.getId());
        Wrapper<AccountEnableLog> wrapper = QueryUtil.condition(log);
        wrapper.orderBy("create_time", false);
        List<AccountEnableLog> logs = logMapper.selectList(wrapper);
        account.setLogs(logs);
    }

    /**
     * 获取当前节点的所有父亲节点
     *
     * @param orgNameArray
     * @param curIndex
     * @return
     */
    private String getAllParentName(String[] orgNameArray, int curIndex) {
        String name = "";
        for (int i = 0; i < curIndex + 1; i++) {
            name += orgNameArray[i];
        }
        return name + curIndex;
    }

    /**
     * 去除跟组织
     *
     * @param fullOrgName
     * @param rootName
     * @return
     */
    private String[] checkOrgImportCode(String[] fullOrgName, String rootName) {
        if (fullOrgName[0].equals(rootName)) {
            return Arrays.copyOfRange(fullOrgName, 1, fullOrgName.length);
        }
        return fullOrgName;
    }

    private List<List<String>> splitList(List<String> list, int offset) {
        if (offset > list.size()) {
            List<List<String>> result = new ArrayList<>(1);
            result.add(list);
            return result;
        }
        boolean lastOnce = false;
        int start = 0;
        int end;
        List<List<String>> result = new ArrayList<>();
        while (!lastOnce) {
            end = start + offset;
            if (end >= list.size()) {
                lastOnce = true;
                end = list.size();
            }
            result.add(list.subList(start, end));
            start = end;
        }
        return result;
    }

    /**
     * 判断图形验证码是否正确
     *
     * @param captchaKey 验证码请求前端生成的UUID
     * @param captchaVal 前端输入的验证码值
     * @return 相等验证通过返回true
     */
    @Override
    public boolean validateCaptcha(String captchaKey, String captchaVal) {
        Object redisVal = redisCache.hget("vrifyCode", captchaKey);
        if (null == redisVal) {
            throw new BizException(Constants.SYSTEM_MSG_IMG_VERIFY_CODE_EXPIRED.getCode().toString(),
                    Constants.SYSTEM_MSG_IMG_VERIFY_CODE_EXPIRED.getName());
        }
        if (redisVal != null && !StringUtils.equals(redisVal.toString(), captchaVal)) {
            throw new BizException(Constants.SYSTEM_MSG_IMG_VERIFY_CODE_NOT_CORRECT.getCode().toString(),
                    Constants.SYSTEM_MSG_IMG_VERIFY_CODE_NOT_CORRECT.getName());
        }
        return true;
    }

    @Override
    public Integer VerifyPhoneNum(String phone) {
        if (phone.length() != 11) {
            throw new BizException(Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getCode().toString(),
                    Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getName());//代表手机号位数不对
        }
        Account account = new Account();
        account.setMobile(phone);
        Integer phoneNum = accountMapper.selectCount(new EntityWrapper<>(account));
        if (phoneNum > 0) {
            throw new BizException(Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND.getCode().toString(),
                    Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND.getName());//代表手机号已被绑定
        }
        return 1;//成功
    }


    @Override
    public Boolean updateInfo(Account account) {
        if (null != account.getName()) {
            RequestContext context = ContextHolder.get();
            Account account1 = new Account();
            account1.setName(account.getName());
            account1.setCompanyId(context.getCompanyId());
            if (accountMapper.selectCount(new EntityWrapper<>(account1)) > 0) {
                throw new BizException(Constants.SYSTEM_MSG_ACCOUNT_EXIST.getCode().toString(),
                        Constants.SYSTEM_MSG_ACCOUNT_EXIST.getName());
            }
        }
        return accountMapper.updateById(account) == 1;
    }

    @Override
    public Boolean VerifyCode(SmsSendBizType smsSendBizType, String mobile, String verifyCode) {
        if (StringUtils.EMPTY.equals(verifyCode)) {
            throw new BizException(Constants.SYSTEM_MSG_CODE_EMPTY.getCode().toString()
                    , Constants.SYSTEM_MSG_CODE_EMPTY.getName());
        }
        // 根据手机和短信验证码有效时间查询发送短信的记录
        EntityWrapper<SmsSendRecord> ewSr = QueryUtil.condition(new SmsSendRecord());
        ewSr.eq("phone_num", mobile);
        ewSr.eq("send_type", SmsSendMode.SIMPLE.getCode());// 单次发送
        ewSr.eq("biz_type", smsSendBizType.getCode());
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.SECOND, SECOND);//前一分钟
        ewSr.gt("create_date", calendar.getTime());
        ewSr.orderBy("create_date", false);
        Page<SmsSendRecord> page = new Page<>(1, 1);
        Page<SmsSendRecord> recordPage = smsSendRecordService.selectPage(page, ewSr);
        //PageUtil.split(recordPage); // 分页信息和数据分离
        logger.info("手机号{}查询出来的短信发送记录={}", mobile, JSON.toJSONString(recordPage));
        if (recordPage == null) {
            // 验证码已过期
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                    , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
        }
        List<SmsSendRecord> records = recordPage.getRecords();
        if (CollectionUtils.isEmpty(records)) {
            // 验证码已过期
            throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                    , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
        } else {
            SmsSendRecord obj = records.get(0);
            if (obj == null) {
                // 验证码已过期
                throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString()
                        , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getName());
            }

            Map mapType = JSON.parseObject(obj.getTemplateParam(), Map.class);
            if (!StringUtils.equals(verifyCode, mapType.get("code").toString())) {
                // 验证码错误
                throw new BizException(Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString()
                        , Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getName());
            }
        }


        return true;
    }

    @Override
    public List<Account> getAccountsByCompanIdIds(Long companyId, List<Long> ids) {
        // TODO Auto-generated method stub
        return accountMapper.getAccountsByCompanIdIds(companyId, ids);
    }

    @Override
    public List<Long> listAccountIdByOrgIdAndEnable(Long orgId, Boolean isEnable) {
        Organization organization = organizationMapper.selectById(orgId);
        if (null == organization) {
            return null;
        }
        List<Long> accountIds = accountMapper.listAccountIdByOrgIdAndEnable(organization.getCompanyId(), orgId, isEnable ? 1 : 0);
        return accountIds;
    }

    @Override
    public List<ReportAccountRespVO> getReportAccountRespVO(Long companyId, Boolean enabled, String accountName, String orgName, List<RightLeftIndex> indices, List<Long> accountIds, List<Long> orgIds, boolean allCompany, Page page) {
        // 如果不是查询全企业的，必定需要参数
        if (!allCompany) {
            if (CollectionUtils.isEmpty(indices) && CollectionUtils.isEmpty(accountIds)) {
                logger.error("----------------报表查询非全企业参数错误------------------");
                return null;
            }
        }
        if (page == null) {
            return this.baseMapper.getReportAccountRespVO(companyId, enabled, accountName, orgName, indices, accountIds, orgIds);
        } else {
            return this.baseMapper.getReportAccountRespVO(companyId, enabled, accountName, orgName, indices, accountIds, orgIds, page);
        }
    }

    @Override
    public List<Long> getAccountId(Long companyId, Boolean enabled, String accountName, String orgName, List<RightLeftIndex> indices, List<Long> accountIds) {
        return this.baseMapper.getAccountId(companyId, enabled, accountName, orgName, indices, accountIds);
    }

    @Override
    public Long getReportAccountRespVOCount(Long companyId, Boolean enabled, List<RightLeftIndex> indices, List<Long> accountIds, boolean allCompany) {
        // 如果不是查询全企业的，必定需要参数
        if (!allCompany) {
            if (CollectionUtils.isEmpty(indices) && CollectionUtils.isEmpty(accountIds)) {
                logger.error("----------------报表查询非全企业参数错误------------------");
                return null;
            }
        }
        return this.baseMapper.getReportAccountRespVOCount(companyId, enabled, indices, accountIds);
    }

    @Override
    public List<Account> getByParam(Long companyId, Boolean enabled, String accountName, String mobile, List<RightLeftIndex> rightLeftIndices, List<Long> accountIds, Page<Account> page) {
        return this.baseMapper.getByParam(companyId, enabled, accountName, mobile, rightLeftIndices, accountIds, page);
    }

    /**
     * 数组包含
     *
     * @param arr
     * @param targetValue
     * @return
     */
    public boolean useArrayUtils(String[] arr, String targetValue) {
        return ArrayUtils.contains(arr, targetValue);
    }

    /**
     * 判断字符串中仅包含汉字、数字、英文
     *
     * @param str
     * @return
     */
    public boolean isLetterDigitOrChinese(String str) {
        String regex = "^[a-z0-9A-Z\u4e00-\u9fa5]+$";//其他需要，直接修改正则表达式就好
        return str.matches(regex);
    }

    @Override
    public List<AccountCountVO> getAccountCount(Long companyId) {

        return this.baseMapper.getAccountCount(companyId);
    }

    @Override
    public Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page) {
        if (StringUtils.isBlank(field)) {
            logger.info("列名不能为空！");
            return page;
        }
        if (field.equalsIgnoreCase(TaskParamsEnums.AUTHOR.getCode())) {
            Page<Account> page1 = new Page(page.getCurrent(), page.getSize());
            Account account = new Account();
            account.setCompanyId(ContextHolder.get().getCompanyId());
            account.setEnabled(true);
            EntityWrapper wrapper = new EntityWrapper(account);
            wrapper.setSqlSelect("distinct(name)," + "id,full_name as fullName").andNew().like("name", value).or().like("full_name", value).orderBy("create_time", false);
            List<DroolsVo> voList = null;
            List<Account> list = this.baseMapper.selectPage(page1, wrapper);
            if (!CollectionUtils.isEmpty(list)) {
                voList = new ArrayList<>(list.size());
                for (Account a : list) {
                    DroolsVo vo = new DroolsVo();
                    vo.setTaskId(a.getId());
                    vo.setTaskFieldValue(a.getFullName() == null ? a.getName() : a.getFullName());
                    vo.setTaskParamsType(field);
                    voList.add(vo);
                }
                page.setRecords(voList);
            }
            return page;
        }

        if (field.equalsIgnoreCase(TaskParamsEnums.ORG.getCode())) {
            field = "name";
            return organizationService.getClassifyNameByDrools(field, value, page);
        } else {
            if (field.equalsIgnoreCase(TaskParamsEnums.FULL_NAME.getCode())) {
                field = "full_name";
            } else if (field.equalsIgnoreCase(TaskParamsEnums.DUTY.getCode())) {
                field = "position";

            } else if (field.equalsIgnoreCase(TaskParamsEnums.REMARK1.getCode())) {
                field = "remark_first";

            } else if (field.equalsIgnoreCase(TaskParamsEnums.REMARK2.getCode())) {
                field = "remark_second";

            } else if (field.equalsIgnoreCase(TaskParamsEnums.REMARK3.getCode())) {
                field = "remark_third";
            }
            return getPage(field, value, page);
        }
    }


    /**
     * 根据field分页查询数据
     *
     * @param field
     * @param value
     * @param page
     * @return
     */
    public Page getPage(String field, String value, Page<DroolsVo> page) {
        RequestContext requestContext = ContextHolder.get();
        Long companyId = requestContext.getCompanyId();

        Account account = new Account();
        account.setCompanyId(companyId);
        account.setEnabled(true);

        String upperField = ClassUtil.getFieldName(field);
        EntityWrapper wrapper = new EntityWrapper(account);
        wrapper.setSqlSelect("distinct(" + field + ")" + " as " + upperField + ",id")
                .isNotNull(field)
                .like(field, value)
                .addFilter(field + "!=''")
                .orderBy("create_time", false);

        List<DroolsVo> voList = null;
        List<Account> list = this.baseMapper.selectPage(page, wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            voList = new ArrayList<>(list.size());

            for (Account a : list) {
                DroolsVo vo = new DroolsVo();
                vo.setTaskId(a.getId());
                vo.setTaskFieldValue(ClassUtil.invokeMethod(a, upperField));
                vo.setTaskParamsType(field);
                voList.add(vo);
            }
            page.setRecords(voList);
        }
        return page;
    }


    @Override
    public Page getPageByRuleItems(RuleVisibleRangeVo rangeVo, Page page) {

        Long companyId = rangeVo.getCompanyId();
        String keyword = rangeVo.getKeyword();
        List<SystemRuleItemVo> ruleItemVos = rangeVo.getRuleItemVos();
        List<Long> orgIds = null;
        if (CollectionUtils.isNotEmpty(ruleItemVos)) {
            EntityWrapper wrapper = null;
            //获取ruleId,orgIds 的map集合
            Map<Long, List<Long>> ruleIdOrgIdsMap = null;

            //先单独对org参数进行处理
            Set<Long> ruleIds = new HashSet();
            ruleItemVos.forEach(a -> {
                ruleIds.add(a.getRuleId());
            });
            if (CollectionUtils.isNotEmpty(ruleIds)) {
                ruleIdOrgIdsMap = new HashMap<>(ruleIds.size());
                for (Long a : ruleIds) {
                    if (!ruleIdOrgIdsMap.containsKey(a)) {
                        orgIds = organizationService.getOrgIdsByName(rangeVo, companyId, a);
                        ruleIdOrgIdsMap.put(a, orgIds);
                    }
                }
            }

            Account account = new Account();
            account.setCompanyId(companyId);
            account.setEnabled(true);
            wrapper = new EntityWrapper(account);

            //根据查询类型构建
            buildFinalWrapper(rangeVo.getIsStrategy(), wrapper, ruleItemVos, ruleIdOrgIdsMap);

            if (StringUtils.isNotBlank(keyword)) {
                wrapper.andNew().like("name", keyword)
                        .or().like("full_name", keyword)
                        .or().like("mobile", keyword);
            }
            List<Account> accounts = this.baseMapper.selectPage(page, wrapper);
            List<DroolsAccountVO> droolsAccountVOS = null;
            if (CollectionUtils.isNotEmpty(accounts)) {
                droolsAccountVOS = new ArrayList<>(accounts.size());
                Integer num = (page.getCurrent() - 1) * page.getSize();
                for (Account a : accounts) {
                    DroolsAccountVO vo = new DroolsAccountVO();
                    BeanUtils.copyProperties(a, vo);
                    num++;
                    vo.setNum(num);
                    droolsAccountVOS.add(vo);
                }
            }
            page.setRecords(droolsAccountVOS);
        }
        return page;
    }

    @Override
    public Account saveThirdAccount(Account account) {
        Account findAccount = this.find(account.getCompanyId(), account.getName());
        if (findAccount == null) {
            try {
                this.insert(account);
                logger.info("方法名:saveThirdAccount" + "--公众号新增的一个用户：" + JSON.toJSONString(account));
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return findAccount;
        }
        return account;
    }

    @Override
    public Map<Long, UserInfoVO> getUser(UserInfoVO userInfoVO) {
        Map<Long, UserInfoVO> retMap = new HashMap<>();
        List<UserInfoVO> list = accountMapper.getUser(userInfoVO.getName(), userInfoVO.getFullName(),
                userInfoVO.getOrgName(), userInfoVO.getCompanyId(), userInfoVO.getOrgIs());
        if (CollectionUtils.isNotEmpty(list)) {
            for (UserInfoVO user : list) {
                retMap.put(user.getId(), user);
            }
        }
        return retMap;
    }

    /**
     * 先对是否是策略用户查询判断，再根据条件组装wrapper
     *
     * @param isStrategy true:是策略用户范围查询 flase:规则用户查询
     * @param wrapper
     * @param
     * @param map
     * @return
     */
    public static EntityWrapper buildFinalWrapper(Boolean isStrategy, EntityWrapper wrapper, List<SystemRuleItemVo> ruleItemVos, Map<Long, List<Long>> map) {

        List<Long> orgIds = null;
        //防止多个org参数组装多次
        Integer orgParamSize = 0;
        Integer orgParamSize1 = 0;

        //是否还是同一个规则id
        Long sameRule = 0L;

        for (SystemRuleItemVo a : ruleItemVos) {
            //是否为策略用户查询
            if (isStrategy) {
                if (!sameRule.equals(a.getRuleId())) {
                    if (DroolsRelation.OR.equalsIgnoreCase(a.getRulesAndOr())) {
                        wrapper.orNew();
                    } else {
                        wrapper.andNew();
                    }
                }
                if (TaskParamsEnums.ORG.getCode().equalsIgnoreCase(a.getPropertyName())) {
                    if (!sameRule.equals(a.getRuleId())) {
                        if (map != null) {
                            orgIds = map.get(a.getRuleId());
                            if (CollectionUtils.isNotEmpty(orgIds)) {
                                wrapper.in("org_id", orgIds);
                                orgParamSize1++;
                            }
                        }
                    }
                } else {
                    buildWrapper(wrapper, a);
                }
                sameRule = a.getRuleId();
            } else {
                if (TaskParamsEnums.ORG.getCode().equalsIgnoreCase(a.getPropertyName())) {
                    if (map != null) {
                        orgIds = map.get(a.getRuleId());
                        if (CollectionUtils.isNotEmpty(orgIds)) {
                            wrapper.in("org_id", orgIds);
                            orgParamSize++;
                        }
                    }
                } else {
                    buildWrapper(wrapper, a);
                }
            }
        }
        return wrapper;
    }

    public static EntityWrapper buildWrapper(EntityWrapper wrapper, SystemRuleItemVo a) {
        if (a.getRelation() != null) {

            if (a.getPropertyName() == null) {
                logger.info("规则id:" + a.getRuleId() + "--properTyName字段不能为空");
            } else {
                a.setPropertyName(getField(a.getPropertyName()));
            }
            buildAndOr(a.getRuleId(), a.getAndOr(), wrapper);
            switch (a.getRelation()) {
                case DroolsRelation.CONTAINS:
                    wrapper.like(ClassUtil.getDomainField(a.getPropertyName()), a.getTargetVal());
                    break;
                case DroolsRelation.NOT_CONTAINS:
                    wrapper.notLike(ClassUtil.getDomainField(a.getPropertyName()), a.getTargetVal());
                    break;
                case DroolsRelation.EQUALS:
                    wrapper.eq(ClassUtil.getDomainField(a.getPropertyName()), a.getName());
                    break;
                case DroolsRelation.NOT_EQUALS:
                    wrapper.ne(ClassUtil.getDomainField(a.getPropertyName()), a.getName());
                    break;
                default:
                    logger.info("规则id:" + a.getRuleId() + "--relation字段值不合理！！");
                    break;
            }
        } else {
            logger.info("规则id:" + a.getRuleId() + "--relation字段不能为空");
        }
        return wrapper;
    }

    /**
     * 获取真实的数据库字段
     *
     * @param name
     * @return
     */
    public static String getField(String name) {
        if (name.equalsIgnoreCase(TaskParamsEnums.DUTY.getCode())) {
            name = "position";

        } else if (name.equalsIgnoreCase(TaskParamsEnums.REMARK1.getCode())) {
            name = "remark_first";

        } else if (name.equalsIgnoreCase(TaskParamsEnums.REMARK2.getCode())) {
            name = "remark_second";

        } else if (name.equalsIgnoreCase(TaskParamsEnums.REMARK3.getCode())) {
            name = "remark_third";
        }
        return name;
    }

    public static EntityWrapper buildAndOr(Long id, String andOr, EntityWrapper wrapper) {
        if (andOr == null) {
            logger.info("规则id:" + id + "--andOr字段不能为空");
        }
        if (DroolsRelation.OR.equalsIgnoreCase(andOr)) {
            wrapper.or();
        }
        return wrapper;
    }

    @Override
    public Long findSiteId(Long accountId){
        return this.accountMapper.findSiteId(accountId);
    }
}
