package com.yizhi.system.application.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.mapper.AuthzMenuMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IAuthzMenuResourceService;
import com.yizhi.system.application.domain.AuthzMenuResource;
import com.yizhi.system.application.vo.AuthzResourceVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.AuthzAccountRoleMapper;
import com.yizhi.system.application.mapper.AuthzResourceMapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.IAuthzResourceService;
import com.yizhi.system.application.domain.AuthzResource;
import com.yizhi.system.application.vo.OperationVO;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 操作表 服务实现类
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-09
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AuthzResourceServiceImpl extends ServiceImpl<AuthzResourceMapper, AuthzResource> implements IAuthzResourceService {
    private static final Logger logger = LoggerFactory.getLogger(AuthzResourceServiceImpl.class);
    @Autowired
    AuthzAccountRoleMapper accountRoleMapper;
    @Autowired
    DomainConverter converter;
    @Autowired
    private AuthzResourceMapper authzResourceMapper;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private AuthzMenuMapper authzMenuMapper;
    @Autowired
    IAuthzMenuResourceService authzMenuResourceService;

    @Override
    public Boolean saveAuthzResource(AuthzResource resource) {
        RequestContext requestContext = ContextHolder.get();
        try {
            resource.setId(idGenerator.generate());
            resource.setCreateById(requestContext.getAccountId());
            resource.setCreateByName(requestContext.getAccountName());
            resource.setCreateTime(new Date());
            resource.setStatus(1);
            authzResourceMapper.insert(resource);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("增加失败", e);
            return false;
        }
        return true;
    }

    @Override
    public Boolean deleteAuthzResource(Long id) {
        AuthzResource resource = null;
        int i = 0;
        try {
            resource = new AuthzResource();
            resource.setId(id);
            resource.setStatus(2);
            authzResourceMapper.updateById(resource);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("删除失败", e);
            return false;
        }
        return true;
    }

    @Override
    public Boolean updateAuthzResource(AuthzResource authzResource) {
        try {
            authzResourceMapper.updateById(authzResource);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("修改失败", e);
            return false;
        }
        return true;
    }

    @Override
    public AuthzResource queryAuthzResource(Long id) {
        try {
            AuthzResource o = authzResourceMapper.selectById(id);
            if (o != null) {
                return o;
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询失败", e);
        }
        return null;
    }


    @Override
    public Page<AuthzResource> ListAuthzResource(String name, Integer status, Integer pageNo, Integer pageSize) {
        Page<AuthzResource> page = new Page<>(pageNo, pageSize);
        try {
            List<AuthzResource> list = authzResourceMapper.listAuthzResource(name, status, new RowBounds(page.getOffset(), page.getLimit()));
            Integer count = authzResourceMapper.queryAuthzResourceNum(name, status, new RowBounds(page.getOffset(), page.getLimit()));
            page.setRecords(list);
            page.setTotal(count);

        } catch (Exception e) {
            e.printStackTrace();
            logger.error("分页查询失败", e);
        }
        return page;
    }

    /**
     * 查询所有的父节点
     *
     * @return
     */
    @Override
    public List<AuthzResource> getParentOperations() {
        AuthzResource operation = new AuthzResource();
        EntityWrapper<AuthzResource> ew = QueryUtil.condition(operation);
        ew.where("status={0}", 1).and()
                .isNull("parent_id");

        return this.selectList(ew);
    }

    /**
     * 根据父节点查询子节点
     *
     * @param parentId 父节点ID
     * @return
     */
    @Override
    public Map<String, List<AuthzResource>> getSubOperations(Long parentId) {
        Map<String, List<AuthzResource>> retMap = new HashMap<>();
        // 查询父节点下分类
        AuthzResource operation = new AuthzResource();
        EntityWrapper<AuthzResource> ewClassify = QueryUtil.condition(operation);
        ewClassify.where("status={0}", 1)
                .and("parent_id={0}", parentId);
        List<AuthzResource> classify = this.selectList(ewClassify);
        retMap.put("classify", classify);
        //查询分类下面的分组
        List<Long> groupIds = new ArrayList<>();
        for (AuthzResource obj : classify) {
            groupIds.add(obj.getId());
        }
        if (CollectionUtils.isNotEmpty(groupIds)) {
            EntityWrapper<AuthzResource> ewGroup = QueryUtil.condition(operation);
            ewGroup.where("status={0}", 1).and()
                    .in("parent_id", groupIds);
            List<AuthzResource> group = this.selectList(ewGroup);
            retMap.put("group", group);

            // 查询最后一级项
            List<Long> itemIds = new ArrayList<>();
            for (AuthzResource item : group) {
                itemIds.add(item.getId());
            }
            if (CollectionUtils.isNotEmpty(itemIds)) {
                EntityWrapper<AuthzResource> ewItem = QueryUtil.condition(operation);
                ewItem.where("status={0}", 1).and()
                        .in("parent_id", itemIds);
                List<AuthzResource> items = this.selectList(ewGroup);
                retMap.put("items", items);
            }
        }
        return retMap;
    }

    @Override
    public List<OperationVO> getMenuList() {
        AuthzResource op0 = new AuthzResource();
        op0.setStatus(1);
        op0.setParentId(0L);
        List<OperationVO> menuList = this.selectList(QueryUtil.condition(op0)).parallelStream().map((AuthzResource operation1) -> {
            op0.setParentId(operation1.getId());
            List<OperationVO> childs1 = this.selectList(QueryUtil.condition(op0)).parallelStream().map((AuthzResource operation2) -> {
                op0.setParentId(operation2.getId());
                List<OperationVO> childs2 = this.selectList(QueryUtil.condition(op0)).parallelStream().map((AuthzResource operation3) -> {
                    return (OperationVO) converter.toVO(operation3, OperationVO.class);
                }).collect(Collectors.toList());
                OperationVO operationVO1 = (OperationVO) converter.toVO(operation2, OperationVO.class);
                operationVO1.setChildOperations(childs2);
                return operationVO1;
            }).collect(Collectors.toList());
            OperationVO operationVO2 = (OperationVO) converter.toVO(operation1, OperationVO.class);
            operationVO2.setChildOperations(childs1);
            return operationVO2;
        }).collect(Collectors.toList());
        return menuList;
    }

//    @Override
//    public List<CommonTree> getMenu(Long accountId, List<Long> roleIds) {
//        List<AuthzMenu> menus = authzMenuMapper.getMenu(roleIds);
//
//        if (!CollectionUtils.isEmpty(menus)) {
//            List<CommonTree> list = new ArrayList<>();
//            for (AuthzMenu m : menus) {
//                CommonTree tree = new CommonTree();
//                tree.setId(m.getId());
//                tree.setPId(m.getParentId());
//                tree.setName(m.getName());
//                tree.setNode(m);
//
//                list.add(tree);
//            }
//            logger.info("用户【{}】查询到菜单【{}】", accountId, list);
//            list = TreeUtil.buildTree(list, 0L);
//            logger.info("用户【{}】组装成菜单【{}】", accountId, list);
//            return list;
//        }
//        return null;
//    }

    @Override
    public Boolean ignoreAction(Long id) {
        AuthzResource operation = null;

        try {
            operation = new AuthzResource();
            operation.setId(id);
            operation.setStatus(0);
            authzResourceMapper.updateById(operation);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("操作失败", e);
            return false;
        }
        return true;
    }

    @Override
    public Boolean updateAuthzResourceVo(AuthzResourceVo authzResourceVo) {
        RequestContext context = ContextHolder.get();
        AuthzResource authzResource = new AuthzResource();
        BeanUtils.copyProperties(authzResourceVo, authzResource);
        Boolean flag = true;
        Integer num = 0;
        try {
            if (null != authzResourceVo.getMenuIds() && authzResourceVo.getMenuIds().size()>0) {
                for (Long menuId:authzResourceVo.getMenuIds()) {
                    AuthzMenuResource authzMenuResource = new AuthzMenuResource();
                    authzMenuResource.setId(idGenerator.generate());
                    authzMenuResource.setResourceId(authzResourceVo.getId());
                    authzMenuResource.setMenuId(menuId);
                    authzMenuResource.setCreateById(context.getAccountId());
                    authzMenuResource.setCreateByName(context.getAccountName());
                    authzMenuResource.setCreateTime(new Date());
                    flag = authzMenuResourceService.insert(authzMenuResource);
                }
            }
            authzResource.setStatus(1);//有效
            num = authzResourceMapper.updateById(authzResource);
            if (flag && num == 1 ) {
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("修改失败", e);
        }
        return false;
    }

    @Override
    public List<AuthzResource> menuResourceList(Long menuId) {

        try {
            return authzResourceMapper.menuResourceList(menuId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
