package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.LoginLogMapper;
import com.yizhi.system.application.service.ILoginLogService;
import com.yizhi.system.application.domain.LoginLog;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-06-08
 */
@Service
public class LoginLogServiceImpl extends ServiceImpl<LoginLogMapper, LoginLog> implements ILoginLogService {

	@Override
	public Integer loginLookNum(Long siteId, Integer loginType) {
		// TODO Auto-generated method stub
		LoginLog ll=new LoginLog();
		ll.setSiteId(siteId);
		ll.setLoginType(loginType);
		EntityWrapper<LoginLog> wrapper=new EntityWrapper<LoginLog>(ll);
		//取出当天的登入记录
		wrapper.addFilter("TO_DAYS(login_date)=TO_DAYS(NOW())");
		return this.selectCount(wrapper);
	}

	@Override
	public Integer countActiveAccount(long siteId, Date startDate, Date endDate) {
		return this.baseMapper.countActiveAccount(siteId, startDate, endDate);
	}

	@Override
	public List<LoginLog> getLogByDate(Long siteId, Long accountId, Date date) {
		
		return this.baseMapper.getLogByDate(siteId, accountId, date);
	}

}
