package com.yizhi.system.application.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

import com.yizhi.system.application.domain.Organization;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.OrgExportService;
import com.yizhi.system.application.vo.OrgExportVO;

@Service
public class OrgExportServiceImpl implements OrgExportService{

    @Autowired
    private IOrganizationService organizationService;
    
    @Autowired
    private OrganizationMapper organizationMapper;
    
	@Override
	public List<OrgExportVO> orgExport(Long companyId, Long orgId) {
        Set<Long> itemChidren = organizationService.listChildrenId(Arrays.asList(orgId));
        List<Long> orgs = new ArrayList<>(itemChidren);
        List<OrgExportVO> list = organizationMapper.orgExport(companyId, orgs);
        for(OrgExportVO orgVO:list) {
        	Long parentId = orgVO.getParentId();
        	if (0!=parentId) {
            	Organization organization = organizationService.selectById(parentId);
            	String upName="";
            	List<String> names = organizationService.listParentNameIds(orgVO.getOrgId());
            	for (int i = 0; i < names.size()-1; i++) {
            		if (0==i) {
						upName+=names.get(i);
					}else {
						upName+="-"+names.get(i);
					}
				}
            	orgVO.setParentCode(organization.getCode());
            	orgVO.setParentName(organization.getName());
            	orgVO.setUpName(upName);
            	if (null==orgVO.getUserSumNum()) {
            		orgVO.setUserSumNum(0L);
				}
            	if (null==orgVO.getEnableUserNum()) {
					orgVO.setEnableUserNum(0L);
				}
            	if (null==orgVO.getStopUserNum()) {
					orgVO.setStopUserNum(0L);
				}
			}else {
            	if (null==orgVO.getUserSumNum()) {
            		orgVO.setUserSumNum(0L);
				}
            	if (null==orgVO.getEnableUserNum()) {
					orgVO.setEnableUserNum(0L);
				}
            	if (null==orgVO.getStopUserNum()) {
					orgVO.setStopUserNum(0L);
				}
			}
        }
		return list;
	}

}
