package com.yizhi.system.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.mapper.CompanyMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.IUserWechatService;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.WeChatUpdateOrganizationVo;
import com.yizhi.system.application.vo.WeChatUserVO;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author lilingye
 * @date 2018-8-20 09:38:28
 */
@Log4j2
@Service
public class UserWechatServiceImpl implements IUserWechatService {

    @Autowired
    private RedisCache redisCache;

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    IOrganizationService orgService;

    @Autowired
    private IAccountService accountService;

    @Autowired
    private OrganizationIndexService organizationIndexService;

    @Autowired
    private OrganizationCacheService organizationCacheService;

    @Autowired
    private CompanyMapper companyMapper;

    @Autowired
    private AccountImportServiceImpl accountImportService;

    @Autowired
    private IOrganizationService organizationService;

    @Value("${wechat.account.initializtion.pwd}")
    private String password;

    public static final Long SITE_ID = 1314L;

    public static final Long COMPANY_ID = 1314L;

    @Override
    public Account saveUser(WeChatUserVO weChatUserVO) {
        List<String> orgNames = weChatUserVO.getOrgNames();
        AccountVO accountVO = weChatUserVO.getAccountVO();

        log.info("传参orgNames：" + orgNames);

        // 取出上下文信息
        RequestContext context = weChatUserVO.getContext();
        log.info("上下问的信息：" + JSON.toJSON(context));
        // 初始化组织id
        Long orgId = null;

        List<Map<String, Long>> tempList = new ArrayList<Map<String, Long>>();
        // 存放已添加的节点数据
        Map<String, Map<String, Long>> orgMap = new HashMap<String, Map<String, Long>>();
        Map<String, Long> childOrgMap = new HashMap<String, Long>();
        Map<Long, String> parentIdLayerMap = new HashMap<>();
        //判断是否有新节点产生
        boolean isNewNode = false;
        boolean clearFlag = false;

        isNewNode = false;
        childOrgMap = new HashMap<String, Long>();


        // add 2018-7-17 10:00:14
//                String[] orgNameArray = (model.getFullOrgName().trim()).split("\\+");
        String[] orgNameArray = orgNames.toArray(new String[0]);
        Organization rootOrg = new Organization();
        rootOrg.setParentId(0L);
        rootOrg.setDeleted(Boolean.valueOf(false));
        rootOrg.setCompanyId(context.getCompanyId());
        rootOrg = rootOrg.selectOne(new EntityWrapper(rootOrg));
        Long parentId = rootOrg.getId();

        List<Organization> organizationList = new ArrayList<Organization>();
        Date sysDate = new Date();

        Organization midOrg = null;
        String newOrgCode = null;

        for (int k = 0; k < orgNameArray.length; k++) {
            Long id = null;

            if (!isNewNode && !orgMap.isEmpty()) {
                if (orgMap.size() > 0 && orgMap.get(orgNameArray[0]) != null) {
                    parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                    if (parentId != null) {
                        if (k == 0) {
                            parentId = rootOrg.getId();
                        } else {
                            parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                        }

                        orgId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                        if (k > 0) {
                            if (k == 1) {
                                log.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                        orgMap.get(orgNameArray[0]).get(orgNameArray[k] + k) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                            } else {
                                log.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                        orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k)) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                            }

                        }
                        continue;
                    }
                }
            }
            if (k == 0) {
                parentId = rootOrg.getId();
            } else {
                parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                log.info("parentId:" + parentId);
            }

            midOrg = getOrg(orgNameArray[k], parentId);
            if (midOrg != null) {
                log.info("已经存在导入组织的名称：" + k + "-层级-" + midOrg.getEnName());
                log.info("已经存在导入组织id：" + k + "-层级-" + midOrg.getId());
                parentId = midOrg.getId();
                orgId = parentId;
                isNewNode = false;

                if (k == 0) {
                    childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                    orgMap.put(orgNameArray[0], childOrgMap);
                    midOrg.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                    parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                } else {
                    childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                    childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                    orgMap.put(orgNameArray[0], childOrgMap);
                    midOrg.setParentIdLayer(parentIdLayerMap.get(midOrg.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                    parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                }
                continue;
            } else {
                Organization organization = new Organization();
                id = idGenerator.generate();
                log.info("公司id：" + context.getCompanyId());
                organization.setCompanyId(context.getCompanyId());
                // 生成组织编码
                // 获取redis中的编码值编码
                String orgCode = redisCache.get(context.getCompanyCode()) + "";
                if (orgCode != null && !"".equals(orgCode) && !"null".equals(orgCode)) {
                    // 新的组织编码
                    newOrgCode = (Integer.valueOf(orgCode) + 1) + "";
                    // 放到缓存中
                    redisCache.set(context.getCompanyCode(), newOrgCode);
                } else {
                    newOrgCode = "1";
                    redisCache.set(context.getCompanyCode(), newOrgCode);
                }
                String orgNum = "";
                switch (newOrgCode.length()) {
                    case 1:
                        orgNum = "000" + newOrgCode;
                        break;
                    case 2:
                        orgNum = "00" + newOrgCode;
                        break;
                    case 3:
                        orgNum = "0" + newOrgCode;
                        break;
                    default:
                        orgNum = newOrgCode;
                }
                organization.setCode(context.getCompanyCode() + orgNum);
                organization.setId(id);
                organization.setName(orgNameArray[k].trim());
                if (organization.getName().equals("理赔")) {
                    int uu = 0;
                    log.info("理赔");
                }
                if (k == 0) {
                    organization.setParentId(rootOrg.getId());
                    organization.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                    parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                } else {
                    if (k > 0) {
                        parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                        log.info("父级parentId：" + parentId);

                    }
                    organization.setParentId(parentId);
                    organization.setParentIdLayer(parentIdLayerMap.get(organization.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                    parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                }
                organization.setLayer(k + 1);
                organization.setCreateTime(sysDate);
                organization.setCreateByName("admin");
                organization.setCompanyId(context.getCompanyId());
                organizationList.add(organization);
                parentId = id;
                orgId = id;
                log.info("组织的id：" + orgId);

            }

            isNewNode = true;//有新节点产生，那么它下面的子节点全部是新增加
            //childOrgMap.put(orgNameArray[k] + k, id);
            if (k == 0) {
                childOrgMap.put(getAllParentName(orgNameArray, k), id);
                orgMap.put(orgNameArray[0], childOrgMap);
            } else {
                childOrgMap.put(getAllParentName(orgNameArray, k), id);
                childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                orgMap.put(orgNameArray[0], childOrgMap);
            }
            log.info("添加新组织：" + orgNameArray[k] + "_" + k + ":" + id);
        }
        if (organizationList != null && organizationList.size() > 0) {
            // 批量新增组织
            orgService.insertBatch(organizationList);
            clearFlag = true;
        }
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        //设置起时间
        cal.setTime(date);
        //增加一年
        cal.add(Calendar.YEAR, 1);
        String name = accountVO.getName();
        if (StringUtils.isNotEmpty(name)) {
            name = name.toLowerCase();
            log.info("用户：" + name);
        }
        Account account = new Account();
        account.setId(idGenerator.generate());
        account.setName(name);
        account.setCompanyId(context.getCompanyId());
        account.setEmail(accountVO.getEmail());
        account.setMobile(accountVO.getMobile());
        account.setTelephone(accountVO.getTelephone());
        account.setSex(accountVO.getSex());
        account.setHeadPortrait(accountVO.getHeadPortrait());
        // account.setWorkNum(worknum);
        account.setPassword(ShaEncrypt.encryptNewPassword(password));
        // account.setExpiredType(expiredType);
        account.setStartTime(date);
        account.setEndTime(cal.getTime());
        // account.setExpiredTime(expiredTime);
        // account.setValidDays(validDays);
        account.setOrgId(orgId);
        account.setFullName(accountVO.getFullName());
        account.setPosition(accountVO.getPosition());
        account.setCreateById(0L);
        account.setCreateTime(date);
        account.setCreateByName("wechatAutoAdd");

        Account findAccount = accountService.find(account.getCompanyId(), account.getName());
        if (findAccount == null) {
            try {
                boolean insertRs = accountService.insert(account);
                log.info("方法名:saveUser"+"--企业微信新增的一个用户：" + JSON.toJSONString(account));
                log.info("新增的结果：" + insertRs);
                log.info("新增用户的createName：" + account.getCreateByName());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            log.info("方法名:saveUser"+"--企业微信更新的一个用户：" + JSON.toJSONString(findAccount));
            findAccount.setUpdateTime(date);
            findAccount.setUpdateByName("wechatAutoAdd");
            findAccount.setOrgId(orgId);
            accountService.updateById(findAccount);
            account = findAccount;
        }
        if (clearFlag) {
            // 计算左右索引
            organizationIndexService.addInitTask(context.getCompanyId());
        }

        return account;
    }

    @Override
    public Account saveProviderUser(WeChatUserVO weChatUserVO) {
        AccountVO accountVO = weChatUserVO.getAccountVO();
        // 取出上下文信息
        RequestContext context = weChatUserVO.getContext();
        log.info("上下问的信息：" + JSON.toJSON(context));

        Account account = new Account();

        account.setId(idGenerator.generate());
        account.setName(accountVO.getName());
        account.setCompanyId(context.getCompanyId());
        account.setEmail(accountVO.getEmail());
        account.setMobile(accountVO.getMobile());
        account.setTelephone(accountVO.getTelephone());
        account.setSex(accountVO.getSex());
        account.setHeadPortrait(accountVO.getHeadPortrait());
        account.setPassword(ShaEncrypt.encryptNewPassword(password));

        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        //设置起时间
        cal.setTime(date);
        //增加一年
        cal.add(Calendar.YEAR, 1);
        account.setStartTime(date);
        // 一年的使用权
        account.setEndTime(cal.getTime());

        account.setFullName(accountVO.getFullName());
        account.setPosition(accountVO.getPosition());
        account.setCreateById(0L);
        account.setCreateTime(date);
        account.setCreateByName("providerUser");
        account.setCompanyId(context.getCompanyId());

        // 创建组织
        String corpId = weChatUserVO.getCorpId();
        Organization o = new Organization();
        o.setCompanyId(context.getCompanyId());
        o.setDeleted(Boolean.FALSE);
        o.setParentId(0L);
        o.setRootId(0L);
        Organization corpOrg = organizationService.selectList(QueryUtil.condition(o)).get(0);

        if (StringUtils.isNotEmpty(corpId) && corpOrg != null) {
            Organization org = accountImportService.getOrg(corpId, corpOrg.getId());
            if (null != org) {
                account.setOrgId(org.getId());
            } else {
                account.setOrgId(context.getCompanyId());
                Organization organization = addProviderOrganization(corpId, context.getCompanyId(), context.getSiteId(), corpOrg.getId());
                account.setOrgId(organization != null ? organization.getId() : context.getCompanyId());
            }
        } else {
            log.error("服务商创建组织及学员参数异常："+JSON.toJSONString(weChatUserVO));
//            account.setOrgId(context.getCompanyId());
            account.setOrgId(999L);
        }
        try {
            //查询数据库是否已经存在相应用户
            Account findAccount = accountService.find(account.getCompanyId(), account.getName());
            if (findAccount != null) {
                account = findAccount;
            }else {
                boolean insertRs = accountService.insert(account);
                log.info("方法名：saveProviderUser --服务商新增了用户的结果：" +JSON.toJSONString(findAccount));
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("返回的错误信息：{}", e.getMessage());
        }

        organizationIndexService.initLeftRight(context.getCompanyId());

        return account;
    }

    /**
     * 查询同级组织，是否存在name的部门
     *
     * @param name
     * @param parentId
     * @return
     */
    public Organization getOrg(String name, Long parentId) {
        if (parentId == null) {
            log.error("parentId为空！！！");
            return null;
        }
        Organization org = new Organization();
        org.setName(name.trim());
        org.setParentId(parentId);
        org.setDeleted(false);
        return orgService.selectOne(QueryUtil.condition(org));
    }

    /**
     * 获取当前节点的所有父亲节点
     *
     * @param orgNameArray
     * @param curIndex
     * @return
     */
    private static String getAllParentName(String[] orgNameArray, int curIndex) {
        String name = "";
        for (int i = 0; i < curIndex + 1; i++) {
            name += orgNameArray[i];
        }
        return name + curIndex;
    }


    /**
     * 服务商用户
     *
     * @param corpId    职级编码
     * @param companyId 公司id
     * @return 组织实体
     */
    @Transactional(rollbackFor = Exception.class)
    public Organization addProviderOrganization(String corpId, Long companyId, Long siteId, Long parentId) {
        Date date = new Date();
        Organization organization = new Organization();
        Long orgId = idGenerator.generate();
        organization.setId(orgId);
        organization.setCode(corpId.trim());
        organization.setName(corpId.trim());
        organization.setLayer(1);
        organization.setRootId(parentId);
        organization.setParentId(parentId);
        organization.setParentIdLayer(siteId + Organization.PARENT_ID_LAYER_SEPARATOR + orgId);
        organization.setDeleted(Boolean.FALSE);
        organization.setCompanyId(companyId);
        organization.setCreateTime(date);
        organization.setCreateByName("ProviderAdmin");
        organization.setCreateById(companyId);
        organization.setUpdateTime(date);
        organization.setUpdateByName("ProviderAdmin");
        organization.setUpdateById(companyId);

        boolean addResult = organizationService.insert(organization);
        if (addResult) {
            organizationIndexService.initLeftRight(companyId);
        }
        log.info("新增组织：{}", addResult);
        return organization;
    }

    @Override
    public WeChatUpdateOrganizationVo weChatUpdateOrganization(WeChatUpdateOrganizationVo vo) {

        if (vo.getCompanyId() == null||vo.getAccountId() == null || CollectionUtils.isEmpty(vo.getOrgNames())) {
            vo.setIsSuccess(false);
            vo.setReason("公司id或accountId或部门列表为空！");
            return vo;
        }
        log.info("修改部门传参：{}", JSON.toJSONString(vo));
        Long companyId = vo.getCompanyId();
        //企业微信用户的部门名称列表 已排序（父部门在前）
        List<String> orgNames = vo.getOrgNames();
        //先获取根部门
        Organization rootOrg = getRootOrg(companyId);
        if (rootOrg == null) {
            log.error("未查询到根部门！");
        }
        Organization org = null;
        Boolean isSecondOrg = true;
        //为新增二级部门判断需要
        Boolean isSecondOrgInsert = false;
        //获取需要新增的部门名称
        List<String> needInsertOrgs = new ArrayList<>(orgNames);
        //<key,org>    key = 当前name+layer
        HashMap<String, Organization> idOrgMap = new HashMap<>();
        //idOrgMap 的key 之所以这样是因为子父name可能重复
        String key = null;
        //层级  根部门layer=0
        int layer = 1;
        String a = null;
        //没有部门新增，最后修改为该部门
        Organization updateOrg = null;
        for (int i = 0; i < orgNames.size(); i++) {
            a = orgNames.get(i);
            //是否是第二级部门
            if (isSecondOrg) {
                //判断同级部门下是否存在该name的部门
                org = getOrg(a, rootOrg.getId());
                isSecondOrg = false;
                if (org == null) {
                    isSecondOrgInsert = true;
                }
            } else {
                org = getOrg(a, org.getId());
                layer++;
            }
            if (org == null) {
                //该部门如果不存在，则其子部门也一定不存在，直接退出循环
                break;
            } else {
                //存放数据
                key = a + "_" + layer;
                idOrgMap.put(key, org);
                //如果存在则，剔除元素
                needInsertOrgs.remove(a);
                updateOrg = org;
            }
        }
        vo.setIsSuccess(true);
        if (CollectionUtils.isNotEmpty(needInsertOrgs)){
            //新增部门
            vo = insertWeChatOrg(vo, orgNames,needInsertOrgs, rootOrg.getId(), isSecondOrgInsert, idOrgMap);
        }else {
            //只是把用户移动到另外一个部门
            updateAccountOrg(vo,updateOrg.getId());
        }
        return vo;
    }

    /**
     * 获取根部门(一级部门)
     *
     * @param companyId
     * @return
     */
    private Organization getRootOrg(Long companyId) {
        if (companyId == null) {
            return null;
        }
        Organization rootOrg = new Organization();
        rootOrg.setParentId(0L);
        rootOrg.setDeleted(Boolean.valueOf(false));
        rootOrg.setCompanyId(companyId);
        rootOrg = rootOrg.selectOne(new EntityWrapper(rootOrg));
        return rootOrg;
    }

    /**
     * 企业微信新增部门
     *
     *
     * @param orgNames   企业用户的部门列表名称
     * @param needInsertOrgs          需要新增的部门名称
     * @param rootId            根部门id,不为空说明第一个新增的为二级部门
     * @param isSecondOrgInsert 判断是否为二级部门新增
     * @param idOrgMap          <key,org>    key = 当前name+layer
     * @return
     */
    private WeChatUpdateOrganizationVo insertWeChatOrg(WeChatUpdateOrganizationVo vo,
                                                       List<String> orgNames, List<String> needInsertOrgs,
                                                       Long rootId,
                                                       Boolean isSecondOrgInsert,
                                                       HashMap<String, Organization> idOrgMap) {
        String reason = null;
        if (CollectionUtils.isNotEmpty(orgNames)) {
            if (rootId == null) {
                reason = "rootId为空！！！";
                log.error(reason);
                vo.setReason(reason);
                return vo;
            }
            List<Organization> organizations = new ArrayList<>(orgNames.size());
            Date date = new Date();
            //层级
            int layer = 1;
            Long id = null;
            String parentIdLayer = null;
            String a = null;
            //parentIdMap 的key
            String key = null;
            String parentName = null;
            int parentLayer = 0;
            for (int i = 0; i < orgNames.size(); ) {
                a = orgNames.get(i);
                i++;
                if (!needInsertOrgs.contains(a)){
                    //只有新增的部门才继续
                    continue;
                }
                Organization o = new Organization();
                id = idGenerator.generate();

                //二级部门新增
                if (isSecondOrgInsert) {
                    isSecondOrgInsert = false;
                    o.setParentId(rootId);
                    o.setLayer(layer);
                    o.setParentIdLayer(rootId + Organization.PARENT_ID_LAYER_SEPARATOR + id);
                } else {
                    layer++;
                    o.setLayer(layer);
                    Long parentId = null;
                    if (idOrgMap != null) {
                        parentName = orgNames.get(orgNames.indexOf(a)-1);
                        parentLayer = layer - 1;
                        key = parentName + "_" + parentLayer;
                        //根据父key获取父部门信息
                        Organization tem = idOrgMap.get(key);
                        if (tem != null) {
                            parentId = tem.getId();
                            parentIdLayer = tem.getParentIdLayer();
                            if (parentId == null) {
                                reason = "层级：" + layer + "当前部门名称：" + a + "   parentId为空";
                                log.error(reason);
                                vo.setReason(reason);
                                return vo;
                            }
                            if (parentIdLayer == null) {
                                reason = "层级：" + layer + "当前部门名称：" + a + "   parentIdLayer为空";
                                log.error(reason);
                                vo.setReason(reason);
                                return vo;
                            }
                            o.setParentId(parentId);
                            o.setParentIdLayer(parentIdLayer + Organization.PARENT_ID_LAYER_SEPARATOR + id);
                        } else {
                            reason = "层级：" + layer + "当前部门名称：" + a + "获取父部门为空";
                            log.error(reason);
                            vo.setReason(reason);
                            return vo;
                        }
                    }
                }
                o.setId(id);
                o.setName(a);
                o.setEnName(a);
                o.setDescription(a);
                o.setRootId(rootId);
                o.setDeleted(false);
                o.setCompanyId(vo.getCompanyId());
                o.setCode("corWeChat_" + o.getId());
                o.setCreateById(0L);
                o.setCreateByName("通过企业微信创建");
                o.setCreateTime(date);
                organizations.add(o);
                //存放数据
                key = a + "_" + layer;
                idOrgMap.put(key, o);
            }
            if (CollectionUtils.isNotEmpty(organizations)) {
                organizationService.insertBatch(organizations);
                // 更新左右索引
                organizationIndexService.addInitTask(vo.getCompanyId());
                //把用户的部门更换
                updateAccountOrg(vo, organizations.get(organizations.size() - 1).getId());

                Company company = companyMapper.selectById(vo.getCompanyId());
                if (company != null) {
                    // 删除企业下站点:部门 信息
                    reason = "开始删除部门缓存，传参："+company.getCode();
                    log.info(reason);
                    try {
                        redisCache.hdel(CacheNamespace.REDIS_COMPANY_ORGS, new String[]{company.getCode()});
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    reason = "删除部门缓存成功，传参："+company.getCode();
                    log.info(reason);
                }
            }
        }
        return vo;
    }

    /**
     * 更新用户的部门id
     *
     * @param vo
     * @param orgId
     * @return
     */
    private WeChatUpdateOrganizationVo updateAccountOrg(WeChatUpdateOrganizationVo vo, Long orgId) {
        if (orgId == null) {
            return vo;
        }
        log.info("更新用户信息是否有变化：{}", JSON.toJSONString(vo), "orgID:" + orgId);
        Account account = new Account();
        account.setId(vo.getAccountId());
        account.setOrgId(orgId);
        account.setUpdateById(0L);
        account.setUpdateByName("企业微信更新");
        account.setUpdateTime(new Date());
        accountService.updateById(account);
        vo.setIsSuccess(true);
        return vo;
    }

}
