package com.yizhi.system.application.service.using;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.exp.ExcelExportor;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.core.application.task.TaskExecutor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Author: shengchenglong
 * @Date: 2018/9/17 16:50
 */
@Service
public class AccountRangeExportService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AccountRangeExportService.class);

    @Autowired
    private IAccountService accountService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private LogEventPublisher publisher;

    public String doExport(AccountRangeExportParam param, String taskSerialNoPrefix, String fileNamePattern) {
        RequestContext requestContext = param.getContext();
        Date now = new Date();
        String serialNo = taskSerialNoPrefix + DateFormatUtils.format(now, "yyyyMMdd HH:mm:ss");
        TaskContext taskContext = new TaskContext(idGenerator.generate(), serialNo, fileNamePattern, requestContext.getAccountId(),
                now, requestContext.getSiteId(), requestContext.getCompanyId());
        AccountExporter accountExporter = new AccountExporter<>(null, null, param, fileNamePattern);
        accountExporter.bindContext(taskContext);
        accountExporter.bindPublisher(publisher);
        taskExecutor.asynExecute(accountExporter);
        LOGGER.info("开始导出异步任务：{}", taskSerialNoPrefix);
        return serialNo;
    }

    private List<Account> exportFindRange(AccountRangeExportParam param) {
        // 部门 id ： name(code) map集合
        Map<Long, String> orgNameMap = new HashMap<>();
        Map<Long, String> orgFullNameMap = new HashMap<>();
        Map<Long, String> orgCodeMap = new HashMap<>();

        // 公司下部门名称 map
        Organization organization = new Organization();
        organization.setDeleted(Boolean.valueOf(false));
        organization.setCompanyId(param.getContext().getCompanyId());
        List<Organization> organizations = organizationService.selectList(new EntityWrapper<>(organization));
        for (Organization o : organizations) {
            orgNameMap.put(o.getId(), o.getName());
            orgCodeMap.put(o.getId(), o.getCode());
        }
        // 组装部门全名称
        String[] parentIdLayerArr = null;
        for (Organization o : organizations) {
            parentIdLayerArr = o.getParentIdLayer().split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parentIdLayerArr.length; i++) {
                if (i == 0) {
                    sb.append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                } else {
                    sb.append("+").append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                }
                orgFullNameMap.put(o.getId(), sb.toString());
            }
        }

        List<Long> orgIds = param.getOrgIds();
        List<Long> accountIds = param.getAccountIds();
        // 如果有指定部门
        Set<Account> accounts = accountService.getList(param.getContext().getCompanyId(), orgIds, accountIds);
        if (CollectionUtils.isNotEmpty(accounts)) {
            List<Account> list = new ArrayList<>(accounts.size());
            list.addAll(accounts);

            if (CollectionUtils.isNotEmpty(list)) {
                for (Account a : accounts) {
                    a.setWorkNum(null == a.getWorkNum() ? "" : a.getWorkNum());
                    a.setFullName(null == a.getFullName() ? "" : a.getFullName());
                    a.setPosition(null == a.getPosition() ? "" : a.getPosition());
                    a.setMobile(null == a.getMobile() ? "" : a.getMobile());
                    a.setEmail(null == a.getEmail() ? "" : a.getEmail());
                    a.setWechat(null == a.getWechat() ? "" : a.getWechat());
                    a.setEnabledState(a.getEnabled() ? "启用" : "停用");
                    a.setOrgCode(orgCodeMap.get(a.getOrgId()));
                    if (null != a.getCreateTime()) {
                        a.setCreateTimeStr(DateFormatUtils.format(a.getCreateTime(), "yyyy/MM/dd"));
                    }
                    if (null != a.getExpiredTime()) {
                        a.setExpiredTimeStr(DateFormatUtils.format(a.getExpiredTime(), "yyyy/MM/dd"));
                    } else {
                        a.setExpiredTimeStr("");
                    }
                    //  过期类型(1长期，2周期，3天数)
                    if (a.getExpiredType() == 1) {
                        a.setValidDaysStr("");
                        a.setExpiredTimeStr("长期有效");
                    } else if (a.getExpiredType() == 2) {
                        a.setValidDaysStr((null == a.getStartTime() ? "" : DateFormatUtils.format(a.getStartTime(), "yyyy/MM/dd")) + " - " + (null == a.getEndTime() ? "" : DateFormatUtils.format(a.getEndTime(), "yyyy/MM/dd")));
                        a.setExpiredTimeStr(DateFormatUtils.format(a.getEndTime(), "yyyy/MM/dd"));
                    } else {
                        a.setValidDaysStr(String.valueOf(a.getValidDays()));
                        a.setExpiredTimeStr(a.getExpiredTimeStr());
                    }
                    a.setOrgFullName(orgFullNameMap.get(a.getOrgId()));
                }
            }
            return list;
        }
        return null;
    }

    private Template buildTemplate(AccountRangeExportParam param, String fileNamePattern) {
        Template template = new Template();
        List<TemplateColumn> columns = new ArrayList<>();
//        columns.add(new TemplateColumn("id", "用户id", 1));
        columns.add(new TemplateColumn("name", "用户名", 1));
        columns.add(new TemplateColumn("workNum", "工号", 2));
        columns.add(new TemplateColumn("fullName", "姓名", 3));
        columns.add(new TemplateColumn("position", "职务", 4));
        columns.add(new TemplateColumn("orgFullName", "所在部门", 5));
//        columns.add(new TemplateColumn("orgCode", "所在部门编码", 7));
        columns.add(new TemplateColumn("mobile", "手机号", 6));
        columns.add(new TemplateColumn("email", "邮箱", 7));
//        columns.add(new TemplateColumn("wechat", "微信号", 10));
//        columns.add(new TemplateColumn("validDaysStr", "有效期", 11));
        columns.add(new TemplateColumn("enabledState", "用户状态", 8));
        columns.add(new TemplateColumn("createTimeStr", "创建时间", 9));
        columns.add(new TemplateColumn("expiredTimeStr", "有效期截止时间", 10));
        template.setColumns(columns);
        template.setFileName(fileNamePattern + DateFormatUtils.format(new Date(), "yyyyMMdd") + ".xls");
        template.setBrowserExport(false);
        return template;
    }

    /**
     * 导出实现
     *
     * @param <T>
     */
    class AccountExporter<T> extends ExcelExportor<T> {

        private AccountRangeExportParam param;
        private String fileNamePattern;

        public AccountExporter(Template template, List<T> data, AccountRangeExportParam param, String fileNamePattern) {
            super(template, data);
            this.param = param;
            this.fileNamePattern = fileNamePattern;
        }


        private void beforeRender() {
            Template template = buildTemplate(param, fileNamePattern);
            this.template = template;
            this.data = (List<T>) exportFindRange(param);
        }

        @Override
        public FileInfo render() {
            beforeRender();
            return super.render();
        }
    }

}
