package com.yizhi.system.application.task;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yizhi.system.application.service.LanguageWordService;
import com.yizhi.system.application.vo.domain.LanguageClassify;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.system.application.vo.LanguageVo;

@Component
public class LanguageExport extends AbstractDefaultTask<String, Map<String, Object>> {

	private static final Logger logger = LoggerFactory.getLogger(LanguageExport.class);

	@Autowired
	private LanguageWordService languageWordService;

	@Override
	protected String execute(Map<String, Object> map) {
		Long taskId = (Long) map.get("taskId");
		String serialNo = (String) map.get("serialNo");
		String taskName = (String) map.get("taskName");
		Integer type = (Integer) map.get("type");
		Integer state = (Integer) map.get("state");
		String kwd = (String) map.get("kwd");
		LanguageClassify classify = (LanguageClassify) map.get("classify");
		RequestContext res = (RequestContext) map.get("res");
		Long accountId = res.getAccountId();
		Long companyId = res.getCompanyId();
		Long siteId = res.getSiteId();
		Date submitTime = new Date();
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
		String terminalType = "";
		switch (type) {
		case 0:
			terminalType = "PC";
			break;
		case 1:
			terminalType = "WECHAT";
			break;
		case 2:
			terminalType = "MANAGE";
			break;

		}
		TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
		working(taskContext);
		List<LanguageVo> list = languageWordService.list(classify.getId(), type, state, kwd);
		String sheetName = "【"+terminalType+"】【"+classify.getName()+"】" + "翻译-"+df2.format(submitTime);
		String upLoadUrl = null;
		try {
			XSSFWorkbook wb = new XSSFWorkbook();
			XSSFSheet sheet = wb.createSheet(sheetName);
			XSSFRow row = sheet.createRow((int) 0);
			XSSFCellStyle style = wb.createCellStyle();
			style.setAlignment(HorizontalAlignment.CENTER); // 创建一个居中格式
			CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 3); // 起始行, 终止行, 起始列, 终止列
			sheet.addMergedRegion(cra);
			XSSFCell cell = row.createCell(0);
			cell.setCellValue(sheetName);
			cell.setCellStyle(style);
			XSSFRow row2 = sheet.createRow((int) 1);
			row2.createCell(0).setCellValue("Key值");
			row2.createCell(1).setCellValue("中文字段");
			row2.createCell(2).setCellValue("翻译");
			row2.createCell(3).setCellValue("备注");
			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			if (CollectionUtils.isNotEmpty(list)) {
				LanguageVo rscv = null;
				for (int i = 0; i < list.size(); i++) {
					row = sheet.createRow(i + 2);
					rscv = list.get(i);
					// 第四步，创建单元格，并设置值
					row.createCell(0).setCellValue(rscv.getKey());
					row.createCell(1).setCellValue(rscv.getChinese());
					row.createCell(2).setCellValue(rscv.getValue());
					row.createCell(3).setCellValue(rscv.getDescription());
				}
			}
			String fileName = sheetName + ".xlsx";
			String requestPath = FileConstant.SAVE_PATH;
			File fileDir = new File(requestPath);
			if (!fileDir.exists()) {
				fileDir.mkdir();
			}
			String path = requestPath + File.separator + fileName;
			FileOutputStream os = null;
			File file = null;
			try {
				os = new FileOutputStream(path);
				wb.write(os);
				// 阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file = new File(path);
				success(taskContext, "成功", upLoadUrl);
			} catch (Exception e1) {
				e1.printStackTrace();
				fail(taskContext, "写入过程中发生错误");
				logger.error("上传过程中发生错误，请查看日志");
			} finally {
				if (os != null) {
					os.close();
				}
				if (wb != null) {
					wb.close();
				}
				if (file != null) {
					file.delete();
				}
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(taskContext, sheetName + "导出过程中发生错误，请查看日志" + e.getMessage());
			logger.error(sheetName + "导出过程中发生错误，请查看日志");
		}
		return upLoadUrl;
	}
}
