package com.yizhi.system.application.task;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.service.LanguageTranslationService;
import com.yizhi.system.application.service.LanguageWordService;
import com.yizhi.system.application.vo.LanguageVo;
import com.yizhi.system.application.vo.domain.LanguageClassify;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Component
public class LanguageImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageImport.class);
    
    @Autowired
    private LanguageWordService languageWordService;
    
    @Autowired
    private LanguageTranslationService languageTranslationService;
    
    @Autowired
    private IdGenerator idGenerator;
    
    @Autowired
    private LanguageUpload languageUpload;
	@Override
	protected String execute(Map<String, Object> map) {
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        String ossUrl = (String) map.get("url");
        Integer type = (Integer) map.get("type");
        LanguageClassify classify = (LanguageClassify) map.get("classify");
        URL url = null;
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        Workbook book = null;
        
        RequestContext res = (RequestContext) map.get("res");
        Long accountId = res.getAccountId();
        Long companyId = res.getCompanyId();
        Long siteId = res.getSiteId();
        Date submitTime = new Date();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);
        List<LanguageVo> list = new ArrayList<LanguageVo>();
        LanguageVo vo = null;
        List<Integer> errorList = new ArrayList<>();
        List<String> errors = new ArrayList<String>();
        try {
            //解析url
            String fileName = ossUrl.substring(ossUrl.lastIndexOf("/") + 1);
            String ossUrlPrefix = ossUrl.substring(0, ossUrl.lastIndexOf("/") + 1);
            ossUrl = ossUrlPrefix + URLEncoder.encode(fileName, "utf-8");

            url = new URL(ossUrl);
            conn = (HttpURLConnection) url.openConnection();
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            book = WorkbookFactory.create(inputStream);
        } catch (MalformedURLException e) {
            LOGGER.error("创建ossurl 连接错误", e);
            fail(taskContext, "创建ossurl 连接错误");
        } catch (IOException e) {
            LOGGER.error("创建ossurl 连接错误", e);
            fail(taskContext, "创建ossurl 连接错误");
        } catch (InvalidFormatException e) {
            LOGGER.error("创建Workbook 对象错误", e);
            fail(taskContext, "创建ossurl 连接错误");
        }
        try {
            if (null == book) {
                fail(taskContext, "创建Workbook 对象失败");
            }
            Sheet sheet = book.getSheetAt(0);
            Row row;
            Cell cell0;
            Cell cell1;
            Cell cell2;
            Cell cell3;
            int lastRowNum = sheet.getLastRowNum();
            //获取每行值
            if (lastRowNum > 0) {
                for (int i = 0; i < lastRowNum; i++) {
                    String key = null;
                    String chinese = null;
                    String value = null;
                    String description = null;
                    row = sheet.getRow(i + 1);
                    if (null != row) {
                        cell0 = row.getCell(0);
                        cell1 = row.getCell(1);
                        cell2 = row.getCell(2);
                        cell3 = row.getCell(3);
                        if (null != cell0) {

                            if (cell0.getCellTypeEnum().equals(CellType.STRING)) {
                            	key = cell0.getStringCellValue();
                            } else if (cell0.getCellTypeEnum().equals(CellType.NUMERIC)) {
                                cell0.setCellType(CellType.STRING);
                                key = cell0.getStringCellValue();
                            }
                        }else {
                            errorList.add(i + 2);
                            errors.add("Key值为空");
						}
                        if (null != cell1) {
                            if (cell1.getCellTypeEnum().equals(CellType.STRING)) {
                            	chinese = cell1.getStringCellValue();
                            } else if (cell1.getCellTypeEnum().equals(CellType.NUMERIC)) {
                            	cell1.setCellType(CellType.STRING);
                            	chinese = cell1.getStringCellValue();
                            }   
                        }
                        if (null != cell2) {
                            if (cell2.getCellTypeEnum().equals(CellType.STRING)) {
                            	value = cell2.getStringCellValue();
                            } else if (cell2.getCellTypeEnum().equals(CellType.NUMERIC)) {
                                cell2.setCellType(CellType.STRING);
                                value = cell2.getStringCellValue();
                            }
                        }
                        if (null != cell3) {
                            if (cell3.getCellTypeEnum().equals(CellType.STRING)) {
                            	description = cell3.getStringCellValue();
                            } else if (cell3.getCellTypeEnum().equals(CellType.NUMERIC)) {
                                cell3.setCellType(CellType.STRING);
                                description = cell3.getStringCellValue();
                            }
                        }
                        if (null != key) {
                        	Boolean b = languageWordService.checkKey(key, type);
                        	if (b) {
                            	vo = new LanguageVo();
                            	vo.setKey(key);
                            	vo.setChinese(chinese);
                            	vo.setDescription(description);
                            	vo.setValue(value);
                            	list.add(vo);
							}else {
	                            errorList.add(i + 2);
	                            errors.add("Key值:"+key+"已存在");
							}
                        } else {
                            errorList.add(i + 2);
                            errors.add("Key值为空");
                        }
                    }
                }
            } else {
                success(taskContext, "执行成功,未检索到数据", "");
            }
            //建立对象,批量插入翻译字段
            List<com.yizhi.system.application.domain.LanguageWord> words = new ArrayList<>();
            List<com.yizhi.system.application.domain.LanguageTranslation> translations = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(list)) {
                for (LanguageVo rowVO1 : list) {
                	com.yizhi.system.application.domain.LanguageWord word = new com.yizhi.system.application.domain.LanguageWord();
	                com.yizhi.system.application.domain.LanguageTranslation translation = new com.yizhi.system.application.domain.LanguageTranslation();
                	word.setKey(rowVO1.getKey());
                	word.setType(type);
	                com.yizhi.system.application.domain.LanguageWord one = languageWordService.selectOne(new EntityWrapper<com.yizhi.system.application.domain.LanguageWord>(word));
                	if (one!=null) {
						one.setUpdateById(accountId);
						one.setUpdateByName(res.getAccountName());
						one.setUpdateTime(submitTime);
					}else {
						one = new com.yizhi.system.application.domain.LanguageWord();
						one.setId(idGenerator.generate());
						one.setKey(rowVO1.getKey());
						one.setCreateById(accountId);
						one.setCreateByName(res.getAccountName());
						one.setCreateTime(submitTime);
					}
                	if (rowVO1.getChinese()!=null) {
						one.setChinese(rowVO1.getChinese());
					}
                	if (rowVO1.getDescription()!=null) {
						one.setDescription(rowVO1.getDescription());
					}
                	if (rowVO1.getValue()!=null) {
						translation.setClassifyId(classify.getId());
						translation.setWordId(one.getId());
		                com.yizhi.system.application.domain.LanguageTranslation one2 = languageTranslationService.selectOne(new EntityWrapper<com.yizhi.system.application.domain.LanguageTranslation>(translation));
						if (one2!=null) {
							one2.setUpdateById(accountId);
							one2.setUpdateByName(res.getAccountName());
							one2.setUpdateTime(submitTime);
						}else {
							one2 = new com.yizhi.system.application.domain.LanguageTranslation();
							one2.setId(idGenerator.generate());
							one2.setClassifyId(classify.getId());
							one2.setWordId(one.getId());
							one2.setCreateById(accountId);
							one2.setCreateByName(res.getAccountName());
							one2.setCreateTime(submitTime);
						}
						one.setState(1);
						one2.setValue(rowVO1.getValue());
						translations.add(one2);
					}
                	words.add(one);
                }
            }
            boolean isOk = false;
            try {
				isOk = languageWordService.insertOrUpdateBatch(words);
				languageTranslationService.insertOrUpdateBatch(translations);
			} catch (Exception e) {
				e.printStackTrace();
			}
            if (isOk) {
                Integer n = words.size();
                if (CollectionUtils.isNotEmpty(errorList) && (CollectionUtils.isNotEmpty(errors))) {
                    success(taskContext, "成功导入" + n + "条,第" + errorList.toString() +"行"+ errors.toString(), "");
                }else if (CollectionUtils.isEmpty(errorList)&& CollectionUtils.isEmpty(errors)) {
                    success(taskContext, "成功导入" + n + "条,失败0条", "");
                }
            } else {
                if (CollectionUtils.isNotEmpty(errorList) && (CollectionUtils.isNotEmpty(errors))) {
                    fail(taskContext, "成功导入" + 0 + "条,第" + errorList.toString()+"行"+ errors.toString());
                } else if (CollectionUtils.isEmpty(errorList) && CollectionUtils.isEmpty(errors)) {
                    fail(taskContext, "成功导入0条,未检索到相关数据 ");
                }
            }
        } catch (Exception e1) {
            LOGGER.error("翻译导入过程出现错误:", e1);
            fail(taskContext, "翻译导入过程出现错误");
        }
        languageUpload.execute(map, true);
        return "ok";
	}

}
