package com.yizhi.system.application.task;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yizhi.system.application.service.IOrganizationService;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.system.application.service.OrgExportService;
import com.yizhi.system.application.vo.OrgExportVO;

@Component
public class OrgExportAsy extends AbstractDefaultTask<String, Map<String,Object>> {
	
    private static final Logger logger = LoggerFactory.getLogger(OrgExportAsy.class);

	@Autowired
	private OrgExportService orgExportService;
	
    @Autowired
    private IOrganizationService organizationService;
    
	@Override
	protected String execute(Map<String, Object> arg0) {
		Long accountId=(Long) arg0.get("accountId");
		Long siteId=(Long) arg0.get("siteId");
		Long companyId=(Long) arg0.get("companyId");
		Long taskId=(Long) arg0.get("taskId");
		Date submitTime=(Date) arg0.get("submitTime");
		String serialNo=(String) arg0.get("serialNo");
		String taskName=(String) arg0.get("taskName");
		Long orgId= (Long) arg0.get("orgId");
		String orgName=(String) arg0.get("orgName");
		/**
		 * 走异步任务
		 */
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
		working(taskContext);		
		String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		File fileDir=new File(requestPath);
		if(!fileDir.exists()) {
			fileDir.mkdir();
		}	
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 	
		SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss"); 	 
		List<OrgExportVO> listVO = orgExportService.orgExport(companyId, orgId);
		OrgExportVO vo=new OrgExportVO();
		try {
			//excel生成过程: excel-->sheet-->row-->cell
			// 第一步，创建一个Excel文件
			XSSFWorkbook wb = new XSSFWorkbook();
			// 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
			XSSFSheet sheet = wb.createSheet(orgName);
			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			XSSFRow row = sheet.createRow((int) 0);
			row.setHeight((short) (20*20));
			// 第四步，创建单元格
			row.createCell((short) 0).setCellValue("部门编码"); 
			row.createCell((short) 1).setCellValue("部门名称"); 
			row.createCell((short) 2).setCellValue("用户数"); 
			row.createCell((short) 3).setCellValue("启用用户数"); 
			row.createCell((short) 4).setCellValue("停用用户数"); 
			row.createCell((short) 5).setCellValue("直属上级部门编码"); 
			row.createCell((short) 6).setCellValue("直属上级部门名称"); 
			row.createCell((short) 7).setCellValue("上级部门"); 
			
				for(int i=0;i<listVO.size();i++) {
					row = sheet.createRow(i + 1);
					row.setHeight((short) (13*20));
					// 第四步，创建单元格，并设置值
					vo=listVO.get(i);
					if(vo!=null&&vo.getOrgCode()!=null) {
						row.createCell((short) 0).setCellValue(vo.getOrgCode());
					}
					if(vo!=null&&vo.getOrgName()!=null) {
						row.createCell((short) 1).setCellValue(vo.getOrgName());
					}				
					if(vo!=null&&vo.getUserSumNum()!=null) {
						row.createCell((short) 2).setCellValue(vo.getUserSumNum());
					}				
					if(vo!=null&&vo.getEnableUserNum()!=null) {
						row.createCell((short) 3).setCellValue(vo.getEnableUserNum());
					}
					if(vo!=null&&vo.getStopUserNum()!=null) {
							row.createCell((short) 4).setCellValue(vo.getStopUserNum());
					}					
					if(vo!=null&&vo.getParentCode()!=null) {
					    row.createCell((short) 5).setCellValue(vo.getParentCode());
					}
					if (vo!=null&&vo.getParentName()!=null) {
							    row.createCell((short) 6).setCellValue(vo.getParentName());
					}
					if (vo!=null&&vo.getUpName()!=null) {
					    row.createCell((short) 7).setCellValue(vo.getUpName());
			}
				}	
				
			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			StringBuffer fileNameSb = new StringBuffer().append(orgName+"_组织架构信息_").append(sf.format(submitTime)).append(".xlsx");
			String fileName = fileNameSb.toString();
			String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
			FileOutputStream os=null;
			File file=null;
			try {
				os= new FileOutputStream(path);
				wb.write(os);
				//阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file=new File(path);
				success(taskContext,"成功", upLoadUrl);
			} catch (Exception e1) {
				e1.printStackTrace();
				fail(taskContext, "写入数据到Excel的过程中或者上传到阿里云中发生错误"+e1.getMessage());
				logger.error("写入数据到Excel的过程中或者上传到阿里云中发生错误"+e1.getMessage());	
			}
			finally {
				if(os!=null) {
				   os.close();
				}
				if(wb!=null) {
				   wb.close();
				}
				if(file!=null) {
				   file.delete();
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(taskContext, "评论信息导出过程中发生错误，请查看日志"+e.getMessage());	
			logger.error("评论信息导出过程中发生错误，请查看日志"+e.getMessage());
		}
		return upLoadUrl;
	}

}
