package com.yizhi.system.application.util;

import com.yizhi.system.application.domain.Organization;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/8/20 14:29
 */
public class OrgIndexUtil {

    /**
     * 获取交集
     *
     * @param organizations
     * @return
     */
    public static List<RightLeftIndex> getChildrenRange(Collection<Organization> organizations) {
        if (CollectionUtils.isNotEmpty(organizations)) {
            List<RightLeftIndex> list = new ArrayList<>(organizations.size());
            RightLeftIndex index = null;
            for (Organization organization : organizations) {
                if (organization.getDeleted()) {
                    continue;
                }
                index = new RightLeftIndex(organization.getLeftIndex(), organization.getRightIndex());
                add(list, index, 1);
            }
            return list;
        }
        return null;
    }

    /**
     * 获取并集
     *
     * @param organizations
     * @return
     */
    public static List<RightLeftIndex> getParentsRange(Collection<Organization> organizations) {
        if (CollectionUtils.isNotEmpty(organizations)) {
            List<RightLeftIndex> list = new ArrayList<>(organizations.size());
            RightLeftIndex index = null;
            for (Organization organization : organizations) {
                if (organization.getDeleted()) {
                    continue;
                }
                index = new RightLeftIndex(organization.getLeftIndex(), organization.getRightIndex());
                add(list, index, 2);
            }
            return list;
        }
        return null;
    }

    /**
     * @param list
     * @param index
     * @param type  1:child
     *              2:parent
     */
    private static void add(List<RightLeftIndex> list, RightLeftIndex index, int type) {
        if (CollectionUtils.isEmpty(list)) {
            list.add(index);
            return;
        }
        /**
         * 1:不相交
         * 2：被包含于其中的某一个范围
         * 3：包含其中的某一个范围
         */
        int operation = -1;
        int j = -1;
        for (int i = 0; i < list.size(); i++) {
            j = i;
            // 1:不相交
            if (index.getLeft() > list.get(i).getRight() || index.getRight() < list.get(i).getLeft()) {
                operation = 1;
            }
            // 2：index被包含于list其中的某一个范围
            else if (index.getLeft() > list.get(i).getLeft() && index.getRight() < list.get(i).getRight()) {
                operation = 2;
                break;
            }
            // 3：index包含list其中的某一个范围
            else if (index.getLeft() < list.get(i).getLeft() && index.getRight() > list.get(i).getRight()) {
                operation = 3;
                break;
            }
        }

        if (operation == 1) {
            list.add(index);
        } else if (operation == 2) {
            if (type == 1) {
                list.remove(j);
                list.add(index);
            }
        } else if (operation == 3) {
            if (type == 2) {
                list.remove(j);
                list.add(index);
            }
        }
    }

}
