package com.yizhi.system.application.util;

import com.yizhi.util.application.security.Md5HexMethod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class SignUtil {

    private static Logger logger = LoggerFactory.getLogger(SignUtil.class);

    /**
     * 生成微信支付sign
     *
     * @param params(可排序)
     * @param key
     * @return
     */
    public static String createSign(SortedMap<String, String> params, String key) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        Map.Entry<String, String> entry = null;
        String k = null;
        String v = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            k = entry.getKey();
            v = entry.getValue();
            //如果参数的值为空则不参与签名
            if (StringUtils.isNotBlank(v)) {
                if ("sign".equals(k) || "key".equals(k)) {
                    continue;
                }
                stringBuilder.append(k).append("=").append(v).append("&");
            }
        }
        //拼接API密钥：
        String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
        String sign = Md5HexMethod.md5EncodeCopy(substring).toUpperCase();
        return sign;
    }

    /**
     * 校验签名
     * key = salt+当前日期（yyyyMMdd）
     * 创建签名规则为 account=value&password=value&salt=value&key=value
     * 注意参数顺序不能变
     *
     * @param params
     * @param key
     * @return
     */
    public static boolean isCorrectSign(SortedMap<String, String> params, String key) {
        String sign = createSign(params, key);
        logger.info("生成签名：" + sign);
        //拼接API密钥：
        String weixinPaySign = params.get("sign").toUpperCase();
        return weixinPaySign.equals(sign);
    }

    public static void main(String[] args) {
        SortedMap<String, String> map = new TreeMap<String, String>();
        map.put("sign", "aea9941b32019196d3edb819546f2861");
        map.put("account", "04bad8204c68c97303d695f92d8f1968dd899e015c4d69b68b03fed09d1123d65ba637657fec5e53534877cdee5068f88641d4522df5f7565509ba1a2e812e639a6af8b5ab40bea00e313e7fa230df992944944e7aa43410d0443340374a26e2573a92c1acc8562e3639eab8464dbb795496f61b7bd7");
        map.put("password", "04711bfaad2b9eb232798f6f47ffb20a402c8959cb87d843cafa9daa9ead21f70c863a81d2610041c68a0fbe0579c0fae8c0a09985367e91c3d388f8f4f2f3d3d0d8592fe617c1b3d5ff6824fdf1e2e08a64ac21606acf3b30e8cfc44677cc00b09ba7f8b1a147fddf8be6c5573f6e478ff649a6e4f43a");
        map.put("salt", "NP2TJ32E4IOZXSW2");
        map.put("key", "NP2TJ32E4IOZXSW220200831");
        boolean correctSign = SignUtil.isCorrectSign(map, map.get("key"));
        System.out.println("correctSign:" + correctSign);
    }
}
