CREATE DEFINER=`root`@`localhost` PROCEDURE `authz`()
BEGIN

	-- 迁移
	declare m_id varchar(100) character set utf8;
	declare m_name varchar(100) character set utf8;
	declare m_code varchar(100) character set utf8;
	declare m_url varchar(100) character set utf8;
	declare m_description varchar(100) character set utf8;
	declare m_parent_id varchar(100) character set utf8;
	declare m_parent_id_layer varchar(100) character set utf8;
	declare m_type varchar(100) character set utf8;
	declare m_operation_menu varchar(100) character set utf8;
	declare m_default_site_only varchar(100) character set utf8;
	declare m_has_resource varchar(100) character set utf8;
	declare m_enabled varchar(100) character set utf8;
	declare m_sort varchar(100) character set utf8;
	declare m_company_id varchar(100) character set utf8;
	declare m_site_id varchar(100) character set utf8;
	declare m_create_by_id varchar(100) character set utf8;
	declare m_create_by_name varchar(100) character set utf8;
	declare m_create_time varchar(100) character set utf8;
	declare m_update_by_id varchar(100) character set utf8;
	declare m_update_by_name varchar(100) character set utf8;
	declare m_update_time varchar(100) character set utf8;
	
	declare done int default false;
	
	declare menu_cur cursor for
		( SELECT
			id,
			NAME,
			CODE,
			( SELECT url FROM operation WHERE operation.id = module.id ) AS url,
			description,
			parent_id,
			NULL AS parent_id_layer,
			type,
			operation_module AS operation_menu,
			( SELECT default_site_only FROM operation WHERE operation.id = module.id ) AS default_site_only,
			1 as has_resource,
			enabled,
			NULL AS sort,
			company_id,
			site_id,
			create_by_id,
			create_by_name,
			create_time,
			update_by_id,
			update_by_name,
			update_time 
			FROM
				module 
			) UNION
			(
			SELECT
				id,
				`name`,
				NULL AS CODE,
				url,
				NAME,
				parent_id,
				NULL AS parent_id_layer,
				1 AS type,
				operation_menu,
				default_site_only,
				0 as has_resource,
				enabled,
				NULL AS sort,
				NULL AS company_id,
				NULL AS site_id,
				NULL AS create_by_id,
				NULL AS create_by_name,
				NULL AS create_time,
				NULL AS update_by_id,
				NULL AS update_by_name,
				NULL AS update_time 
			FROM
				operation 
			WHERE
				type = 'm' 
			AND id IN ( 121, 122, 211, 212, 213, 451, 452, 453, 491, 492 ) 
			);
		
	declare continue handler for not found set done = true;
	
	-- 创建临时表
	DROP TABLE IF EXISTS `authz_menu_tmp`;
	CREATE TABLE `authz_menu_tmp` (
		`id` bigint(20) NOT NULL,
		`name` varchar(255) NOT NULL COMMENT '名称',
		`code` varchar(45) DEFAULT NULL COMMENT '对应功能模块code',
		`url` varchar(100) DEFAULT NULL COMMENT '前端对应路由',
		`description` varchar(255) DEFAULT NULL COMMENT '描述',
		`if_public` TINYINT(1) DEFAULT NULL COMMENT '是否不需要权限',
		`parent_id` bigint(20) DEFAULT '0' COMMENT '父菜单id，顶层节点为0',
		`parent_id_layer` varchar(255) DEFAULT NULL COMMENT '父菜单层级，顶层为自身',
		`type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '归属类型：1通用（全平台），默认；2企业（下所有站点），3站点',
		`operation_menu` tinyint(1) NOT NULL COMMENT '是否是运营菜单',
		`default_site_only` tinyint(1) NOT NULL DEFAULT '0' COMMENT '默认站点有效（其他附属站点无效）',
		`has_resource` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可以被资源归属',
		`enabled` tinyint(1) NOT NULL COMMENT '是否启用',
		`sort` int(11) DEFAULT NULL COMMENT '排序',
		`company_id` bigint(20) DEFAULT NULL COMMENT '所属企业id',
		`site_id` bigint(20) DEFAULT NULL COMMENT '所属站点id',
		`create_by_id` bigint(20) DEFAULT NULL COMMENT '创建者id',
		`create_by_name` varchar(30) DEFAULT NULL COMMENT '创建者名称',
		`create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
		`update_by_id` bigint(20) DEFAULT NULL COMMENT '更新者id',
		`update_by_name` varchar(30) DEFAULT NULL COMMENT '修改者名称',
		`update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
		PRIMARY KEY (`id`) USING BTREE
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='菜单';

	-- 菜单迁移 开始
	open menu_cur;
	menu_read_loop: loop
		fetch menu_cur into m_id, m_name, m_code, m_url, m_description, m_parent_id, m_parent_id_layer, m_type, m_operation_menu, m_default_site_only, m_has_resource, m_enabled, m_sort, m_company_id, m_site_id, m_create_by_id,
		m_create_by_name, m_create_time, m_update_by_id, m_update_by_name, m_update_time;
		if done then
			leave menu_read_loop;
		end if;
		insert into authz_menu_tmp values (m_id, m_name, m_code, m_url, m_description, null, m_parent_id, m_parent_id_layer, m_type, m_operation_menu, m_default_site_only, m_has_resource, m_enabled, m_sort, m_company_id, m_site_id, m_create_by_id,
		m_create_by_name, m_create_time, m_update_by_id, m_update_by_name, m_update_time);
		
	end loop;
	close menu_cur;
	update authz_menu_tmp set has_resource = 1 where id not in ( 121, 122, 211, 212, 213, 451, 452, 453, 491, 492 );
	update authz_menu_tmp set has_resource = 0 where id in ( 121, 122, 211, 212, 213, 451, 452, 453, 491, 492 );
	-- 菜单迁移 结束
	
	-- 删除旧菜单 开始
	delete from operation where type = 'M';
	-- 删除旧菜单 结束
	
	ALTER TABLE `cloud_system`.`account_role` 
	RENAME TO  `cloud_system`.`authz_account_role` ;

	ALTER TABLE `cloud_system`.`group_member` 
	RENAME TO  `cloud_system`.`authz_group_member` ;

 	ALTER TABLE `cloud_system`.`authz_menu_tmp` 
 	COMMENT = '菜单' , RENAME TO  `cloud_system`.`authz_menu` ;
-- 	ALTER TABLE `cloud_system`.`module` 
-- 	COMMENT = '菜单' , RENAME TO  `cloud_system`.`authz_menu` ;
-- 	ALTER TABLE `cloud_system`.`authz_menu` 
-- -- 	CHANGE COLUMN `type` `belong_type` TINYINT(1) NOT NULL DEFAULT '1' COMMENT '归属类型：1通用（全平台），默认；2企业（下所有站点），3站点' ,
-- 	ADD COLUMN `if_public` TINYINT(1) NULL DEFAULT NULL COMMENT '是否不需要权限' AFTER `description`,
-- 	ADD COLUMN `parent_id_layer` VARCHAR(255) NOT NULL COMMENT '顶级菜单 id 到该菜单 id 的集合，逗号分隔，顶级菜单为自身 id' AFTER `parent_id`,
-- 	ADD COLUMN `operation_menu` TINYINT(1) NOT NULL COMMENT '是否是运营菜单' AFTER `type`,
-- 	ADD COLUMN `default_site_only` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '默认站点有效（其他附属站点无效）' AFTER `operation_menu`,
-- 	ADD COLUMN `has_resource` TINYINT(1) NULL DEFAULT 0 COMMENT '是否可以被资源归属' AFTER `default_site_only`,
-- 	ADD COLUMN `url` VARCHAR(255) NULL COMMENT '前端路由' AFTER `has_resource`,
-- 	ADD COLUMN `sort` INT NULL COMMENT '排序' AFTER `url`;

	ALTER TABLE `cloud_system`.`module_operation` 
	CHANGE COLUMN `operation_id` `resource_id` BIGINT(20) NOT NULL COMMENT '资源id',
	COMMENT = '菜单资源（操作）关联表，物理删除' , RENAME TO  `cloud_system`.`authz_menu_resource` ;

	ALTER TABLE `cloud_system`.`operation` 
	CHANGE COLUMN `type` `type` CHAR(1) NOT NULL COMMENT '资源类型（P：页面，B：按钮）' , 
	COMMENT = '资源表' , RENAME TO  `cloud_system`.`authz_resource` ;
	
	ALTER TABLE `cloud_system`.`authz_resource` 
    DROP COLUMN `operation_menu`;

	ALTER TABLE `cloud_system`.`role` 
	RENAME TO  `cloud_system`.`authz_role` ;

	ALTER TABLE `cloud_system`.`role_module` 
	CHANGE COLUMN `module_id` `menu_id` BIGINT(20) NOT NULL COMMENT '菜单id' , RENAME TO  `cloud_system`.`authz_role_menu` ;

	ALTER TABLE `cloud_system`.`role_user_group` 
	RENAME TO  `cloud_system`.`authz_role_user_group` ;

	ALTER TABLE `cloud_system`.`user_group` 
	RENAME TO  `cloud_system`.`authz_user_group` ;
	
	ALTER TABLE `cloud_system`.`authz_menu_resource` 
    CHANGE COLUMN `module_id` `menu_id` BIGINT(20) NOT NULL COMMENT '菜单id' ;
	
	ALTER TABLE `cloud_system`.`authz_resource` 
    CHANGE COLUMN `enabled` `status` TINYINT(1) NOT NULL COMMENT '0-待处理、1-有效、2-无效' ;
	
	-- ALTER TABLE `cloud_system`.`authz_menu` 
 --    DROP COLUMN `operation_module`;

    ALTER TABLE `cloud_system`.`authz_resource` 
    DROP COLUMN `default_site_only`;
		
	ALTER TABLE `cloud_system`.`authz_resource` 
    DROP COLUMN `sort`,
    DROP COLUMN `public`;
	
	ALTER TABLE `cloud_system`.`authz_resource` 
    ADD COLUMN `module_code` VARCHAR(45) NULL COMMENT '模块编码' AFTER `name`;




	CREATE TABLE `cloud_system`.`authz_role_manager`  (
	  `id` bigint(20) NOT NULL COMMENT '主键 id',
	  `role_id` bigint(20) NOT NULL COMMENT '角色 id',
	  `manager_account_id` bigint(20) NOT NULL COMMENT '被管理的管理员的用户 id',
	  PRIMARY KEY (`id`) USING BTREE
	) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分级授权关联表，该角色可管理以下管理员的业务数据' ROW_FORMAT = Dynamic;
	


END