package com.yizhi.application.service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.system.application.SystemApplication;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.controller.manage.GroupController;
import com.yizhi.system.application.controller.remote.CompanyStructureSchedulerController;
import com.yizhi.system.application.controller.remote.RemoteAccountRangeController;
import com.yizhi.system.application.controller.remote.ReportAccountController;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.system.application.mapper.AuthzGroupMemberMapper;
import com.yizhi.system.application.mapper.AuthzRoleMapper;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;

/**
 * @Author: shengchenglong
 * @Date: 2018/6/6 10:07
 */
@SpringBootTest(classes = SystemApplication.class)
@RunWith(SpringRunner.class)
public class AutheTest extends BaseTest {

    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private OrganizationIndexService organizationIndexService;
    @Autowired
    private CompanyStructureSchedulerController companyStructureSchedulerController;
    @Autowired
    private IAuthzRoleService roleService;
    @Autowired
    private OrganizationCacheService organizationCacheService;
    @Autowired
    private IAuthzUserGroupService groupService;
    @Autowired
    private AuthzGroupMemberMapper groupMemberMapper;
    @Autowired
    private AuthService authService;
    @Autowired
    private RemoteAccountRangeController remoteAccountRangeController;
    @Autowired
    private IAccountService accountService;
    @Autowired
    private ReportAccountController reportAccountController;
    @Autowired
    private GroupController groupController;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private AuthzRoleMapper authzRoleMapper;
    @Autowired
    private TokenHelper tokenHelper;

    /**
     * 初始化部门层级数据
     */
    @Test
    public void initParentIdLayer() {

        List<Organization> orgs = new ArrayList<>();
        List<Long> parentIds = new ArrayList<>();
        Map<Long, String> parentIdLayerMap = new HashMap<>();

        int layer = 0;


        Organization organization = new Organization();
        organization.setParentId(0L);
        List<Organization> organizations = organizationService.selectList(new EntityWrapper<>(organization));
        for (Organization parent : organizations) {
            parent.setRootId(0L);
            parent.setParentIdLayer(String.valueOf(parent.getId()));
            parent.setLayer(layer);
            parentIdLayerMap.put(parent.getId(), parent.getParentIdLayer());
            orgs.add(parent);
            parentIds.add(parent.getId());
        }
        recycle(parentIds, parentIdLayerMap, orgs, layer);

        System.out.println(orgs.size() + "------------------------------------------------------------------");
        for (Organization o : orgs) {
            o.updateById();
        }
    }

    private void recycle(List<Long> parentIds, Map<Long, String> parentIdLayerMap, List<Organization> orgs, int layer) {
        if (CollectionUtils.isNotEmpty(parentIds)) {
            EntityWrapper<Organization> ew = new EntityWrapper<>();
            ew.in("parent_id", parentIds);
            List<Organization> organizations = organizationService.selectList(ew);
            parentIds = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(organizations)) {
                layer++;
                for (Organization parent : organizations) {
                    parent.setParentIdLayer(parentIdLayerMap.get(parent.getParentId()) + "_" + parent.getId());
                    parent.setLayer(layer);
                    parent.setRootId(Long.valueOf(parent.getParentIdLayer().split("_")[0]));
                    parentIdLayerMap.put(parent.getId(), parent.getParentIdLayer());
                    orgs.add(parent);
                    parentIds.add(parent.getId());
                }
                recycle(parentIds, parentIdLayerMap, orgs, layer);
            }
        }
    }

    @Test
    public void initRightLeft() throws Exception {
//        Company company = new Company();
//        List<Company> companies = company.selectAll();
//        if (CollectionUtils.isNotEmpty(companies)) {
//            for (Company c : companies) {
//                organizationIndexService.initLeftRight(c.getId());
////                organizationCacheService.cacheCompany(c);
//            }
//        }


//        Company company = new Company();
//        company.setId(1016616562213662720L);
//        company = company.selectById();
//        organizationCacheService.cacheCompanyOrganization(company);

        organizationIndexService.initLeftRight(1068470062850605056L);


    }

    @Test
    public void buildCompanyStructure() throws Exception {
        companyStructureSchedulerController.buildCompanyStructure();
    }

    @Test
    public void remoteAccountRangeImportController() throws Exception {
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setOssUrl("https://fulan-test.oss-cn-hangzhou.aliyuncs.com/test/jml子站点_用户信息_20190428.xls");
        param.setType(AccountRangeImportParam.Type.TRAININGPROJECT);
        param.setRequestContext(this.getRequestContext("shyz", "shyz", "shyz", "/manage/tpClassification/list"));
        remoteAccountRangeController.doImport(param);

    }


    @Test
    public void test() throws IOException {
//        List<Long> list = new ArrayList<>();
//        list.add(1028837025964892160L);
//        roleService.deleteAccountAuthzInfo("shyz", "shyz", list);

        Organization organization = new Organization();
        organization.setDeleted(false);
        organization.setCompanyId(1017606487856005120L);
        List<Organization> organizations = organization.selectList(new EntityWrapper(organization));
        // 部门范围
        Set<Long> orgIds = new HashSet<>();
        // 部门 id ： name(code) map集合
        Map<Long, String> orgNameMap = new HashMap<>();
        Map<Long, String> orgFullNameMap = new HashMap<>();
        Map<Long, String> orgCodeMap = new HashMap<>();


        for (Organization o : organizations) {
            orgNameMap.put(o.getId(), o.getName());
            orgCodeMap.put(o.getId(), o.getCode());
        }
        // 组装部门全名称
        String[] parentIdLayerArr = null;
        for (Organization o : organizations) {
            parentIdLayerArr = o.getParentIdLayer().split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parentIdLayerArr.length; i++) {
                if (i == 0) {
                    sb.append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                } else {
                    sb.append("+").append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                }
                orgFullNameMap.put(o.getId(), sb.toString());
            }
        }


        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFRow row = null;
        HSSFCell cell = null;
        int index = 0;
        for (Map.Entry entry : orgFullNameMap.entrySet()) {
            row = sheet.createRow(index++);
            cell = row.createCell(1);
            cell.setCellValue(String.valueOf(entry.getKey()));
            cell = row.createCell(2);
            cell.setCellValue(String.valueOf(entry.getValue()));
        }
        wb.write(new FileOutputStream("/aaa.xlsx"));
    }

    @Test
    public void testt() {
//        System.out.println();
//        System.out.println();
//        System.out.println();
//        System.out.println();
//        System.out.println(groupService.getGroupAccountNum(1314L, 1033993582235631616L));

//        Set<Long> ids = authService.AccessSiteIdsFront(1314L, "shyz", 1037151535333478400L);
//        System.out.println(ids);
        AccountRangeExportParam param = new AccountRangeExportParam();
        param.setAccountIds(Arrays.asList(1314L));
        param.setOrgIds(Arrays.asList(1314L));
        param.setBizName("aaa");
        RequestContext context = new RequestContext();
        context.setAccountId(1314L);
        context.setCompanyId(1314L);
        context.setSiteId(1314L);
        param.setContext(context);

        remoteAccountRangeController.doExport(param);
    }


    @Test
    public void tesddt() {
        organizationService.getOrgIdsInSite(1022358462279884800L, "shpd", "lsbdd");
    }

    @Test
    public void testAccount() {
        accountService.listAccountIdByOrgIdAndEnable(1314L, true);
    }

    @Test
    public void testOrg() {
        List<Long> orgIds = new ArrayList<>();
        orgIds.add(379L);
        orgIds.add(380L);
        orgIds.add(381L);
        orgIds.add(1314L);
        organizationService.getParentNameWithCurrentName(orgIds);
    }

    @Test
    public void testReporter() {
//        ReportRangeAccountReqVO vo = new ReportRangeAccountReqVO();
//        vo.setSiteId(1081082376006123520L);
//        reportAccountController.getRangeAccounts(vo);

//        reportAccountController.getRangeAccountCountNum(vo);

        HQAccountInManageParam param = new HQAccountInManageParam();
        param.setModuleType(AuthzConstant.moduleType.statistics_experience);
        param.setSiteId(1314L);
        param.setAccountId(1107947404416708608L);
        reportAccountController.getRangeAccountsInManage(param);
    }

    @Test
    public void testGroup() {
//        int result = groupService.getGroupAccountNum(1016273921756246016L, 1118829892559515648L);
//        System.out.println(result);
//        Account account = accountService.selectById(1314L);
//        System.out.println(account);
//
//        System.out.println(authzRoleMapper.getByAccountId(1314L));
//        Claims claims = tokenHelper.parseToken("eyJ0eXBlIjoiSldUIiwiYWxnIjoiSFMyNTYifQ.eyJpYXQiOjE1OTQ4MDkyNzgsInN1YiI6InNoeXoiLCJpc3MiOiJlbGVhcm4iLCJjb21wYW55Q29kZSI6InNoeXoiLCJhY2NvdW50SWQiOiIxMzE0IiwiY29tcGFueUlkIjoiMTMxNCIsImNvbXBhbnlOYW1lIjoi5LiK5rW35piT55-l5L-h5oGv56eR5oqA6IKh5Lu95pyJ6ZmQ5YWs5Y-4Iiwic2l0ZUlkIjoiMTMxNCIsImV4cCI6MTU5NTQxNDA3OCwibmJmIjoxNTk0ODA5Mjc4fQ.eL7PDdcKesUhI8vdiiFBlCKZcXT-XdP0dRxZEr8Gw9A");
//        System.out.println(claims.get("companyId", String.class));
        Map<String, Object> info = new HashMap<String, Object>();
        info.put(GlobalConstant.ACCOUNT_ID, "26195657961061706");
        info.put(GlobalConstant.COMPANY_CODE, "marykay");
        info.put(GlobalConstant.COMPANY_ID, "1314");
        info.put(GlobalConstant.COMPANY_NAME, "玫琳凯");
        // 添加站点id
        info.put(GlobalConstant.SITE_ID, "1314");
        String token = tokenHelper.createToken("20015113637", info);
        System.out.println(token);

    }

	/*
	 * @Test public void redisTest() {
	 * redisCache.getRedisTemplate().opsForZSet().add(
	 * "queue:task:scheduler:trainingProject", "method1", System.nanoTime());
	 * redisCache.getRedisTemplate().opsForZSet().add(
	 * "queue:task:scheduler:trainingProject", "method2", System.nanoTime());
	 * redisCache.getRedisTemplate().opsForZSet().add(
	 * "queue:task:scheduler:trainingProject", "method3", System.nanoTime()); //
	 * Long score = redisCache.getRedisTemplate().opsForZSet().rank(
	 * "queue:task:scheduler:trainingProject", "method1"); Long size = null; while
	 * ((size = redisCache.getRedisTemplate().opsForZSet().size(
	 * "queue:task:scheduler:trainingProject")) > 0) { System.out.println(size); Set
	 * set = redisCache.getRedisTemplate().opsForZSet().range(
	 * "queue:task:scheduler:trainingProject", 0L, 0L); System.out.println(set);
	 * redisCache.getRedisTemplate().opsForZSet().removeRange(
	 * "queue:task:scheduler:trainingProject", 0L, 0L);
	 * 
	 * }
	 * 
	 * 
	 * }
	 */
}
