package com.yizhi.application.service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.service.ISiteService;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * @Author: shengchenglong
 * @Date: 2018/6/6 10:07
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class BaseTest {

    @Autowired
    private IAccountService accountService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ISiteService siteService;
    @Autowired
    private AuthService authService;

    public RequestContext getRequestContext(String companyCode, String username, String siteCode, String url) throws Exception {

        Company company = new Company();
        company.setCode(companyCode);
        company = company.selectOne(new EntityWrapper(company));
        if (null == company) {
            throw new Exception("未找到企业：" + companyCode);
        }

//        IAccountService accountService = beanFactory.getBean(IAccountService.class);
        Account account = new Account();
        account.setName(username);
        account.setCompanyId(company.getId());
        account = accountService.selectOne(new EntityWrapper<>(account));
        if (null == account) {
            throw new Exception("未找到用户：" + username);
        }

//        ICompanyService companyService = beanFactory.getBean(ICompanyService.class);

//        ISiteService siteService = beanFactory.getBean(ISiteService.class);
        Site site = new Site();
        site.setCode(siteCode);
        site.setCompanyId(company.getId());
        site = siteService.selectOne(new EntityWrapper<>(site));
        if (null == site) {
            throw new Exception("未找到站点：" + siteCode);
        }

//        AuthService authService = beanFactory.getBean(AuthService.class);

        if (authService.AccessSiteIds(company.getId(), account.getId()).contains(site.getId())) {

            AuthAccountSiteModel model = authService.getSiteAutho(company.getCode(), company.getId(), account.getId(), site.getId(), CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS);

            RequestContext context = new RequestContext();
            context.setCompanyId(account.getCompanyId());
            context.setAccountId(account.getId());
            context.setOrgId(account.getOrgId());
            context.setSiteId(site.getId());
            context.setSiteCode(siteCode);
            context.setAccountName(account.getName());
            context.setCompanyId(account.getCompanyId());
            context.setAccountFullName(account.getFullName());
            context.setAdmin(model.getSiteAdmin());
            context.setCompanyCode(company.getCode());
            context.setCompanyName(company.getName());
            if (!model.getSiteAdmin()) {
//                context.setOrgIds(model.getUrlRanges().get(url));
            }
//            context.setRelationIds(model.getRelationIds());
            return context;
        } else {
            throw new Exception("当前用户无权限访问指定站点！！！");
        }
    }

}
