package com.yizhi.util.application.importexcel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.springframework.util.StringUtils;

/**
 * 导入Excel工具类调用excelRead就行
 * @author FanChunhui
 *
 */
 class ExcelUtils {
	
	/**
	 * 利用propertis到obj对象的映射，并将相对应的值设置到obj对象中最后add到list集合中<br>
	 * properties需要符合如下规则：<br>
	 * properties中值得顺序要与Excel中列相相应，否则值会设置错：<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;excel:编号    姓名         年龄       性别<br>
	 * properties:id  name  age  sex<br>
	 * @param file 待解析的excel流
	 * @param properties 与Excel相对应的属性
	 * @param template 判断是否是拥有合并的模板
	 * @return 返回对应数据
	 * @throws Exception
	 */
	static Object excelRead(InputStream content,String[] properties,int template){
		 Workbook book;
		try {
			book = WorkbookFactory.create(content);
			return getExcelContent(book,properties,template);    
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * 将properties相对应的值设置到obj对象中最后add到list集合中<br>
	 * properties需要符合如下规则：<br>
	 * properties中值的顺序要与Excel中列相相应，否则值会设置错：<br>
	 * @param properties 需要参考Object的属性
	 * @return 返回对应实体内容
	 * @throws Exception
	 */
	private static Object getExcelContent(Workbook book, String[] properties,int template){
		List<Object> resultList = new ArrayList<Object>();        //初始化结果
		for(int numSheet = 0 ; numSheet < book.getNumberOfSheets(); numSheet++){  //遍历所有sheet
			Sheet sheet = book.getSheetAt(numSheet);
			if(sheet == null){   //谨防中间空一行
				continue;
			}
			
			for(int numRow = 1; numRow <= sheet.getLastRowNum() ; numRow++){   //一个row就相当于一个Object
				Row row = sheet.getRow(numRow);
				if(row == null){
					continue;
				}else if((template == 1 && numRow < 2) || (template == 2 && numRow < 3)){
					continue;
				}
				try {
					resultList.add(getObject(row,properties,numRow));
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return resultList;
	}
	
	/**
	 *获取row的数据
	 * @param row row对象
	 * @param properties Object参考的属性
	 * @param numRow 错误发生的行数
	 * @return 返回对应数据
	 * @throws Exception
	 */
	private static Object getObject(Row row, String[] properties,int numRow){
		Map<String, String> result = new HashMap<>();
		for(int numCell = 0 ; numCell < row.getLastCellNum(); numCell++){
			try {
				Cell cell = row.getCell(numCell);
				if(cell == null){
					continue;
				}
				String cellValue = getValue(cell);
				System.out.println(cellValue);
				if (!StringUtils.isEmpty(properties[numCell])) {
					String property = properties[numCell].toLowerCase();
					result.put(property, cellValue);
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("错误发生在第：" + (numRow+1) + "行" +"第" + (numCell+1) + "列");
			}
		}
		return result;
	}
	
	/**
	 * 根据类型获取值
	 * @param cell
	 * @return 列值
	 */
	private static String getValue(Cell cell) {  
        if (cell.getCellType() == cell.CELL_TYPE_BOOLEAN) {  
            return String.valueOf(cell.getBooleanCellValue());  
        } else if (cell.getCellType() == cell.CELL_TYPE_NUMERIC) {
            return NumberToTextConverter.toText(cell.getNumericCellValue());  
        } else {  
            return String.valueOf(cell.getStringCellValue());  
        }  
    }  

}
