package com.yizhi.util.application.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @Date 2020/10/27 4:38 下午
 * @Author lvjianhui
 **/
@ApiModel
public class BizPage<T> implements Serializable {

    /**
     * 数据列表
     */
    @ApiModelProperty(value ="分页数据")
    private List<T> records = Collections.emptyList();

    /**
     * 记录总数
     */
    @ApiModelProperty(value ="记录总数")
    private Integer pageRecords;
    /**
     * 总页数
     */
    @ApiModelProperty(value ="总页数")
    private Integer pageTotal;
    /**
     * 当前页
     */
    @ApiModelProperty(value = "当前页")
    private Integer pageNo;
    /**
     * 每页记录数
     */
    @ApiModelProperty(value = "每页记录数")
    private Integer pageSize;

    /**
     * 排序字段
     */
    @ApiModelProperty(value = "排序字段")
    private String pageSortField;
    /**
     * 排序类型:asc升序  desc降序
     */
    @ApiModelProperty(value = "排序类型:asc升序  desc降序")
    private String pageSortType;

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public Integer getPageRecords() {
        return pageRecords;
    }

    public void setPageRecords(Integer pageRecords) {
        this.pageRecords = pageRecords;
    }

    public Integer getPageTotal() {
        return pageTotal;
    }

    public void setPageTotal(Integer pageTotal) {
        this.pageTotal = pageTotal;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageSortField() {
        return pageSortField;
    }

    public void setPageSortField(String pageSortField) {
        this.pageSortField = pageSortField;
    }

    public String getPageSortType() {
        return pageSortType;
    }

    public void setPageSortType(String pageSortType) {
        this.pageSortType = pageSortType;
    }
}
