//package com.yizhi.util.application.sm2;
//
//import java.math.BigInteger;
//import java.security.SecureRandom;
//
//import org.bouncycastle.asn1.gm.GMNamedCurves;
//import org.bouncycastle.asn1.x9.X9ECParameters;
//import org.bouncycastle.asn1.x9.X9ECPoint;
//import org.bouncycastle.crypto.InvalidCipherTextException;
//import org.bouncycastle.crypto.engines.SM2Engine;
//import org.bouncycastle.crypto.engines.SM2Engine.Mode;
//import org.bouncycastle.crypto.params.ECDomainParameters;
//import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
//import org.bouncycastle.crypto.params.ECPublicKeyParameters;
//import org.bouncycastle.crypto.params.ParametersWithRandom;
//import org.bouncycastle.math.ec.ECPoint;
//import org.bouncycastle.util.encoders.Hex;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.stereotype.Component;
//import org.springframework.util.StringUtils;
//
//@Component
//public class SM2Util {
//
//	private static int length = 16;
//	private static X9ECParameters sm2ECParameters = null;
//	private static ECDomainParameters domainParameters = null;
//
//	private static BigInteger privateKeyd = new BigInteger("73606691747902606671812672174006787696677349435601496579172297108691018534217");
//	private static String publicKeyHex = "047214fe3a249b75b6ba92ee494e0a8a68c0a19893a480b3c28bf06cd5b7d621243c7f6704caa3b43ade6be15de11cabd185611a9edfdcf1b11d7a2478c67b4c1c";
//    private static final Logger logger = LoggerFactory.getLogger(SM2Util.class);
//    static {
//    	sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
//    	domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
//    }
//
//    /**
//     * 加密
//     * @param input 明文
//     * @param publicKey 私钥，废弃不用
//     * @return 返回Hex密文
//     */
//    public static String encrypt(String input, ECPoint publicKey) {
//		try {
//			//加密对象
//	    	X9ECPoint localX9ECPoint = new X9ECPoint(sm2ECParameters.getCurve(), Hex.decode(publicKeyHex));
//	    	ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(localX9ECPoint.getPoint(), domainParameters);
//	    	SM2Engine sm2EngineEncrypt = new SM2Engine(Mode.C1C3C2);
//	    	sm2EngineEncrypt.init(true, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));
//
//			byte[] data = input.getBytes();
//			byte[] dataEncrypt = sm2EngineEncrypt.processBlock(data, 0, data.length);
//			String dataEncryptHex = Hex.toHexString(dataEncrypt);
//			return dataEncryptHex;
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//    	return null;
//    }
//
//    /**
//     * 带盐加密
//     * @param input 明文
//     * @param salt 盐
//     * @return 返回Hex密文
//     */
//    public static String encryptWithSalt(String input, String salt) {
//		try {
//			if(input != null && salt != null){
//				input += salt;
//			}
//
//			return encrypt(input, null);
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//    	return null;
//    }
//
//    /**
//     *
//     * @param encryptDataHex SM2 Hex密文
//     * @param privateKey 公钥，废弃不用
//     * @return
//     */
//    public static String decrypt(String encryptDataHex, BigInteger privateKey) {
//		try {
//			byte cipherDataByte[] = Hex.decode(encryptDataHex);
//
//			//解密对象
//	    	ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyd, domainParameters);
//	    	SM2Engine sm2EngineDecrypt = new SM2Engine(Mode.C1C3C2);
//	    	sm2EngineDecrypt.init(false, privateKeyParameters);
//
//			byte[] arrayOfBytes = sm2EngineDecrypt.processBlock(cipherDataByte, 0, cipherDataByte.length);
//			String decryptData = new String(arrayOfBytes);
//			return decryptData;
//		} catch (InvalidCipherTextException e) {
//			e.printStackTrace();
//		}
//
//    	return null;
//    }
//
//    public static String decryptWithSalt(String encryptDataHex, String salt, BigInteger privateKey) {
//        String result = null;
//        if (StringUtils.isEmpty(salt)) {
//            result = "salt为空，解密异常";
//            logger.error(result);
//            return null;
//        }
//        result = decrypt(encryptDataHex, privateKey);
//        if (StringUtils.isEmpty(result)) {
//            result = "result为空，解密异常";
//            logger.error(result);
//            return null;
//        }
//        if (!salt.equals(result.substring(result.length() - length))) {
//            return null;
//        }
//        return result.substring(0, result.length() - length);
//    }
//
//    public SM2Util() {
//    }
//
//    /*public static void main(String[] args) {
//    	String encryptDataHex = "afpvqnhyG7FE1itQD05G7JryI1SNMg4bq+lgYed8+2YA7Pv5oLMSApxftU5hKd6SGlBTrCtYW9Pah879HqJqOAAp3sG4YknG+f2pO++DT2d1RAQO27nGIxV8uQd2xRCnqvPhgvyJnksCrcNmLDo7WmthJePptbyL4zJvfb76oeZtX14hzyTBVwNVOZfo9tUkwONHTbohKGr0c5jgpY1UQxYh+ZEo9Gq3JSkXGS0MmCQdkfGnZmDAYGqP6TRwvd6OzfBrHsuOpaL2+cAvc+GVhqazQM6/EYSps8r9odz1uPZm57LNsqgs4SZ5wQgXfySFddpn8NvNjf1zdTs2EWe30A==";
//    	String salt = "1T51QKXB25MZVRAA";
////    	String encryptDataHex = SM2Util.encryptWithSalt(input, salt);
//    	//String encryptDataHex = "04FD140449094F72E1F83F768D8EFA024F164F132031A25749E62AB834E7251210D47CFE1824195253321F7894BCA61ADCD4D3500764A84351A157C8B03BDB980F39E50BABC77B744E4EDF420F29C865DC4E592CB3DA8C745863DC54090758FB99AFF9CDEF97319B9AE28083686FC68CEFD9AE4FFB";
//        String string = SM2Util.decryptWithSalt(encryptDataHex, salt, null);
//        System.out.println(string);
//    }*/
//}
