package com.yizhi.util.application.sm2;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.*;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

/**
 * @Author: dzy
 * @Date: 2018/9/28 15:53
 * @Describe: SM2工具类
 */


@Data
@AllArgsConstructor
@NoArgsConstructor
class PCIKeyPair {
    private String priKey;      //私钥
    private String pubKey;      //公钥

}

@Slf4j
public class SM2_NEW {
    private static final Logger logger = LoggerFactory.getLogger(SM2_NEW.class);

    //    //测试公钥
//    private final static String PUBLIC_KEY = "022bcf8529edd6230643e8cd8d6860cff8f4fee53d7bdf7b2caee5b792eaa52a1c";
    //    //测试私钥
//    private final static String PRIVATE_KEY = "3777edc5733a12c35ad4ba8411751a5bab74c03a1824c9cf56023257fbe80153";
    //获取一条SM2曲线参数
    private static X9ECParameters sm2ECParameters = null;
    //构造domain参数
    private static ECDomainParameters domainParameters = null;
    //公有云目前的正式私钥解密参数
    private static BigInteger privateKeyD = new BigInteger("73606691747902606671812672174006787696677349435601496579172297108691018534217");
    //公有云目前的正式公钥

    private final static String PUBLIC_KEY = "047214fe3a249b75b6ba92ee494e0a8a68c0a19893a480b3c28bf06cd5b7d621243c7f6704caa3b43ade6be15de11cabd185611a9edfdcf1b11d7a2478c67b4c1c";
    private final static String PRIVATE_KEY = "00a2bbe941a177ca9f200d1c4d37e8f0b43b9cd2ea662304a05c064c6416e74d49";
    //16进制
    private static Integer RADIX = 16;
    //与前端约定的salt的长度
    private static int SALT_LENGTH = 16;


    static {
        sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");

        domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());

        //测试私钥生成解密必要数据
//        privateKeyD = new BigInteger(PRIVATE_KEY, RADIX);
    }


    /**
     * 生成SM2公私钥对
     *
     * @return
     */
    private static AsymmetricCipherKeyPair genKeyPair0() {

        //1.创建密钥生成器
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();

        //2.初始化生成器,带上随机数
        try {
            keyPairGenerator.init(new ECKeyGenerationParameters(domainParameters, SecureRandom.getInstance("SHA1PRNG")));
        } catch (NoSuchAlgorithmException e) {
            log.error("生成公私钥对时出现异常:", e);
            e.printStackTrace();
        }

        //3.生成密钥对
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        return asymmetricCipherKeyPair;
    }

    /**
     * 生成公私钥对(默认压缩公钥)
     *
     * @return
     */
    public static PCIKeyPair genKeyPair() {
        return genKeyPair(true);
    }

    /**
     * 生成公私钥对
     *
     * @param compressedPubKey 是否压缩公钥
     * @return
     */
    public static PCIKeyPair genKeyPair(boolean compressedPubKey) {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = genKeyPair0();

        //提取公钥点
        ECPoint ecPoint = ((ECPublicKeyParameters) asymmetricCipherKeyPair.getPublic()).getQ();
        //公钥前面的02或者03表示是压缩公钥,04表示未压缩公钥,04的时候,可以去掉前面的04
        String pubKey = Hex.toHexString(ecPoint.getEncoded(compressedPubKey));
        System.out.println("pubKey:" + pubKey);

        BigInteger privatekey = ((ECPrivateKeyParameters) asymmetricCipherKeyPair.getPrivate()).getD();
        String priKey = privatekey.toString(RADIX);
        System.out.println("priKey:" + priKey);

        PCIKeyPair keyPair = new PCIKeyPair(priKey, pubKey);
        return keyPair;
    }

    public static void main(String[] args) {
        String encryptString = "0417a403ec173b90c68037f64b4f167d44c0644642f47b3cb70a33ad6deb58d7bdd5c1433e9f44ed40479f70dcb8cda55919031d2432d079dc575f02f1c760c0c16c26a9e4528b5b7d32a9d089b5aaa9a00edf212c8f93bfc68b35b8d700f611d0e0804434574d35f51a85ed4415bc45ef0a8b49b9524e";
//        System.out.println("orginalString:" + orginalString);
//        String encryptString = encrypt(orginalString);
        System.out.println("encryptString:" + encryptString);
        String decryptString = decryptWithSalt(encryptString);
        System.out.println("decryptString:" + decryptString);
    }


//    /**
//     * 私钥签名
//     *
//     * @param privateKey 私钥
//     * @param content    待签名内容
//     * @return
//     */
//    public static String sign(String privateKey, String content) {
//        //待签名内容转为字节数组
//        byte[] message = Hex.decode(content);
//
//        //获取一条SM2曲线参数
//        X9ECParameters sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
//        //构造domain参数
//        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(),
//                sm2ECParameters.getG(), sm2ECParameters.getN());
//
//        BigInteger privateKeyD = new BigInteger(privateKey, 16);
//        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
//
//        //创建签名实例
//        SM2Signer sm2Signer = new SM2Signer();
//
//        //初始化签名实例,带上ID,国密的要求,ID默认值:1234567812345678
//        try {
//            sm2Signer.init(true, new ParametersWithID(new ParametersWithRandom(privateKeyParameters, SecureRandom.getInstance("SHA1PRNG")), Strings.toByteArray("1234567812345678")));
//        } catch (NoSuchAlgorithmException e) {
//            log.error("签名时出现异常:", e);
//        }
//
//        //生成签名,签名分为两部分r和s,分别对应索引0和1的数组
////        BigInteger[] bigIntegers = sm2Signer.generateSignature(message);
////
////        byte[] rBytes = modifyRSFixedBytes(bigIntegers[0].toByteArray());
////        byte[] sBytes = modifyRSFixedBytes(bigIntegers[1].toByteArray());
////
////        byte[] signBytes = ByteUtils.concatenate(rBytes, sBytes);
////        String sign = Hex.toHexString(signBytes);
//
//        return null;
//    }

    /**
     * 将R或者S修正为固定字节数
     *
     * @param rs
     * @return
     */
    private static byte[] modifyRSFixedBytes(byte[] rs) {
        int length = rs.length;
        int fixedLength = 32;
        byte[] result = new byte[fixedLength];
        if (length < 32) {
            System.arraycopy(rs, 0, result, fixedLength - length, length);
        } else {
            System.arraycopy(rs, length - fixedLength, result, 0, fixedLength);
        }
        return result;
    }

//    /**
//     * 验证签名
//     *
//     * @param publicKey 公钥
//     * @param content   待签名内容
//     * @param sign      签名值
//     * @return
//     */
//    public static boolean verify(String publicKey, String content, String sign) {
//        //待签名内容
//        byte[] message = Hex.decode(content);
//        byte[] signData = Hex.decode(sign);
//
//        // 获取一条SM2曲线参数
//        X9ECParameters sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
//        // 构造domain参数
//        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(),
//                sm2ECParameters.getG(),
//                sm2ECParameters.getN());
//        //提取公钥点
//        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(CommonUtils.hexString2byte(publicKey));
//        // 公钥前面的02或者03表示是压缩公钥，04表示未压缩公钥, 04的时候，可以去掉前面的04
//        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
//
//        //获取签名
//        BigInteger R = null;
//        BigInteger S = null;
//        byte[] rBy = new byte[33];
//        System.arraycopy(signData, 0, rBy, 1, 32);
//        rBy[0] = 0x00;
//        byte[] sBy = new byte[33];
//        System.arraycopy(signData, 32, sBy, 1, 32);
//        sBy[0] = 0x00;
//        R = new BigInteger(rBy);
//        S = new BigInteger(sBy);
//
//        //创建签名实例
//        SM2Signer sm2Signer = new SM2Signer();
//        ParametersWithID parametersWithID = new ParametersWithID(publicKeyParameters, Strings.toByteArray("1234567812345678"));
//        sm2Signer.init(false, parametersWithID);
//
//        //验证签名结果
////        boolean verify = sm2Signer.verifySignature(message, R, S);
//        return false;
//    }

    /**
     * SM2加密算法  常用
     *
     * @param data 数据
     * @return
     */
    public static String encrypt(String data) {
        if (StringUtils.isEmpty(data)) {
            logger.error("需要加密数据不能为空！！！");
            return null;
        }
        //提取公钥点
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(hexString2byte(PUBLIC_KEY));
        // 公钥前面的02或者03表示是压缩公钥，04表示未压缩公钥, 04的时候，可以去掉前面的04
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);

        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));

        byte[] arrayOfBytes = null;
        try {
            byte[] in = data.getBytes(StandardCharsets.UTF_8);
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        } catch (Exception e) {
            log.error("SM2加密时出现异常:", e);
        }
        return Hex.toHexString(arrayOfBytes);
    }

    /**
     * SM2加密算法 一般不用
     *
     * @param publicKey 公钥
     * @param data      明文数据
     * @return
     */
    public static String encrypt(PublicKey publicKey, String data) {

        ECPublicKeyParameters ecPublicKeyParameters = null;
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey bcecPublicKey = (BCECPublicKey) publicKey;
            ECParameterSpec ecParameterSpec = bcecPublicKey.getParameters();
            ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(),
                    ecParameterSpec.getG(), ecParameterSpec.getN());
            ecPublicKeyParameters = new ECPublicKeyParameters(bcecPublicKey.getQ(), ecDomainParameters);
        }

        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, new ParametersWithRandom(ecPublicKeyParameters, new SecureRandom()));

        byte[] arrayOfBytes = null;
        try {
            byte[] in = data.getBytes(StandardCharsets.UTF_8);
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        } catch (Exception e) {
            log.error("SM2加密时出现异常:", e);
        }
        return Hex.toHexString(arrayOfBytes);
    }

    /**
     * 随机生成指定长度字符串验证码
     *
     * @param length 长度
     * @return
     */
    public static String generateValidateCode4String(int length) {
//       RandomStringUtils.random(length);//产生5位长度的随机字符串

        //使用指定的字符生成5位长度的随机字符串
//        RandomStringUtils.random(length, new char[]{'a', 'b', 'c', 'd', 'e', 'f'});

        //生成指定长度的字母和数字的随机组合字符串
        String random = RandomStringUtils.randomAlphanumeric(length);

        random = random.toUpperCase();
        //生成随机数字字符串
//        RandomStringUtils.randomNumeric(length);
        logger.info("生成指定长度的字母和数字的随机组合字符串--salt:" + random);
        return random;
    }


//    public static void main(String[] args) {
//
////        String encryptString = "shyz";
//        String salt = generateValidateCode4String(SALT_LENGTH);
////        System.out.println("orginalString:" + orginalString);
//        String encryptString = encrypt("shyz" +salt);
//        System.out.println("encryptString:" + encryptString);
//        String decryptString = decryptWithSalt(encryptString);
//        System.out.println("decryptString:" + decryptString);
//    }

    /**
     * SM2解密算法
     *
     * @param cipherData 密文数据
     * @return
     */
    public static String decrypt(String cipherData) {
        if (StringUtils.isEmpty(cipherData)) {
            logger.error("需要解密的数据不能为空！！！");
            return null;
        }
        byte[] cipherDataByte = Hex.decode(cipherData);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, privateKeyParameters);

        String result = null;
        try {
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            result = new String(arrayOfBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            logger.error("解密参数异常:" + cipherData);
            e.printStackTrace();
        }
        return result;

    }

    /**
     * SM2解密算法    常用
     *
     * @param cipherData 密文数据
     * @return
     */
    public static String decryptWithSalt(String cipherData) {

        String result = null;
        //解密数据这里包含salt,真正的值需要去除salt
        try {
            result = decrypt(cipherData);
            logger.info("解密result:" + result);
        } catch (Exception e) {
            logger.error("decryptWithSalt--解密参数异常:" + cipherData);
            e.printStackTrace();
            result = "解密过程异常";
            logger.error(result);
        }
        if (StringUtils.isEmpty(result)) {
            result = "result为空，解密异常";
            logger.error(result);
            return "";
        }
        logger.info("salt:" + result.substring(result.length() - SALT_LENGTH));
        return result.substring(0, result.length() - SALT_LENGTH);
    }


    /**
     * SM2解密算法 一般不用
     *
     * @param privateKey 私钥
     * @param cipherData 密文数据
     * @return
     */
    public static String decrypt(PrivateKey privateKey, String cipherData) {
        byte[] cipherDataByte = Hex.decode(cipherData);

        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey) privateKey;
        ECParameterSpec ecParameterSpec = bcecPrivateKey.getParameters();

        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(),
                ecParameterSpec.getG(), ecParameterSpec.getN());

        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(bcecPrivateKey.getD(),
                ecDomainParameters);

        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, ecPrivateKeyParameters);

        String result = null;
        try {
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            return new String(arrayOfBytes, "utf-8");
        } catch (Exception e) {
            log.error("SM2解密时出现异常:", e);
        }
        return result;
    }

    /**
     * 将未压缩公钥压缩成压缩公钥
     *
     * @param pubKey 未压缩公钥(16进制,不要带头部04)
     * @return
     */
    public static String compressPubKey(String pubKey) {
//        pubKey = CustomStringUtils.append("04", pubKey);    //将未压缩公钥加上未压缩标识.
        // 获取一条SM2曲线参数
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
        // 构造domain参数
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(),
                sm2ECParameters.getG(),
                sm2ECParameters.getN());
        //提取公钥点
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(hexString2byte(pubKey));
        // 公钥前面的02或者03表示是压缩公钥，04表示未压缩公钥, 04的时候，可以去掉前面的04
//        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);

        String compressPubKey = Hex.toHexString(pukPoint.getEncoded(Boolean.TRUE));

        return compressPubKey;
    }

    /**
     * 将压缩的公钥解压为非压缩公钥
     *
     * @param compressKey 压缩公钥
     * @return
     */
    public static String unCompressPubKey(String compressKey) {
        // 获取一条SM2曲线参数
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
        // 构造domain参数
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(),
                sm2ECParameters.getG(),
                sm2ECParameters.getN());
        //提取公钥点
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(hexString2byte(compressKey));
        // 公钥前面的02或者03表示是压缩公钥，04表示未压缩公钥, 04的时候，可以去掉前面的04
//        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);

        String pubKey = Hex.toHexString(pukPoint.getEncoded(Boolean.FALSE));
        pubKey = pubKey.substring(2);       //去掉前面的04   (04的时候，可以去掉前面的04)

        return pubKey;
    }

    /**
     * @param hexString 16进制字符串    如:"33d20046" 转换为 0x33 0xD2 0x00 0x46
     * @return
     * @Title: hexString2byte
     * @Description: 16进制字符串转字节数组
     * @since: 0.0.1
     */
    public static byte[] hexString2byte(String hexString) {
        if (null == hexString || hexString.length() % 2 != 0 || hexString.contains("null")) {
            return null;
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = (byte) (Integer.parseInt(hexString.substring(i, i + 2), 16) & 0xff);
        }
        return bytes;
    }

}

