package com.yizhi.util.application.tree;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 树结构的基本节点
 *
 * @Author: shengchenglong
 * @Date: 2018/5/18 10:59
 */
@Data
public class CommonTree<K, N> implements Serializable, Comparable {

    /**
     * 当前节点标识
     */
    private K id;

    /**
     * 当前节点的父节点标识
     */
    private K pId;

    /**
     * 当前节点的父节点name
     */
    private String pName;

    /**
     * 当前节点名称
     */
    private String name;

    /**
     * 当前节点
     */
    private N node;

    private Integer right;

    private Integer left;

    private Integer sort;

    /**
     * 下层节点
     */
    private List<CommonTree> children;

    @Override
    public int compareTo(Object o) {
        CommonTree node = (CommonTree) o;
        if (null == node.getSort() || null == this.getSort()) {
            return 0;
        }
        return this.getSort() - node.getSort();
    }
}
