package com.yizhi.util.application.tree;

import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/18 11:04
 */
public class TreeBuilder {

    private static final Logger logger = LoggerFactory.getLogger(TreeBuilder.class);

    private Integer indexForRightLeftFun = 0;

    @Getter
    private List<CommonTree> dest = new ArrayList<>();

    @Getter
    private Set destSet = new HashSet();

    /**
     * 获得一个树形结构
     *
     * @param originList
     * @return
     */
    public List<CommonTree> treeList(List<CommonTree> originList, Object topKey) {
        List<CommonTree> list = new ArrayList<CommonTree>();
        if (CollectionUtils.isNotEmpty(originList)) {
            for (CommonTree x : originList) {
                if (null != x) {
                    if (x.getPId().equals(topKey)) {
                        x.setChildren(treeChild(originList, x));
                        list.add(x);
                    }
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<CommonTree> treeList(List<CommonTree> originList) {
        if (originList.size() == 1) {
            return originList;
        }
        HashSet topKeys = findTopKey(originList);

        List<CommonTree> list = new ArrayList<CommonTree>();
        if (CollectionUtils.isNotEmpty(originList)) {
            for (CommonTree x : originList) {
                if (null != x) {
                    if (topKeys.contains(x.getPId())) {
                        x.setChildren(treeChild(originList, x));
                        list.add(x);
                    }
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    /**
     * 获得子节点
     *
     * @param treeList
     * @param parent
     * @return
     */
    public List<CommonTree> treeChild(List<CommonTree> treeList, CommonTree parent) {
        List<CommonTree> tempList = new ArrayList<CommonTree>();
        if (CollectionUtils.isNotEmpty(treeList)) {
            for (CommonTree a : treeList) {
                if (null != a) {
                    if (a.getPId().equals(parent.getId())) {
                        a.setChildren(treeChild(treeList, a));
                        a.setPName(parent.getName());
                        tempList.add(a);
                    }
                }
            }
        }
        Collections.sort(tempList);
        return tempList;
    }

    /**
     * 获取某一tree以及下面的所有子节点
     *
     * @param all 整个树形结构
     * @param id  需要拿取的tree
     * @return
     */
    public CommonTree getChildList(List<CommonTree> all, Object id) {
        CommonTree temp = null;
        if (CollectionUtils.isNotEmpty(all)) {
            for (CommonTree tree : all) {
                if (null != tree) {
                    if (tree.getId().equals(id)) {
                        temp = tree;
                        break;
                    } else {
                        List<CommonTree> children = tree.getChildren();
                        if (CollectionUtils.isNotEmpty(children)) {
                            temp = getChildList(children, id);
                        }
                    }
                }
                if (temp != null) {
                    break;
                }
            }
        }
        return temp;
    }


//    /**
//     * 遍历树，并返回所有节点
//     *
//     * @param origin
//     * @param dest
//     * @return
//     */
//    public List<CommonTree> traverseTreeRightLeft(List<CommonTree> origin, List<CommonTree> dest, int index) {
//        if (!CollectionUtils.isEmpty(origin)) {
//            for (CommonTree tree : origin) {
//                index++;
//                tree.setLeft(index);
//                dest.add(tree);
//                List<CommonTree> children = tree.getChildren();
//                if (!CollectionUtils.isEmpty(children)) {
//                    traverseTreeRightLeft(children, dest, index);
//                } else {
//                    index++;
//                    tree.setRight(index);
//                }
//            }
//        }
//        return dest;
//    }

    /**
     * 遍历树，并返回所有节点
     *
     * @param origin
     * @return
     */
    public void traverseTreeRightLeft(List<CommonTree> origin) {
        if (!CollectionUtils.isEmpty(origin)) {
            for (CommonTree tree : origin) {
                tree.setLeft(++indexForRightLeftFun);
                dest.add(tree);
                List<CommonTree> children = tree.getChildren();
                if (!CollectionUtils.isEmpty(children)) {
                    traverseTreeRightLeft(children);
                    ++indexForRightLeftFun;
                } else {
                    tree.setRight(++indexForRightLeftFun);
                }
            }
        }
    }

    /**
     * 遍历树，并返回所有节点
     *
     * @param origin
     * @return
     */
    public void traverseTree(List<CommonTree> origin) {
        if (!CollectionUtils.isEmpty(origin)) {
            for (CommonTree tree : origin) {
                dest.add(tree);
                List<CommonTree> children = tree.getChildren();
                if (!CollectionUtils.isEmpty(children)) {
                    traverseTree(children);
                }
            }
        }
    }

    /**
     * 遍历树，并返回所有id
     *
     * @param origin
     * @return
     */
    public void traverseTreeId(List<CommonTree> origin) {
        if (!CollectionUtils.isEmpty(origin)) {
            for (CommonTree tree : origin) {
                destSet.add(tree.getId());
                List<CommonTree> children = tree.getChildren();
                if (!CollectionUtils.isEmpty(children)) {
                    traverseTreeId(children);
                }
            }
        }
    }

    /**
     * 寻找父id
     *
     * @param originList
     * @return
     */
    private HashSet findTopKey(List<CommonTree> originList) {
        if (!CollectionUtils.isEmpty(originList)) {
            Set ids = new HashSet();
            Set pIds = new HashSet();

            for (CommonTree tree : originList) {
                ids.add(tree.getId());
                pIds.add(tree.getPId());
            }

            HashSet topKeys = new HashSet();
            for (Object o : pIds) {
                if (!ids.contains(o)) {
                    topKeys.add(o);
                }
            }
            return topKeys;
        }
        return null;
    }


}
