package com.yizhi.util.application.validation;

import java.util.List;

import org.springframework.validation.FieldError;

import com.yizhi.util.application.constant.ReturnCode;

/**
 * 校验辅助类
 * @author scott
 *
 */
public class ValidUtil {
	
	/**
	 * 参数校验错误对象转换为字符串
	 * @param errors
	 * @return
	 */
	public static String convertParamError(List<FieldError> errors) {
		StringBuilder sb = new StringBuilder();
		sb.append("code:").append(ReturnCode.PARAM_INVALID).append(System.lineSeparator());
		sb.append("message:").append(System.lineSeparator());
		for (FieldError fieldError : errors) {
		    sb.append(fieldError.getField()).append(fieldError.getDefaultMessage()).append(System.lineSeparator());	
		}
		
		return sb.toString();
	}

}
