import static org.junit.Assert.assertTrue;

import org.junit.Ignore;
import org.junit.Test;

import com.yizhi.util.application.qrcode.QRCodeUtil;


/**
 * 生成二维码工具类
 * @author xingliang
 *
 */
@Ignore
public class QRCodeTest {

	/**
	 *
	* @Function: QRCodeTest.java
	* @Description: 根据文本内容生成二维码测试类
	*
	* @param:
	* @return：
	* @throws：
	*
	* @author: xingliang
	* @date: 2018年1月26日 上午10:32:16
	*
	* 2018年1月26日     xingliang
	 */
	@Test
	public void test() {
		String text = "QRCode====junit======";
        try {
			QRCodeUtil.encode(text, "D://a//002.png", "D://a", true,"QRCodeJunit");
			System.out.println("运行结束");
		} catch (Exception e) {
			e.printStackTrace();
		}
        assertTrue(true);

	}

	/**
	 *
	* @Function: QRCodeTest.java
	* @Description: 根据文本内容 绘制二维码 测试类，并解析
	*
	* @param:
	* @return：
	* @throws：
	*
	* @author: xingliang
	* @date: 2018年1月26日 上午10:32:56
	*
	* 2018年1月26日     xingliang
	 */
	@Test
	public void test2() {
      String text = "http://www.baidu.com";
      try {
		QRCodeUtil.encode(text, "D://a//001.png", "D://a", true,"QRCode");
	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
      System.out.println("运行结束");

      //二维码解码
      String msg = "";
	try {
		msg = QRCodeUtil.decode("D://a//QRCodeJunit.jpg");
	} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
      System.out.println("解码==== " + msg);
	}


	/**
	 *
	* @Function: QRCodeTest.java
	* @Description: 根据生成的二维码转成 BASE64 编码
	*
	* @param:
	* @return：
	* @throws：
	*
	* @author: xingliang
	* @date: 2018年1月26日 上午10:33:39
	*
	* 2018年1月26日     xingliang
	 */
	@Test
	public void encodeToBASE64() {
		String text = "QRCode====junit===ccccccc===";
        try {
			String base64 = QRCodeUtil.encodeToBASE64(text, "D://a//002.png", "D://a", true,"QRCodeJunit");
			System.out.println("运行结束"+base64);
		} catch (Exception e) {
			e.printStackTrace();
		}
        assertTrue(true);

	}

}
