$.views.settings.allowCode(true);
$.views.converters("getResponseModelName", function(val) {
  return getResponseModelName(val);
});

var tempBody = $.templates('#temp_body');

//获取context path
var contextPath = getContextPath();
function getContextPath() {
  var pathName = document.location.pathname;
  var index = pathName.substr(1).indexOf("/");
  var result = pathName.substr(0,index+1);
  return result;
}

$(function(){
	var apiLocation;
    $.ajax({
        url : "/swagger-resources",
        dataType : "json",
        type : "get",
        async : false,
        success : function(data) {
            var jsonData = eval(data);
            apiLocation = jsonData[0].location;
        }
    });
    
    $.ajax({
        url : apiLocation,
        dataType : "json",
        type : "get",
        async : false,
        success : function(data) {
            //layui init
            layui.use([ 'layer','jquery', 'element' ], function() {
	            var $ = layui.jquery, layer = layui.layer, element = layui.element;
	        });
            var jsonData = eval(data);
            
            $("#title").html(jsonData.info.title);
            $("body").html($("#template").render(jsonData));
            
            $("[name='a_path']").click(function(){
	            var path = $(this).attr("path");
	            var method = $(this).attr("method");
	            var operationId = $(this).attr("operationId");
	            $.each(jsonData.paths[path],function(i,d){
	              if(d.operationId == operationId){
                      d.path = path;
                      d.method = method;
		              $("#path-body").html(tempBody.render(d));
                      var modelName = getResponseModelName(d.responses["200"]["schema"]["$ref"]);
                      if(modelName){
                    	  var responseModel ={};
                    	  responseModel.simple = {};
                    	  responseModel.composite = {};
                    	  var model = jsonData.definitions[modelName].properties;
                    	  for(key in model){
                    		  if(key == "data"){
                    			  var realModelName = modelName.replace(/responseOf/,"");
                    			  var realModel = jsonData.definitions[realModelName].properties;
                    			  var dataModel = analyzeModel(jsonData,key,realModelName,realModel);
                    			  responseModel.composite[key] = dataModel;
                    		  }else
                    			  responseModel.simple[key] = model[key];
                    	  }
                    	  
                    	  responseModel.layers = 1 + responseModel.composite["data"].layers;
                    	  responseModel.attrCount = responseModel.composite["data"].attrCount + Object.getOwnPropertyNames(responseModel.simple).length;
                    	  $("#responseAttrHead").attr("colSpan",responseModel.layers);
                    	  var modelHtml = constructModelHtml(responseModel);
                    	  $("#path-body-response-model").html(modelHtml);
                      }
                      

                      var subCode = d["x-subCode"];
                      var subCodeHtml;
                      for (key in subCode)  
                        {  
                    	  subCodeHtml = subCodeHtml + "<tr><td>" + key + "</td><td>" + subCode[key] + "</td><tr>";  
                        } 
                      $("#path-body-response-error").html(subCodeHtml);
	              }
	            });
	        });
	        
	       //提交测试按钮
	       $("[name='btn_submit']").click(function(){
                var operationId = $(this).attr("operationId");
                var parameterJson = {};
                $("input[operationId='"+operationId+"']").each(function(index, domEle){
                    var k = $(domEle).attr("name");
                    var v = $(domEle).val();
                    parameterJson.push({k:v});
                });
            });
        }
    });
    
});


function getResponseModelName(val){
  if(!val){
    return null;
  }
  return val.substring(val.lastIndexOf("/")+1,val.length);
}

// 分析响应数据,构造响应模型数据
function analyzeModel(jsonData,modelKey,modelName,model){
	  var result ={};
	  
	  result.simple ={};
	  result.composite = {};
	  var properties = jsonData.definitions[modelName].properties;
	  for(var key in properties){
		  var refModel = model[key]["$ref"];
		  if(refModel == null &&  model[key]["items"] != null)
		  var refModel = model[key]["items"]["$ref"];
		  if(refModel){
			  var innerModelName = getResponseModelName(refModel);
			  var innerModel = jsonData.definitions[innerModelName].properties;
			  result.composite[key] = analyzeModel(jsonData,key,innerModelName,innerModel);
		  }else{
			  result.simple[key] = model[key];
		  }
	  }
	  
	  result.name = modelKey;
	  result.attrCount = getModelAttrCount(result);
	  result.layers = getModelLayers(result);
	  return result;
}

//获得模型属性数量,包括简单属性和嵌套模型的简单属性数量
function getModelAttrCount(model){
	  var attrCount = Object.getOwnPropertyNames(model.simple).length;
	  for(var key in model.composite){
		  attrCount += getModelAttrCount(model.composite[key]);
	  }
	  
	  model.attrCount = attrCount;
	  return attrCount;
} 

// 获得模型嵌套层数
function getModelLayers(model){
	  
	  var innerLayers = 0;
	  var tempLayers;
	  for(var key in model.composite){
		  tempLayers = getModelLayers(model.composite[key]);
		  if( tempLayers > innerLayers)
			  innerLayers = tempLayers;
	  }
	  
	  model.layers = innerLayers + 1;
	  return  model.layers;
} 

// 组装模型显示文本
function constructModelHtml(model){
	  var modelHtml;
 
	  index =0;
	  for (var key in model.simple)  
	  {  
		  modelHtml = modelHtml + "<tr>";
		  if(index == 0 && model.name)
			  modelHtml = modelHtml + "<td rowSpan='" +model.attrCount + "'>" + model.name +  "</td>";
			  
		  modelHtml = modelHtml + "<td colSpan='" + model.layers + "'>" + key + "</td>";
		  modelHtml = modelHtml +  "<td>" + model.simple[key].type  + "</td><td>" + model.simple[key].description +"</td></tr>";  
		  index ++;
	  } 
	  
	  for (var key in model.composite)  
	  {  
		  modelHtml += constructModelHtml(model.composite[key]);
	  }
	  
	  return modelHtml;
}

//测试按钮，获取数据
function getData(operationId){
   var path = contextPath + $("[m_operationId='"+operationId+"']").attr("path");
   //path 参数
   $("[p_operationId='"+operationId+"'][in='path']").each(function(index, domEle){
       var k = $(domEle).attr("name");
       var v = $(domEle).val();
       if(v){
           path = path.replace("{"+k+"}",v);
       }
   });
   
   //请求方式
   var parameterType = $("#content_type_"+operationId).val();
   
   //query 参数
   var parameterJson = {};
   if("form" == parameterType){
       $("[p_operationId='"+operationId+"'][in='query']").each(function(index, domEle){
           var k = $(domEle).attr("name");
           var v = $(domEle).val();
           if(v){
               parameterJson[k] = v;
           }
       });
   }else if("json" == parameterType){
       var str = $("#text_tp_"+operationId).val();
       try{
           parameterJson = JSON.parse(str); 
       }catch(error){
           layer.msg(""+error,{icon:5});
           return false;
       }
   }
   
   //发送请求
   $.ajax({
	   type: $("[m_operationId='"+operationId+"']").attr("method"),
	   url: path,
	   data: parameterJson,
	   dataType: 'json',
	   success: function(data){
	     var options = {
          withQuotes: true
         };
	     $("#json-response").jsonViewer(data, options);
	   }
   });
}


//请求类型
function changeParameterType(el){
    var operationId = $(el).attr("operationId");
    var type = $(el).attr("type");
    $("#content_type_"+operationId).val(type);
    $(el).addClass("layui-btn-normal").removeClass("layui-btn-primary");
    if("form" == type){
        $("#text_tp_"+operationId).hide();
        $("#table_tp_"+operationId).show();
        $("#pt_json_"+operationId).addClass("layui-btn-primary").removeClass("layui-btn-normal");
    }else if("json" == type){
       $("#text_tp_"+operationId).show();
       $("#table_tp_"+operationId).hide();
       $("#pt_form_"+operationId).addClass("layui-btn-primary").removeClass("layui-btn-normal");
    }
}
