/**
 * 
 */
package com.yizhi.core.application.event;

import java.io.Serializable;

/**
 * 事件类
 * 微服务通过消息队列发送事件,实现分布式事务
 * @author scotthu
 *
 * @date 2018年3月5日
 */
public class EventWrapper<T> implements Serializable{
	
	private static final long serialVersionUID = 7793211664726867177L;

	/**
	 * 事件标识
	 */
	private Long id;
	
	/**
	 * 事件数据
	 */
	private T data;
	
	
	public EventWrapper(Long id,T data) {
		this.setId(id);
		this.data = data;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

}
