package com.yizhi.core.application.exception;

import com.yizhi.core.application.enums.InternationalEnums;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

import lombok.Data;

/**
 * 业务过程执行异常
 * @author yinyuyan
 */
@ResponseStatus(HttpStatus.NOT_FOUND)
//@Data
public class BizException extends RuntimeException{

	private static final long serialVersionUID = 2813349230951445006L;
	private String code;
	private String msg;
	public BizException(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public BizException(InternationalEnums errorEnum) {
		this.code = errorEnum.getCode();
		this.msg = errorEnum.getName();
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
}
