/**
 * 
 */
package com.yizhi.core.application.file.imp;

import java.util.List;

import com.yizhi.core.application.task.TaskHandler;

/**
 * 导入回调类
 * 不同业务的保存逻辑使用此接口进行扩展
 * 使用时可以创建一个实现此接口的匿名类
 * @author scotthu
 *
 * @date 2018年1月30日
 */
public interface ImportCallBack {
	
	/**
	 * 
	 * 执行回调逻辑,不同业务进行数据保存时执行这个方法
	 * @param taskHandler 任务处理器,可调用它进行事件发布
	 * @param dataObjs 数据列表
	 * @return true 成功,false 失败
	 */
	Boolean exec(TaskHandler taskHandler, List dataObjs);

}
