/**
 * 
 */
package com.yizhi.core.application.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.event.LogEvent;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.log.LogQueue;
import com.yizhi.core.application.log.TaskLogEvent;

/**
 * 抽象任务处理器
 * @author scotthu
 *
 * @date 2018年2月26日
 */
public abstract class AbstractTaskHandler implements TaskHandler {
	
	private static final Logger logger = LoggerFactory.getLogger(AbstractTaskHandler.class);
	
	
	protected LogEventPublisher publisher;
	protected TaskContext taskContext;
	
	public AbstractTaskHandler() {

	}
	
	public AbstractTaskHandler bindContext(TaskContext ctx) {
		this.taskContext = ctx;
		return this;
	}
	public AbstractTaskHandler bindPublisher(LogEventPublisher publisher) {
		this.publisher = publisher;
		return this;
	}
	
	/**
	 * 发送任务日志
	 * @param content
	 */
	public void publishTaskEvent(TaskLogEvent taskLog) {
		if(publisher == null) {
			logger.warn("task event publisher does not exist");
			logger.debug("task info:{}",taskLog);
			return;
		}
		
		LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE,taskLog);
		publisher.publish(event);
		logger.debug("send a task event:{}",event);
	}
	
}
